/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.Exon;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.Transcript;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import java.util.Collection;
import java.util.HashMap;

public class Gene
extends HashMap<String, Transcript>
implements Comparable<Gene> {
    private Region region;
    private String name;
    private String biotype;
    private String id;

    public Gene(String name, String biotype, String id) {
        this.name = name;
        this.biotype = biotype;
        this.id = id;
    }

    @Override
    public int compareTo(Gene other) {
        return this.id.compareTo(other.id);
    }

    private String getBiotype() {
        return this.biotype;
    }

    @Override
    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Gene) {
            return this.compareTo((Gene)o) == 0;
        }
        return false;
    }

    @Override
    public String toString() {
        return this.region.toString(true) + ", " + this.name;
    }

    public Region getRegion() {
        return this.region;
    }

    public void addTranscript(String transcId, Transcript transcript) {
        this.put(transcId, transcript);
    }

    public Collection<Transcript> getTranscripts() {
        return this.values();
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public void addExon(Exon exon, String geneId, String transcId, String transcName) {
        Transcript transc = (Transcript)this.get(transcId);
        if (transc == null) {
            transc = new Transcript(transcName, this, transcId);
            this.put(transcId, transc);
        }
        exon.setTranscript(transc);
        transc.addExon(exon, transcId);
        if (this.region == null) {
            try {
                this.region = transc.getRegion().clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        } else {
            this.region = this.region.fill(transc.getRegion());
        }
    }

    public void setRegion(Region region) {
        this.region = region;
    }
}

