/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.screen;

import fi.csc.microarray.client.screen.Screen;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.KeyStroke;

public class ChildScreenPool {
    private HashMap<String, Screen> childScreens = new HashMap();
    private JFrame mainFrame;

    public ChildScreenPool(JFrame main) {
        this.mainFrame = main;
    }

    public void put(String name, Screen childScreen) {
        this.childScreens.put(name, childScreen);
        for (Component comp : childScreen.getFrame().getComponents()) {
            if (!(comp instanceof JComponent)) continue;
            JComponent jcomp = (JComponent)comp;
            jcomp.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "ChildScreenClose");
            jcomp.getActionMap().put("ChildScreenClose", new KeyShortcutAction(childScreen));
            break;
        }
    }

    public Screen get(String screenName) {
        return this.childScreens.get(screenName);
    }

    public Iterator<Screen> getScreenIterator() {
        return this.childScreens.values().iterator();
    }

    public void show(String screenName, boolean packed, Object parameter) {
        this.childScreens.get(screenName).setChildScreenParameter(parameter);
        this.show(screenName, packed);
    }

    public void show(String screenName, boolean packed) {
        JFrame frame = this.childScreens.get(screenName).getFrame();
        if (packed) {
            frame.pack();
        }
        frame.setLocationRelativeTo(this.mainFrame);
        frame.setVisible(true);
    }

    public void disposeAll() {
        for (Screen screen : this.childScreens.values()) {
            if (!screen.hasFrame()) continue;
            screen.getFrame().dispose();
        }
    }

    public boolean hasScreen(String screenName) {
        return this.childScreens.get(screenName) != null;
    }

    private class KeyShortcutAction
    implements Action {
        private Screen screen;

        public KeyShortcutAction(Screen screen) {
            this.screen = screen;
        }

        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public Object getValue(String key) {
            return null;
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void putValue(String key, Object value) {
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public void setEnabled(boolean b) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.screen.getFrame().dispose();
        }
    }
}

