/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui.filetree;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import javax.swing.tree.DefaultMutableTreeNode;

public class FileNode
extends DefaultMutableTreeNode
implements Transferable,
Serializable {
    private boolean explored = false;
    public static DataFlavor FILENODE = new DataFlavor(class$org$emboss$jemboss$gui$filetree$FileNode == null ? (class$org$emboss$jemboss$gui$filetree$FileNode = FileNode.class$("org.emboss.jemboss.gui.filetree.FileNode")) : class$org$emboss$jemboss$gui$filetree$FileNode, "Remote file");
    static DataFlavor[] flavors = new DataFlavor[]{FILENODE, DataFlavor.stringFlavor};
    static /* synthetic */ Class class$org$emboss$jemboss$gui$filetree$FileNode;

    public FileNode(File file) {
        this.setUserObject(file);
    }

    public boolean getAllowsChildren() {
        return this.isDirectory();
    }

    public boolean isLeaf() {
        return !this.isDirectory();
    }

    public File getFile() {
        return (File)this.getUserObject();
    }

    public boolean isExplored() {
        return this.explored;
    }

    public boolean isDirectory() {
        File file = this.getFile();
        return file.isDirectory();
    }

    public String toString() {
        File file = (File)this.getUserObject();
        String string = file.toString();
        int n = string.lastIndexOf(File.separator);
        return n != -1 && n != string.length() - 1 ? string.substring(n + 1) : string;
    }

    public void explore() {
        if (!this.isDirectory()) {
            return;
        }
        if (!this.isExplored()) {
            File file = this.getFile();
            this.explored = true;
            Object[] objectArray = file.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return !string.startsWith(".");
                }
            });
            Arrays.sort(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                this.add(new FileNode((File)objectArray[i]));
            }
        }
    }

    public void reExplore() {
        this.explored = false;
        this.removeAllChildren();
        this.explore();
    }

    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor.equals(FILENODE) || dataFlavor.equals(DataFlavor.stringFlavor);
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.equals(FILENODE)) {
            return this;
        }
        if (dataFlavor.equals(DataFlavor.stringFlavor)) {
            return this.getFile().getAbsolutePath();
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

