/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertiesParser {
    private PropertiesParser() {
    }

    public static String parseUri(String uri, Properties properties, String prefixToken, String suffixToken) throws IllegalArgumentException {
        String answer = uri;
        boolean done = false;
        ArrayList<String> visited = new ArrayList<String>();
        while (!done) {
            ArrayList<String> replaced = new ArrayList<String>();
            answer = PropertiesParser.doParseUri(answer, properties, replaced, prefixToken, suffixToken);
            for (String replace : replaced) {
                if (!visited.contains(replace)) continue;
                throw new IllegalArgumentException("Circular reference detected with key [" + replace + "] in uri " + uri);
            }
            visited.addAll(replaced);
            done = !answer.contains(prefixToken);
        }
        return answer;
    }

    private static String doParseUri(String uri, Properties properties, List<String> replaced, String prefixToken, String suffixToken) {
        StringBuilder sb = new StringBuilder();
        int pivot = 0;
        int size = uri.length();
        while (pivot < size) {
            int endIdx;
            int idx = uri.indexOf(prefixToken, pivot);
            if (idx < 0) {
                sb.append(PropertiesParser.createConstantPart(uri, pivot, size));
                break;
            }
            if (pivot < idx) {
                sb.append(PropertiesParser.createConstantPart(uri, pivot, idx));
            }
            if ((endIdx = uri.indexOf(suffixToken, pivot = idx + prefixToken.length())) < 0) {
                throw new IllegalArgumentException("Expecting " + suffixToken + " but found end of string for uri: " + uri);
            }
            String key = uri.substring(pivot, endIdx);
            String part = PropertiesParser.createPlaceholderPart(key, properties, replaced);
            if (part == null) {
                throw new IllegalArgumentException("Property with key [" + key + "] not found in properties for uri: " + uri);
            }
            sb.append(part);
            pivot = endIdx + suffixToken.length();
        }
        return sb.toString();
    }

    private static String createConstantPart(String uri, int start, int end) {
        return uri.substring(start, end);
    }

    private static String createPlaceholderPart(String placeholderPart, Properties properties, List<String> replaced) {
        replaced.add(placeholderPart);
        return properties.getProperty(placeholderPart);
    }
}

