/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import org.apache.activemq.util.ByteSequence;

public final class DataByteArrayInputStream
extends InputStream
implements DataInput {
    private byte[] buf;
    private int pos;
    private int offset;

    public DataByteArrayInputStream(byte[] buf) {
        this.buf = buf;
        this.pos = 0;
        this.offset = 0;
    }

    public DataByteArrayInputStream(ByteSequence sequence) {
        this.buf = sequence.getData();
        this.pos = this.offset = sequence.getOffset();
    }

    public DataByteArrayInputStream() {
        this(new byte[0]);
    }

    public int size() {
        return this.pos - this.offset;
    }

    public byte[] getRawData() {
        return this.buf;
    }

    public void restart(byte[] newBuff) {
        this.buf = newBuff;
        this.pos = 0;
    }

    public void restart(ByteSequence sequence) {
        this.buf = sequence.getData();
        this.pos = sequence.getOffset();
    }

    public void restart(int size) {
        if (this.buf == null || this.buf.length < size) {
            this.buf = new byte[size];
        }
        this.restart(this.buf);
    }

    public int read() {
        return this.pos < this.buf.length ? this.buf[this.pos++] & 0xFF : -1;
    }

    public int read(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (this.pos >= this.buf.length) {
            return -1;
        }
        if (this.pos + len > this.buf.length) {
            len = this.buf.length - this.pos;
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, b, off, len);
        this.pos += len;
        return len;
    }

    public int available() {
        return this.buf.length - this.pos;
    }

    public void readFully(byte[] b) {
        this.read(b, 0, b.length);
    }

    public void readFully(byte[] b, int off, int len) {
        this.read(b, off, len);
    }

    public int skipBytes(int n) {
        if (this.pos + n > this.buf.length) {
            n = this.buf.length - this.pos;
        }
        if (n < 0) {
            return 0;
        }
        this.pos += n;
        return n;
    }

    public boolean readBoolean() {
        return this.read() != 0;
    }

    public byte readByte() {
        return (byte)this.read();
    }

    public int readUnsignedByte() {
        return this.read();
    }

    public short readShort() {
        int ch1 = this.read();
        int ch2 = this.read();
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    public int readUnsignedShort() {
        int ch1 = this.read();
        int ch2 = this.read();
        return (ch1 << 8) + (ch2 << 0);
    }

    public char readChar() {
        int ch1 = this.read();
        int ch2 = this.read();
        return (char)((ch1 << 8) + (ch2 << 0));
    }

    public int readInt() {
        int ch1 = this.read();
        int ch2 = this.read();
        int ch3 = this.read();
        int ch4 = this.read();
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public long readLong() {
        long rc = ((long)this.buf[this.pos++] << 56) + ((long)(this.buf[this.pos++] & 0xFF) << 48) + ((long)(this.buf[this.pos++] & 0xFF) << 40) + ((long)(this.buf[this.pos++] & 0xFF) << 32);
        return rc + ((long)(this.buf[this.pos++] & 0xFF) << 24) + (long)((this.buf[this.pos++] & 0xFF) << 16) + (long)((this.buf[this.pos++] & 0xFF) << 8) + (long)((this.buf[this.pos++] & 0xFF) << 0);
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public String readLine() {
        int c;
        int start = this.pos;
        while (this.pos < this.buf.length && (c = this.read()) != 10) {
            if (c != 13) continue;
            c = this.read();
            if (c == 10 || c == -1) break;
            --this.pos;
            break;
        }
        return new String(this.buf, start, this.pos);
    }

    public String readUTF() throws IOException {
        int c;
        int length = this.readUnsignedShort();
        char[] characters = new char[length];
        int count = 0;
        int total = this.pos + length;
        while (this.pos < total && (c = this.buf[this.pos] & 0xFF) <= 127) {
            ++this.pos;
            characters[count++] = (char)c;
        }
        block6: while (this.pos < total) {
            c = this.buf[this.pos] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++this.pos;
                    characters[count++] = (char)c;
                    continue block6;
                }
                case 12: 
                case 13: {
                    this.pos += 2;
                    if (this.pos > total) {
                        throw new UTFDataFormatException("bad string");
                    }
                    byte c2 = this.buf[this.pos - 1];
                    if ((c2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("bad string");
                    }
                    characters[count++] = (char)((c & 0x1F) << 6 | c2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    this.pos += 3;
                    if (this.pos > total) {
                        throw new UTFDataFormatException("bad string");
                    }
                    byte c2 = this.buf[this.pos - 2];
                    byte c3 = this.buf[this.pos - 1];
                    if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("bad string");
                    }
                    characters[count++] = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | (c3 & 0x3F) << 0);
                    continue block6;
                }
            }
            throw new UTFDataFormatException("bad string");
        }
        return new String(characters, 0, count);
    }
}

