/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.SendProcessor;
import org.apache.camel.spi.Required;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class SendDefinition<Type extends ProcessorDefinition<Type>>
extends ProcessorDefinition<Type> {
    @XmlAttribute(required=false)
    protected String uri;
    @XmlAttribute(required=false)
    protected String ref;
    @XmlTransient
    protected Endpoint endpoint;

    public SendDefinition() {
    }

    public SendDefinition(String uri) {
        this.uri = uri;
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        Endpoint endpoint = this.resolveEndpoint(routeContext);
        return new SendProcessor(endpoint, this.getPattern());
    }

    public Endpoint resolveEndpoint(RouteContext context) {
        if (this.endpoint == null) {
            return context.resolveEndpoint(this.getUri(), this.getRef());
        }
        return this.endpoint;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getUri() {
        return this.uri;
    }

    @Required
    public void setUri(String uri) {
        this.uri = uri;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public ExchangePattern getPattern() {
        return null;
    }

    @Override
    public List<ProcessorDefinition> getOutputs() {
        return Collections.emptyList();
    }

    public String getUriOrRef() {
        String uri = this.getUri();
        if (ObjectHelper.isNotEmpty(uri)) {
            return uri;
        }
        if (this.endpoint != null) {
            return this.endpoint.getEndpointUri();
        }
        return this.getRef();
    }

    @Override
    public String getLabel() {
        return FromDefinition.description(this.getUri(), this.getRef(), this.getEndpoint());
    }
}

