/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.Date;
import org.apache.camel.management.PerformanceCounter;
import org.apache.camel.management.mbean.ManagedCounter;
import org.apache.camel.spi.ManagementStrategy;
import org.fusesource.commons.management.Statistic;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource(description="PerformanceCounter")
public abstract class ManagedPerformanceCounter
extends ManagedCounter
implements PerformanceCounter {
    private Statistic exchangesCompleted;
    private Statistic exchangesFailed;
    private Statistic minProcessingTime;
    private Statistic maxProcessingTime;
    private Statistic totalProcessingTime;
    private Statistic lastProcessingTime;
    private Statistic meanProcessingTime;
    private Statistic firstExchangeCompletedTimestamp;
    private Statistic firstExchangeFailureTimestamp;
    private Statistic lastExchangeCompletedTimestamp;
    private Statistic lastExchangeFailureTimestamp;
    private boolean statisticsEnabled = true;

    public void init(ManagementStrategy strategy) {
        super.init(strategy);
        this.exchangesCompleted = strategy.createStatistic("org.apache.camel.exchangesCompleted", this, Statistic.UpdateMode.COUNTER);
        this.exchangesFailed = strategy.createStatistic("org.apache.camel.exchangesFailed", this, Statistic.UpdateMode.COUNTER);
        this.minProcessingTime = strategy.createStatistic("org.apache.camel.minimumProcessingTime", this, Statistic.UpdateMode.MINIMUM);
        this.maxProcessingTime = strategy.createStatistic("org.apache.camel.maximumProcessingTime", this, Statistic.UpdateMode.MAXIMUM);
        this.totalProcessingTime = strategy.createStatistic("org.apache.camel.totalProcessingTime", this, Statistic.UpdateMode.COUNTER);
        this.lastProcessingTime = strategy.createStatistic("org.apache.camel.lastProcessingTime", this, Statistic.UpdateMode.VALUE);
        this.meanProcessingTime = strategy.createStatistic("org.apache.camel.meanProcessingTime", this, Statistic.UpdateMode.VALUE);
        this.firstExchangeCompletedTimestamp = strategy.createStatistic("org.apache.camel.firstExchangeCompletedTimestamp", this, Statistic.UpdateMode.VALUE);
        this.firstExchangeFailureTimestamp = strategy.createStatistic("org.apache.camel.firstExchangeFailureTimestamp", this, Statistic.UpdateMode.VALUE);
        this.lastExchangeCompletedTimestamp = strategy.createStatistic("org.apache.camel.lastExchangeCompletedTimestamp", this, Statistic.UpdateMode.VALUE);
        this.lastExchangeFailureTimestamp = strategy.createStatistic("org.apache.camel.lastExchangeFailureTimestamp", this, Statistic.UpdateMode.VALUE);
    }

    @ManagedOperation(description="Reset counters")
    public synchronized void reset() {
        super.reset();
        this.exchangesCompleted.reset();
        this.exchangesFailed.reset();
        this.minProcessingTime.reset();
        this.maxProcessingTime.reset();
        this.totalProcessingTime.reset();
        this.lastProcessingTime.reset();
        this.meanProcessingTime.reset();
        this.firstExchangeCompletedTimestamp.reset();
        this.firstExchangeFailureTimestamp.reset();
        this.lastExchangeCompletedTimestamp.reset();
        this.lastExchangeFailureTimestamp.reset();
    }

    @ManagedAttribute(description="Number of completed exchanges")
    public long getExchangesCompleted() throws Exception {
        return this.exchangesCompleted.getValue();
    }

    @ManagedAttribute(description="Number of failed exchanges")
    public long getExchangesFailed() throws Exception {
        return this.exchangesFailed.getValue();
    }

    @ManagedAttribute(description="Min Processing Time [milliseconds]")
    public long getMinProcessingTime() throws Exception {
        return this.minProcessingTime.getValue();
    }

    @ManagedAttribute(description="Mean Processing Time [milliseconds]")
    public long getMeanProcessingTime() throws Exception {
        return this.meanProcessingTime.getValue();
    }

    @ManagedAttribute(description="Max Processing Time [milliseconds]")
    public long getMaxProcessingTime() throws Exception {
        return this.maxProcessingTime.getValue();
    }

    @ManagedAttribute(description="Total Processing Time [milliseconds]")
    public long getTotalProcessingTime() throws Exception {
        return this.totalProcessingTime.getValue();
    }

    @ManagedAttribute(description="Last Processing Time [milliseconds]")
    public long getLastProcessingTime() throws Exception {
        return this.lastProcessingTime.getValue();
    }

    @ManagedAttribute(description="Last Exchange Completed Timestamp")
    public Date getLastExchangeCompletedTimestamp() {
        long value = this.lastExchangeCompletedTimestamp.getValue();
        return value > 0L ? new Date(value) : null;
    }

    @ManagedAttribute(description="First Exchange Completed Timestamp")
    public Date getFirstExchangeCompletedTimestamp() {
        long value = this.firstExchangeCompletedTimestamp.getValue();
        return value > 0L ? new Date(value) : null;
    }

    @ManagedAttribute(description="Last Exchange Failed Timestamp")
    public Date getLastExchangeFailureTimestamp() {
        long value = this.lastExchangeFailureTimestamp.getValue();
        return value > 0L ? new Date(value) : null;
    }

    @ManagedAttribute(description="First Exchange Failed Timestamp")
    public Date getFirstExchangeFailureTimestamp() {
        long value = this.firstExchangeFailureTimestamp.getValue();
        return value > 0L ? new Date(value) : null;
    }

    @ManagedAttribute(description="Statistics enabled")
    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @ManagedAttribute(description="Statistics enabled")
    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }

    public synchronized void completedExchange(long time) {
        this.increment();
        this.exchangesCompleted.increment();
        this.minProcessingTime.updateValue(time);
        this.maxProcessingTime.updateValue(time);
        this.totalProcessingTime.updateValue(time);
        this.lastProcessingTime.updateValue(time);
        long now = new Date().getTime();
        if (this.firstExchangeCompletedTimestamp.getUpdateCount() == 0L) {
            this.firstExchangeCompletedTimestamp.updateValue(now);
        }
        this.lastExchangeCompletedTimestamp.updateValue(now);
        long count = this.exchangesCompleted.getValue();
        long mean = count > 0L ? this.totalProcessingTime.getValue() / count : 0L;
        this.meanProcessingTime.updateValue(mean);
    }

    public synchronized void failedExchange() {
        this.increment();
        this.exchangesFailed.increment();
        long now = new Date().getTime();
        if (this.firstExchangeFailureTimestamp.getUpdateCount() == 0L) {
            this.firstExchangeFailureTimestamp.updateValue(now);
        }
        this.lastExchangeFailureTimestamp.updateValue(now);
    }
}

