/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.stream;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StreamCache;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.util.IOHelper;

public class FileInputStreamCache
extends InputStream
implements StreamCache {
    private InputStream stream;
    private CachedOutputStream cachedOutputStream;
    private File file;

    public FileInputStreamCache(File file, CachedOutputStream cos) throws FileNotFoundException {
        this.file = file;
        this.cachedOutputStream = cos;
        this.stream = new FileInputStream(file);
    }

    public void close() {
        try {
            if (this.isSteamOpened()) {
                this.getInputStream().close();
            }
            if (this.cachedOutputStream != null) {
                this.cachedOutputStream.releaseFileInputStream(this);
            }
        }
        catch (Exception e) {
            throw new RuntimeCamelException(e);
        }
    }

    public void reset() {
        try {
            if (this.isSteamOpened()) {
                this.getInputStream().close();
            }
            this.stream = new FileInputStream(this.file);
        }
        catch (Exception e) {
            throw new RuntimeCamelException(e);
        }
    }

    public void writeTo(OutputStream os) throws IOException {
        IOHelper.copy(this.getInputStream(), os);
    }

    public int available() throws IOException {
        return this.getInputStream().available();
    }

    public int read() throws IOException {
        return this.getInputStream().read();
    }

    protected InputStream getInputStream() {
        return this.stream;
    }

    private boolean isSteamOpened() {
        if (this.stream != null && this.stream instanceof FileInputStream) {
            return ((FileInputStream)this.stream).getChannel().isOpen();
        }
        return this.stream != null;
    }
}

