/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Converter
public final class IOConverter {
    private static final transient Log LOG = LogFactory.getLog(IOConverter.class);

    private IOConverter() {
    }

    @Converter
    public static InputStream toInputStream(URL url) throws IOException {
        return url.openStream();
    }

    @Converter
    public static InputStream toInputStream(File file) throws IOException {
        return new BufferedInputStream(new FileInputStream(file));
    }

    @Deprecated
    public static BufferedReader toReader(File file) throws IOException {
        return IOConverter.toReader(file, null);
    }

    @Converter
    public static BufferedReader toReader(File file, Exchange exchange) throws IOException {
        return new BufferedReader(new EncodingFileReader(file, IOConverter.getCharsetName(exchange)));
    }

    @Converter
    public static File toFile(String name) throws FileNotFoundException {
        return new File(name);
    }

    @Converter
    public static OutputStream toOutputStream(File file) throws FileNotFoundException {
        return new BufferedOutputStream(new FileOutputStream(file));
    }

    @Deprecated
    public static BufferedWriter toWriter(File file) throws IOException {
        return IOConverter.toWriter(file, null);
    }

    @Converter
    public static BufferedWriter toWriter(File file, Exchange exchange) throws IOException {
        return new BufferedWriter(new EncodingFileWriter(file, IOConverter.getCharsetName(exchange)));
    }

    @Deprecated
    public static Reader toReader(InputStream in) throws IOException {
        return IOConverter.toReader(in, null);
    }

    @Converter
    public static Reader toReader(InputStream in, Exchange exchange) throws IOException {
        return new InputStreamReader(in, IOConverter.getCharsetName(exchange));
    }

    @Deprecated
    public static Writer toWriter(OutputStream out) throws IOException {
        return IOConverter.toWriter(out, null);
    }

    @Converter
    @Deprecated
    public static Writer toWriter(OutputStream out, Exchange exchange) throws IOException {
        return new OutputStreamWriter(out, IOConverter.getCharsetName(exchange));
    }

    @Converter
    public static StringReader toReader(String text) {
        return new StringReader(text);
    }

    @Deprecated
    public static InputStream toInputStream(String text) throws IOException {
        return IOConverter.toInputStream(text, null);
    }

    @Converter
    public static InputStream toInputStream(String text, Exchange exchange) throws IOException {
        return IOConverter.toInputStream(text.getBytes(IOConverter.getCharsetName(exchange)));
    }

    @Deprecated
    public static InputStream toInputStream(BufferedReader buffer) throws IOException {
        return IOConverter.toInputStream(buffer, null);
    }

    @Converter
    public static InputStream toInputStream(BufferedReader buffer, Exchange exchange) throws IOException {
        return IOConverter.toInputStream(IOConverter.toString(buffer), exchange);
    }

    @Deprecated
    public static String toString(byte[] data) throws IOException {
        return IOConverter.toString(data, null);
    }

    @Converter
    public static String toString(byte[] data, Exchange exchange) throws IOException {
        return new String(data, IOConverter.getCharsetName(exchange));
    }

    @Deprecated
    public static String toString(File file) throws IOException {
        return IOConverter.toString(file, null);
    }

    @Converter
    public static String toString(File file, Exchange exchange) throws IOException {
        return IOConverter.toString(IOConverter.toReader(file, exchange));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter
    public static byte[] toByteArray(File file) throws IOException {
        InputStream is = IOConverter.toInputStream(file);
        try {
            byte[] byArray = IOConverter.toBytes(is);
            return byArray;
        }
        finally {
            IOHelper.close(is, "file", LOG);
        }
    }

    @Deprecated
    public static byte[] toByteArray(Reader reader) throws IOException {
        return IOConverter.toByteArray(reader, null);
    }

    @Converter
    public static byte[] toByteArray(Reader reader, Exchange exchange) throws IOException {
        if (reader instanceof BufferedReader) {
            return IOConverter.toByteArray((BufferedReader)reader, exchange);
        }
        return IOConverter.toByteArray(new BufferedReader(reader), exchange);
    }

    @Deprecated
    public static String toString(URL url) throws IOException {
        return IOConverter.toString(url, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter
    public static String toString(URL url, Exchange exchange) throws IOException {
        InputStream is = IOConverter.toInputStream(url);
        try {
            String string = IOConverter.toString(is, exchange);
            return string;
        }
        finally {
            IOHelper.close(is, "url", LOG);
        }
    }

    @Converter
    public static String toString(Reader reader) throws IOException {
        if (reader instanceof BufferedReader) {
            return IOConverter.toString((BufferedReader)reader);
        }
        return IOConverter.toString(new BufferedReader(reader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter
    public static String toString(BufferedReader reader) throws IOException {
        if (reader == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(1024);
        char[] buf = new char[1024];
        try {
            int len = 0;
            while (len != -1) {
                len = reader.read(buf);
                if (len == -1) continue;
                sb.append(buf, 0, len);
            }
        }
        finally {
            IOHelper.close(reader, "reader", LOG);
        }
        return sb.toString();
    }

    @Deprecated
    public static byte[] toByteArray(BufferedReader reader) throws IOException {
        return IOConverter.toByteArray(reader, null);
    }

    @Converter
    public static byte[] toByteArray(BufferedReader reader, Exchange exchange) throws IOException {
        return IOConverter.toByteArray(IOConverter.toString(reader), exchange);
    }

    @Deprecated
    public static byte[] toByteArray(String value) throws IOException {
        return IOConverter.toByteArray(value, null);
    }

    @Converter
    public static byte[] toByteArray(String value, Exchange exchange) throws IOException {
        return value != null ? value.getBytes(IOConverter.getCharsetName(exchange)) : null;
    }

    @Deprecated
    public static String toString(InputStream in) throws IOException {
        return IOConverter.toString(in, null);
    }

    @Converter
    public static String toString(InputStream in, Exchange exchange) throws IOException {
        return IOConverter.toString(IOConverter.toReader(in, exchange));
    }

    @Converter
    public static InputStream toInputStream(byte[] data) {
        return new ByteArrayInputStream(data);
    }

    @Converter
    public static ObjectOutput toObjectOutput(OutputStream stream) throws IOException {
        if (stream instanceof ObjectOutput) {
            return (ObjectOutput)((Object)stream);
        }
        return new ObjectOutputStream(stream);
    }

    @Converter
    public static ObjectInput toObjectInput(InputStream stream) throws IOException {
        if (stream instanceof ObjectInput) {
            return (ObjectInput)((Object)stream);
        }
        return new ObjectInputStream(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter
    public static byte[] toBytes(InputStream stream) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            IOHelper.copy(stream, bos);
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        finally {
            IOHelper.close(bos, "stream", LOG);
        }
    }

    @Converter
    public static byte[] toByteArray(ByteArrayOutputStream os) {
        return os.toByteArray();
    }

    @Deprecated
    public static String toString(ByteArrayOutputStream os) throws IOException {
        return IOConverter.toString(os, null);
    }

    @Converter
    public static String toString(ByteArrayOutputStream os, Exchange exchange) throws IOException {
        return os.toString(IOConverter.getCharsetName(exchange));
    }

    @Converter
    public static InputStream toInputStream(ByteArrayOutputStream os) {
        return new ByteArrayInputStream(os.toByteArray());
    }

    public static String getCharsetName(Exchange exchange) {
        return IOConverter.getCharsetName(exchange, true);
    }

    public static String getCharsetName(Exchange exchange, boolean useDefault) {
        String charsetName;
        if (exchange != null && (charsetName = exchange.getProperty("CamelCharsetName", String.class)) != null) {
            return charsetName;
        }
        if (useDefault) {
            return IOConverter.getDefaultCharsetName();
        }
        return null;
    }

    public static String getDefaultCharsetName() {
        return ObjectHelper.getSystemProperty("org.apache.camel.default.charset", "UTF-8");
    }

    private static class EncodingFileWriter
    extends OutputStreamWriter {
        public EncodingFileWriter(File file, String charset) throws FileNotFoundException, UnsupportedEncodingException {
            super((OutputStream)new FileOutputStream(file), charset);
        }
    }

    private static class EncodingFileReader
    extends InputStreamReader {
        public EncodingFileReader(File file, String charset) throws FileNotFoundException, UnsupportedEncodingException {
            super((InputStream)new FileInputStream(file), charset);
        }
    }
}

