/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.util.Map;
import java.util.Properties;
import org.apache.camel.Endpoint;
import org.apache.camel.component.properties.DefaultPropertiesResolver;
import org.apache.camel.component.properties.PropertiesParser;
import org.apache.camel.component.properties.PropertiesResolver;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.util.LRUCache;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesComponent
extends DefaultComponent {
    public static final String PREFIX_TOKEN = "{{";
    public static final String SUFFIX_TOKEN = "}}";
    private static final transient Log LOG = LogFactory.getLog(PropertiesComponent.class);
    private final Map<String[], Properties> cacheMap = new LRUCache<String[], Properties>(1000);
    private PropertiesResolver propertiesResolver = new DefaultPropertiesResolver();
    private String[] locations;
    private boolean cache = true;

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String[] paths = this.locations;
        String locations = this.getAndRemoveParameter(parameters, "locations", String.class);
        if (locations != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Overriding default locations with location: " + locations));
            }
            paths = locations.split(",");
        }
        String endpointUri = this.parseUri(remaining, paths);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Endpoint uri parsed as: " + endpointUri));
        }
        return this.getCamelContext().getEndpoint(endpointUri);
    }

    public String parseUri(String uri) throws Exception {
        return this.parseUri(uri, this.locations);
    }

    public String parseUri(String uri, String ... paths) throws Exception {
        Properties prop;
        ObjectHelper.notNull(paths, "paths");
        Properties properties = prop = this.cache ? this.cacheMap.get(paths) : null;
        if (prop == null) {
            prop = this.propertiesResolver.resolveProperties(this.getCamelContext(), paths);
            if (this.cache) {
                this.cacheMap.put(paths, prop);
            }
        }
        if (!uri.contains(PREFIX_TOKEN) && !uri.startsWith(PREFIX_TOKEN)) {
            uri = PREFIX_TOKEN + uri;
        }
        if (!uri.contains(SUFFIX_TOKEN) && !uri.endsWith(SUFFIX_TOKEN)) {
            uri = uri + SUFFIX_TOKEN;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Parsing uri " + uri + " with properties: " + prop));
        }
        return PropertiesParser.parseUri(uri, prop, PREFIX_TOKEN, SUFFIX_TOKEN);
    }

    public String[] getLocations() {
        return this.locations;
    }

    public void setLocations(String[] locations) {
        this.locations = locations;
    }

    public void setLocation(String location) {
        this.setLocations(location.split(","));
    }

    public PropertiesResolver getPropertiesResolver() {
        return this.propertiesResolver;
    }

    public void setPropertiesResolver(PropertiesResolver propertiesResolver) {
        this.propertiesResolver = propertiesResolver;
    }

    public boolean isCache() {
        return this.cache;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    @Override
    protected void doStop() throws Exception {
        this.cacheMap.clear();
        super.doStop();
    }
}

