/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.strategy.GenericFileRenamer;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericFileExpressionRenamer<T>
implements GenericFileRenamer<T> {
    private Expression expression;

    public GenericFileExpressionRenamer() {
    }

    public GenericFileExpressionRenamer(Expression expression) {
        this.expression = expression;
    }

    @Override
    public GenericFile<T> renameFile(Exchange exchange, GenericFile<T> file) {
        ObjectHelper.notNull(this.expression, "expression");
        String newName = this.expression.evaluate(exchange, String.class);
        GenericFile<T> result = file.copyFrom(file);
        result.changeFileName(newName);
        return result;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }
}

