/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.direct;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.component.direct.DirectEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.impl.converter.AsyncProcessorTypeConverter;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DirectProducer
extends DefaultProducer
implements AsyncProcessor {
    private static final transient Log LOG = LogFactory.getLog(DirectProducer.class);
    private DirectEndpoint endpoint;

    public DirectProducer(DirectEndpoint endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        if (this.endpoint.getConsumer() == null) {
            LOG.warn((Object)("No consumers available on endpoint: " + this.endpoint + " to process: " + exchange));
            throw new CamelExchangeException("No consumers available on endpoint: " + this.endpoint, exchange);
        }
        this.endpoint.getConsumer().getProcessor().process(exchange);
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (this.endpoint.getConsumer() == null) {
            LOG.warn((Object)("No consumers available on endpoint: " + this.endpoint + " to process: " + exchange));
            exchange.setException(new CamelExchangeException("No consumers available on endpoint: " + this.endpoint, exchange));
            callback.done(true);
            return true;
        }
        AsyncProcessor processor = AsyncProcessorTypeConverter.convert(this.endpoint.getConsumer().getProcessor());
        return AsyncProcessorHelper.process(processor, exchange, callback);
    }
}

