/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.readers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.broad.tribble.readers.TabixIteratorLineReader;
import org.broad.tribble.readers.TabixReader;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TabixReaderTest {
    static String tabixFile = "test/data/tabix/trioDup.vcf.gz";
    static TabixReader tabixReader;
    static List<String> sequenceNames;

    @BeforeClass
    public void setup() throws IOException {
        tabixReader = new TabixReader(tabixFile);
        sequenceNames = new ArrayList<String>(TabixReaderTest.tabixReader.mChr2tid.keySet());
    }

    @AfterClass
    public void teardown() throws Exception {
    }

    @Test
    public void testSequenceNames() {
        String[] expectedSeqNames = new String[24];
        int i = 1;
        while (i < 24) {
            expectedSeqNames[i - 1] = String.valueOf(i);
            ++i;
        }
        expectedSeqNames[22] = "X";
        expectedSeqNames[23] = "Y";
        Assert.assertEquals((int)expectedSeqNames.length, (int)sequenceNames.size());
        String[] stringArray = expectedSeqNames;
        int n = expectedSeqNames.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            Assert.assertTrue((boolean)sequenceNames.contains(s));
            ++n2;
        }
    }

    @Test
    public void testLocalQuery() throws IOException {
        String nextLine;
        TabixIteratorLineReader lineReader = new TabixIteratorLineReader(tabixReader.query(TabixReaderTest.tabixReader.mChr2tid.get("4"), 320, 330));
        int nRecords = 0;
        while ((nextLine = lineReader.readLine()) != null) {
            AssertJUnit.assertTrue((boolean)nextLine.startsWith("4"));
            ++nRecords;
        }
        AssertJUnit.assertTrue((nRecords > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRemoteQuery() throws IOException {
        String nextLine;
        String tabixFile = "http://www.broadinstitute.org/igvdata/test/tabix/trioDup.vcf.gz";
        TabixReader tabixReader = new TabixReader(tabixFile);
        TabixIteratorLineReader lineReader = new TabixIteratorLineReader(tabixReader.query(tabixReader.mChr2tid.get("4"), 320, 330));
        int nRecords = 0;
        while ((nextLine = lineReader.readLine()) != null) {
            AssertJUnit.assertTrue((boolean)nextLine.startsWith("4"));
            ++nRecords;
        }
        AssertJUnit.assertTrue((nRecords > 0 ? 1 : 0) != 0);
    }
}

