/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.readers;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import org.broad.tribble.readers.AsciiLineReader;
import org.broad.tribble.readers.PositionalBufferedStream;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ReaderTest {
    @BeforeClass
    public void setup() throws IOException {
    }

    @AfterClass
    public void teardown() throws Exception {
    }

    @Test
    public void testMultipleLines() throws IOException {
        this.testStream("line 1\nline2\n");
    }

    @Test
    public void testSingleLine() throws IOException {
        this.testStream("line 1\n");
    }

    @Test
    public void testEmpty() throws IOException {
        this.testStream("");
    }

    @Test
    public void testLotsOfLines() throws IOException {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < 10000) {
            b.append("line " + i + "\n");
            ++i;
        }
        this.testStream(b.toString());
    }

    @Test
    public void testMassiveLines() throws IOException {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < 10) {
            int j = 0;
            while (j < 1000000) {
                b.append(String.valueOf(i) + "." + j);
                ++j;
            }
            b.append("\n");
            ++i;
        }
        this.testStream(b.toString());
    }

    @Test
    public void testSkip() throws IOException {
        for (int skipSizeBase : Arrays.asList(0, 10, 100, 1000, 10000, 1000000)) {
            int skipSizeAdd = 0;
            while (skipSizeAdd < 10) {
                int skipSize = skipSizeBase + skipSizeAdd;
                byte[] bytes = new byte[skipSize + 2];
                Arrays.fill(bytes, 0, skipSize, (byte)0);
                bytes[skipSize] = 1;
                bytes[skipSize + 1] = 2;
                ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                PositionalBufferedStream pbs = new PositionalBufferedStream(is);
                pbs.skip(skipSize);
                Assert.assertTrue((!pbs.isDone() ? 1 : 0) != 0);
                Assert.assertEquals((long)pbs.getPosition(), (long)skipSize);
                Assert.assertEquals((int)pbs.peek(), (int)1);
                Assert.assertEquals((int)pbs.read(), (int)1);
                Assert.assertTrue((!pbs.isDone() ? 1 : 0) != 0);
                Assert.assertEquals((long)pbs.getPosition(), (long)(skipSize + 1));
                Assert.assertEquals((int)pbs.peek(), (int)2);
                Assert.assertEquals((int)pbs.read(), (int)2);
                Assert.assertTrue((boolean)pbs.isDone());
                ++skipSizeAdd;
            }
        }
    }

    private void testStream(String s) throws IOException {
        this.testStream(s.getBytes());
        this.testLineReader(s);
    }

    private void testStream(byte[] bytes) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        PositionalBufferedStream pbs = new PositionalBufferedStream(is);
        int bytePos = 0;
        while (!pbs.isDone()) {
            Assert.assertTrue((bytePos < bytes.length ? 1 : 0) != 0);
            Assert.assertEquals((long)pbs.getPosition(), (long)bytePos);
            byte atPos = bytes[bytePos];
            Assert.assertEquals((byte)this.toByte(pbs.peek()), (byte)atPos);
            Assert.assertEquals((long)pbs.getPosition(), (long)bytePos);
            Assert.assertEquals((byte)this.toByte(pbs.read()), (byte)atPos);
            Assert.assertEquals((long)pbs.getPosition(), (long)(++bytePos));
            if (bytePos >= bytes.length) continue;
            Assert.assertEquals((byte)this.toByte(pbs.peek()), (byte)bytes[bytePos]);
            Assert.assertEquals((long)pbs.getPosition(), (long)bytePos);
        }
        Assert.assertEquals((int)bytePos, (int)bytes.length);
        pbs.close();
    }

    private void testLineReader(String lines) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new StringReader(lines));
        ArrayList<String> eachLine = new ArrayList<String>();
        while ((line = br.readLine()) != null) {
            eachLine.add(line);
        }
        byte[] bytes = lines.getBytes();
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        PositionalBufferedStream pbs = new PositionalBufferedStream(is);
        AsciiLineReader alr = new AsciiLineReader(pbs);
        int bytePos = 0;
        int linePos = 0;
        while (!pbs.isDone()) {
            Assert.assertTrue((bytePos < bytes.length ? 1 : 0) != 0);
            Assert.assertEquals((long)pbs.getPosition(), (long)bytePos);
            String readLine = alr.readLine();
            Assert.assertEquals((String)readLine, (String)((String)eachLine.get(linePos)));
            ++linePos;
            Assert.assertEquals((long)pbs.getPosition(), (long)(bytePos += readLine.length() + 1));
        }
        Assert.assertEquals((int)linePos, (int)eachLine.size());
        Assert.assertEquals((int)bytePos, (int)bytes.length);
        pbs.close();
    }

    private final byte toByte(int i) {
        return (byte)(i & 0xFF);
    }
}

