/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging;

import fi.csc.microarray.DemoAuthenticationRequestListener;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.messaging.MessagingEndpoint;
import fi.csc.microarray.messaging.NodeBase;
import fi.csc.microarray.messaging.auth.SimpleAuthenticationRequestListener;
import org.apache.log4j.Logger;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeSuite;

public abstract class MessagingTestBase {
    private static Logger logger;
    protected MessagingEndpoint endpoint;
    protected SimpleAuthenticationRequestListener authenticationListener;
    private String configURL;
    private String username;
    private String password;

    public MessagingTestBase() {
    }

    public MessagingTestBase(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public MessagingTestBase(String username, String password, String configURL) {
        this.configURL = configURL;
        this.username = username;
        this.password = password;
    }

    @BeforeSuite
    protected void setUp() throws Exception {
        System.out.println("setting up authentication listener");
        this.authenticationListener = this.username == null || this.password == null ? new DemoAuthenticationRequestListener() : new SimpleAuthenticationRequestListener(this.username, this.password);
        System.out.println("initialising client");
        if (this.configURL == null) {
            DirectoryLayout.initialiseSimpleLayout().getConfiguration();
        } else {
            try {
                DirectoryLayout.initialiseClientLayout(this.configURL);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        System.out.println("setting up messaging");
        logger = Logger.getLogger(MessagingTestBase.class);
        logger.debug((Object)"loaded config");
        this.endpoint = new MessagingEndpoint(new NodeBase(){

            @Override
            public String getName() {
                return "test";
            }
        });
        System.out.println("endpoint created");
        this.endpoint.setAuthenticationListener(this.authenticationListener);
    }

    @AfterSuite
    protected void tearDown() throws Exception {
        System.out.println("closing messaging endpoint");
        this.endpoint.close();
        this.endpoint = null;
    }
}

