/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.View;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.TextDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoordDouble;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Utils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RulerTrack
extends Track {
    private static final int textY = 10;
    private static final int MINOR_STEPS = 10;
    List<Long> info = new ArrayList<Long>();

    public RulerTrack(View view) {
        super(view, null);
    }

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        Region region = this.getView().getBpRegion();
        long magnitude = (long)Math.pow(10.0, (int)Math.log10(region.getLength().longValue()));
        long start = region.start.bp - region.start.bp % magnitude;
        int steps = (int)Math.ceil((double)region.getLength().longValue() / (double)magnitude) + 1;
        long end = start + (long)steps * magnitude;
        for (long bp = start; bp <= end; bp += magnitude) {
            int x = this.getView().bpToTrack(new BpCoord(bp, region.start.chr));
            String text = Utils.toHumanReadable(bp);
            drawables.add(new TextDrawable(x, 10, text, Color.black));
        }
        boolean whiteStart = false;
        drawables.addAll(this.getRuler(new Region(start, end, region.start.chr), steps * 10, whiteStart));
        return drawables;
    }

    private Collection<Drawable> getRuler(Region bpRegion, int steps, boolean whiteStart) {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        boolean isWhite = whiteStart;
        int boxHeight = 5;
        double increment = (double)bpRegion.getLength().longValue() / (double)steps;
        BpCoordDouble boxBp = new BpCoordDouble(bpRegion.start);
        float lastBoxX = this.getView().bpToTrackFloat(bpRegion.start).floatValue();
        float boxX = 0.0f;
        this.info.clear();
        for (int i = 0; i < steps; ++i) {
            isWhite = !isWhite;
            Color c = isWhite ? Color.white : Color.black;
            boxBp = boxBp.move(increment);
            this.info.add((long)boxBp.bp.doubleValue());
            boxX = this.getView().bpToTrackFloat(boxBp.asBpCoord()).floatValue();
            drawables.add(new RectDrawable(Math.round(lastBoxX), 10, Math.round(boxX) - Math.round(lastBoxX), 5, c, null));
            lastBoxX = boxX;
        }
        float startX = this.getView().bpToTrackFloat(bpRegion.start).floatValue();
        float endX = boxX;
        drawables.add(new RectDrawable(Math.round(startX), 10, Math.round(endX) - Math.round(startX), 5, null, Color.black));
        return drawables;
    }

    @Override
    public void processAreaResult(AreaResult areaResult) {
    }

    public List<Long> getRulerInfo() {
        return this.info;
    }

    @Override
    public Integer getHeight() {
        return 20;
    }

    @Override
    public boolean isStretchable() {
        return false;
    }

    @Override
    public Map<DataSource, Set<ColumnType>> requestedData() {
        return null;
    }

    @Override
    public boolean isConcised() {
        return false;
    }

    @Override
    public String getName() {
        return "ruler";
    }
}

