/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher;

import fi.csc.microarray.client.visualisation.methods.gbrowser.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaResultListener;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.FsfStatus;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class QueueManager
implements AreaResultListener {
    private Map<DataSource, QueueContext> queues = new HashMap<DataSource, QueueContext>();

    private QueueContext createQueue(DataSource file) {
        if (!this.queues.containsKey(file)) {
            QueueContext context = new QueueContext();
            context.queue = new ConcurrentLinkedQueue<AreaRequest>();
            try {
                context.thread = file.getRequestHandler().getConstructor(DataSource.class, Queue.class, AreaResultListener.class).newInstance(file, context.queue, this);
                this.queues.put(file, context);
                context.thread.start();
                return context;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void removeQueue(DataSource file) {
        this.queues.remove(file);
    }

    public void addAreaRequest(DataSource file, AreaRequest req, boolean clearQueues) {
        req.status.file = file;
        QueueContext context = this.queues.get(file);
        req.status.maybeClearQueue(context.queue);
        context.queue.add(req);
        if (context.thread != null) {
            context.thread.notifyAreaRequestHandler();
        }
    }

    public void addResultListener(DataSource file, AreaResultListener listener) {
        QueueContext qContext = this.queues.get(file);
        if (qContext == null) {
            qContext = this.createQueue(file);
        }
        qContext.listeners.add(listener);
    }

    @Override
    public void processAreaResult(AreaResult areaResult) {
        for (AreaResultListener listener : this.queues.get((Object)areaResult.getStatus().file).listeners) {
            listener.processAreaResult(areaResult);
        }
    }

    public void poisonAll() {
        for (Map.Entry<DataSource, QueueContext> entry : this.queues.entrySet()) {
            FsfStatus status = new FsfStatus();
            status.poison = true;
            AreaRequest request = new AreaRequest(new Region(), null, status);
            QueueContext context = entry.getValue();
            context.queue.add(request);
            context.thread.notifyAreaRequestHandler();
        }
    }

    private class QueueContext {
        public Queue<AreaRequest> queue;
        public Collection<AreaResultListener> listeners = new ArrayList<AreaResultListener>();
        public AreaRequestHandler thread;

        private QueueContext() {
        }
    }
}

