/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser;

import fi.csc.microarray.client.visualisation.methods.gbrowser.GenomePlot;
import fi.csc.microarray.client.visualisation.methods.gbrowser.HorizontalView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.RegionListener;
import fi.csc.microarray.client.visualisation.methods.gbrowser.ViewLimiter;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionDouble;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.List;

public class OverviewHorizontalView
extends HorizontalView {
    private List<RegionListener> overviewListeners = new LinkedList<RegionListener>();

    public OverviewHorizontalView(GenomePlot parent) {
        super(parent, false, false, false);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.viewArea.contains(e.getPoint())) {
            return;
        }
        Region newRegion = this.highlight;
        long delta = (long)((double)newRegion.getMid().longValue() - this.trackToBp((double)((double)e.getX())).bp);
        BpCoord bpCoord = newRegion.start;
        bpCoord.bp = bpCoord.bp - delta;
        bpCoord = newRegion.end;
        bpCoord.bp = bpCoord.bp - delta;
        this.dispatchOverviewRegionChange(newRegion);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    public void addOverviewRegionListener(RegionListener listener) {
        this.overviewListeners.add(listener);
    }

    public void dispatchOverviewRegionChange(Region selectedRegion) {
        for (RegionListener listener : this.overviewListeners) {
            listener.regionChanged(selectedRegion);
        }
    }

    @Override
    public boolean isRulerEnabled() {
        return false;
    }

    @Override
    public void setViewLimiter(ViewLimiter viewLimiter) {
        super.setViewLimiter(viewLimiter);
        viewLimiter.addLimitChangeListener(new RegionListener(){

            @Override
            public void regionChanged(Region bpRegion) {
                OverviewHorizontalView.this.setBpRegion(new RegionDouble(bpRegion), false);
            }
        });
    }
}

