/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation;

import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.config.ConfigurationLoader;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.module.ModuleManager;
import fi.csc.microarray.module.basic.BasicModule;
import fi.csc.microarray.module.chipster.MicroarrayModule;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.testng.Assert;
import org.testng.annotations.Test;

public class VisualiserTest {
    private DataManager manager;

    public VisualiserTest() throws IOException, ConfigurationLoader.IllegalConfigurationException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        DirectoryLayout.initialiseSimpleLayout().getConfiguration();
        this.manager = new DataManager();
        new ModuleManager("fi.csc.microarray.module.chipster.MicroarrayModule").plugAll(this.manager, null);
    }

    public static void main(String[] args) throws IOException, Exception {
        new VisualiserTest().testHC();
    }

    @Test(groups={"smoke"})
    public void testSom() throws Exception {
        DataBean dataset = this.manager.createDataBean("SOM", this.getClass().getResourceAsStream("src/test/resources/som.tsv"));
        JComponent component = this.doVisualisation(MicroarrayModule.VisualisationMethods.SOM, dataset);
        this.makeFrame(component);
    }

    @Test(groups={"smoke"})
    public void testHC() throws Exception {
        String[] trees = new String[]{"src/test/resources/hc.tre", "src/test/resources/illumina-hc.tre", "src/test/resources/agilent-hc.txt"};
        String[] heatmaps = new String[]{"src/test/resources/hc-normalized.tsv", "src/test/resources/illumina-hc-normalized.tsv", "src/test/resources/agilent-hc-normalized.tsv"};
        for (int i = 0; i < trees.length; ++i) {
            DataBean tree = this.manager.createDataBean("HC clusters", this.getClass().getResourceAsStream(trees[i]));
            DataBean heatmap = this.manager.createDataBean("heatmap", this.getClass().getResourceAsStream(heatmaps[i]));
            tree.addLink(DataBean.Link.DERIVATION, heatmap);
            JComponent component = MicroarrayModule.VisualisationMethods.HIERARCHICAL.getHeadlessVisualiser().getVisualisation(tree);
            this.makeFrame(component);
        }
    }

    @Test(groups={"smoke"})
    public void testVisualisations() throws Exception {
        String[] resources;
        for (String resource : resources = new String[]{"src/test/resources/mouse1.tsv", "src/test/resources/resultset.tsv", "src/test/resources/affy_example.cel"}) {
            try {
                DataBean bean = this.manager.createDataBean(resource, this.getClass().getResourceAsStream(resource));
                this.doVisualisation(MicroarrayModule.VisualisationMethods.ARRAY_LAYOUT, bean);
                this.doVisualisation(BasicModule.VisualisationMethods.SPREADSHEET, bean);
            }
            catch (Exception e) {
                System.err.println("exception when processing " + resource + ": " + e.getMessage());
                throw e;
            }
        }
    }

    @Test(groups={"smoke"})
    public void testScatterplot() throws Exception {
        for (String resource : new String[]{"src/test/resources/4_chips_filtered.tsv", "src/test/resources/ei_visualisoidu.tsv", "src/test/resources/ei_visualisoidu_2.tsv"}) {
            try {
                DataBean dataBean = this.manager.createDataBean(resource, this.getClass().getResourceAsStream(resource));
                MicroarrayModule.VisualisationMethods.SCATTERPLOT.getHeadlessVisualiser().getVariablesFor(dataBean);
                MicroarrayModule.VisualisationMethods.SCATTERPLOT.getHeadlessVisualiser().getParameterPanel();
                JComponent visualisation = MicroarrayModule.VisualisationMethods.SCATTERPLOT.getHeadlessVisualiser().getVisualisation(dataBean);
                this.makeFrame(visualisation);
            }
            catch (Exception e) {
                System.err.println("exception when processing " + resource + ": " + e.getMessage());
                throw e;
            }
        }
    }

    @Test(groups={"smoke"})
    public void testHistogram() throws Exception {
        DataBean dataBean = this.manager.createDataBean("Hist. data", this.getClass().getResourceAsStream("src/test/resources/4_chips_filtered.tsv"));
        Visualisation.Variable[] variables = MicroarrayModule.VisualisationMethods.HISTOGRAM.getHeadlessVisualiser().getVariablesFor(dataBean);
        Assert.assertEquals((int)variables.length, (int)4);
        Visualisation visualiser = MicroarrayModule.VisualisationMethods.HISTOGRAM.getHeadlessVisualiser();
        visualiser.getParameterPanel();
        JComponent visualisation = visualiser.getVisualisation(dataBean);
        this.makeFrame(visualisation);
    }

    @Test(groups={"smoke"})
    public void testExpressionProfile() throws Exception {
        DataBean dataBean = this.manager.createDataBean("Profiledata", this.getClass().getResourceAsStream("src/test/resources/4_chips_filtered.tsv"));
        JComponent visualisation = MicroarrayModule.VisualisationMethods.EXPRESSION_PROFILE.getHeadlessVisualiser().getVisualisation(dataBean);
        this.makeFrame(visualisation);
    }

    @Test(groups={"smoke"})
    public void testClusteredProfiles() throws Exception {
        DataBean dataBean = this.manager.createDataBean("Profiledata", this.getClass().getResourceAsStream("src/test/resources/kmeans.tsv"));
        JComponent visualisation = MicroarrayModule.VisualisationMethods.CLUSTERED_PROFILES.getHeadlessVisualiser().getVisualisation(dataBean);
        this.makeFrame(visualisation);
    }

    @Test(groups={"smoke"})
    public void testApplicabilityChecks() throws MicroarrayException, IOException {
        DataBean affyMicroarray = this.manager.createDataBean("", this.getClass().getResourceAsStream("src/test/resources/affy_example.cel"));
        for (VisualisationMethod method : Session.getSession().getVisualisations().getVisualisationMethods()) {
            if (!method.isApplicableTo(affyMicroarray) || method != MicroarrayModule.VisualisationMethods.SOM && method != MicroarrayModule.VisualisationMethods.HIERARCHICAL && method != MicroarrayModule.VisualisationMethods.EXPRESSION_PROFILE && method != BasicModule.VisualisationMethods.SHOW_IMAGE && method != BasicModule.VisualisationMethods.WEBVIEW && method != BasicModule.VisualisationMethods.VIEW_TEXT) continue;
            Assert.fail((String)("method " + method.getName() + " should not be applicable to " + affyMicroarray.getName()));
        }
    }

    private JComponent doVisualisation(VisualisationMethod method, DataBean bean) throws Exception {
        method.getHeadlessVisualiser().getParameterPanel();
        return method.getHeadlessVisualiser().getVisualisation(bean);
    }

    private void makeFrame(JComponent visualisation) {
        JFrame frame = new JFrame();
        frame.add(visualisation);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }
}

