/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.operation.parameter;

import fi.csc.microarray.client.operation.parameter.EnumParameter;
import fi.csc.microarray.client.operation.parameter.Parameter;
import fi.csc.microarray.client.operation.parameter.ParameterInputComponent;
import fi.csc.microarray.client.operation.parameter.ParameterPanel;
import fi.csc.microarray.client.operation.parameter.SteppedComboBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class SingleSelectionInputComponent
extends ParameterInputComponent
implements ActionListener {
    private static final Logger logger = Logger.getLogger(SingleSelectionInputComponent.class);
    private SteppedComboBox choiceBox;
    private EnumParameter param;

    public SingleSelectionInputComponent(EnumParameter param, ParameterPanel parameterPanel) {
        super(parameterPanel);
        this.param = param;
        this.choiceBox = new SteppedComboBox(param.getOptions());
        Dimension preferredSize = this.choiceBox.getPreferredSize();
        this.choiceBox.setPreferredSize(ParameterInputComponent.PREFERRED_SIZE);
        this.choiceBox.setPopupWidth(preferredSize.width);
        this.choiceBox.setBackground(Color.white);
        if (param.getSelectedOptions().size() > 0) {
            this.choiceBox.setSelectedItem(param.getSelectedOptions().get(0));
        } else {
            this.choiceBox.setSelectedItem(null);
        }
        this.choiceBox.addActionListener(this);
        this.choiceBox.addFocusListener(this);
        this.add((Component)this.choiceBox, "Center");
    }

    @Override
    public Parameter getParameter() {
        return this.param;
    }

    @Override
    public boolean inputIsValid() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.param.setValue(this.choiceBox.getSelectedItem());
        logger.debug((Object)("set selection to " + this.choiceBox.getSelectedItem()));
        this.getParentPanel().setMessage(this.param.getDescription(), Color.black);
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.getParentPanel().setMessage(this.param.getDescription(), Color.black);
    }

    @Override
    public JComponent getParameterComponent() {
        return this.choiceBox;
    }
}

