/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.operation;

import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.operation.ColoredCircleIcon;
import fi.csc.microarray.client.operation.ExecutionItem;
import fi.csc.microarray.client.operation.OperationDefinition;
import fi.csc.microarray.client.operation.ToolCategory;
import fi.csc.microarray.client.operation.ToolModule;
import fi.csc.microarray.client.operation.ToolPanel;
import fi.csc.microarray.constants.VisualConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ToolSelectorPanel
extends JPanel
implements ListSelectionListener {
    private final ClientApplication application = Session.getSession().getApplication();
    private ToolPanel toolPanel;
    private JList categoryList;
    private JList toolList;
    private ToolModule toolModule;

    public ToolSelectorPanel(ToolPanel parent, ToolModule toolModule) {
        super(new GridLayout(1, 2));
        this.toolPanel = parent;
        this.toolModule = toolModule;
        ArrayList<ToolCategory> toolCategories = Collections.list(Collections.enumeration(toolModule.getVisibleCategories()));
        this.categoryList = new JList();
        this.categoryList.setSelectionMode(0);
        this.categoryList.addListSelectionListener(this);
        this.categoryList.setCellRenderer(new CategoryListRenderer());
        this.categoryList.getInsets().right = 1;
        this.categoryList.setName("categoryList");
        this.categoryList.setListData(toolCategories.toArray());
        this.toolList = new JList();
        this.toolList.setSelectionMode(0);
        this.toolList.addListSelectionListener(this);
        this.toolList.setCellRenderer(new FontSizeFriendlyListRenderer());
        this.toolList.addMouseListener(new MouseClickListener());
        this.toolList.getInsets().right = 1;
        this.toolList.setName("toolList");
        JScrollPane categoryListScroller = new JScrollPane(this.categoryList);
        JScrollPane toolListScroller = new JScrollPane(this.toolList);
        categoryListScroller.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, VisualConstants.TOOL_LIST_BORDER_COLOR));
        toolListScroller.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.add(categoryListScroller);
        this.add(toolListScroller);
    }

    public Vector<Component> getFocusComponents() {
        Vector<Component> order = new Vector<Component>();
        order.add(this.categoryList);
        order.add(this.toolList);
        return order;
    }

    public void deselectTool() {
        this.categoryList.clearSelection();
        this.toolList.clearSelection();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object selected;
        Object source = e.getSource();
        if (source == this.categoryList) {
            Object selected2 = this.categoryList.getSelectedValue();
            if (selected2 instanceof ToolCategory) {
                ToolCategory selectedCategory = (ToolCategory)selected2;
                this.toolList.clearSelection();
                this.toolPanel.selectTool(null);
                this.toolList.setListData(selectedCategory.getToolList());
                this.categoryList.removeListSelectionListener(this);
                this.categoryList.setSelectedValue(selectedCategory, true);
                this.categoryList.addListSelectionListener(this);
            }
        } else if (source == this.toolList && (selected = this.toolList.getSelectedValue()) instanceof ExecutionItem) {
            ExecutionItem selectedTool = (ExecutionItem)selected;
            this.toolPanel.selectTool(selectedTool);
        }
    }

    public String getModuleName() {
        return this.toolModule.getModuleName();
    }

    public void selectCategory(ToolCategory category) {
        this.categoryList.setSelectedValue(category, true);
    }

    public void selectTool(OperationDefinition tool) {
        this.toolList.setSelectedValue(tool, true);
    }

    public class MouseClickListener
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1 && e.getClickCount() == 2) {
                ToolSelectorPanel.this.toolPanel.runSelectedOperation();
            }
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger() && e.getButton() == 3) {
                int index = ToolSelectorPanel.this.toolList.locationToIndex(e.getPoint());
                Object clicked = ToolSelectorPanel.this.toolList.getModel().getElementAt(index);
                Rectangle bounds = ToolSelectorPanel.this.toolList.getCellBounds(index, index);
                if (bounds != null && clicked != null) {
                    boolean validPoint = bounds.contains(e.getPoint());
                    if (clicked instanceof OperationDefinition && validPoint) {
                        OperationDefinition tool = (OperationDefinition)clicked;
                        ToolPopupMenu popup = new ToolPopupMenu(tool);
                        popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }
        }
    }

    public class ToolPopupMenu
    extends JPopupMenu {
        JMenuItem helpMenuItem;
        OperationDefinition tool;

        public ToolPopupMenu(OperationDefinition tool) {
            this.tool = tool;
            this.helpMenuItem = new JMenuItem("Help...");
            this.helpMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == ToolPopupMenu.this.helpMenuItem) {
                        ToolSelectorPanel.this.application.viewHelpFor(ToolPopupMenu.this.tool);
                    }
                }
            });
            this.add(this.helpMenuItem);
        }
    }

    static class CategoryListRenderer
    extends FontSizeFriendlyListRenderer {
        CategoryListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel comp = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            Color circleColor = ((ToolCategory)list.getModel().getElementAt(index)).getColor();
            if (circleColor == null) {
                circleColor = comp.getBackground();
            }
            comp.setIcon(new ColoredCircleIcon(circleColor));
            return this;
        }
    }

    static class FontSizeFriendlyListRenderer
    extends DefaultListCellRenderer {
        FontSizeFriendlyListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel comp = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Font font = UIManager.getFont("Label.font");
            comp.setFont(font);
            return this;
        }
    }
}

