/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dialog;

import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.SwingClientApplication;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataItem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class RenameDialog
extends JDialog
implements ActionListener,
CaretListener {
    private final Dimension BUTTON_SIZE = new Dimension(75, 25);
    private JTextField dataItemNameField;
    private JButton okButton;
    private JButton cancelButton;
    private ClientApplication client;
    private DataItem data;

    public RenameDialog(SwingClientApplication client, DataItem data) {
        super(client.getMainFrame(), data instanceof DataBean ? "Rename Data Item" : "Rename Data Folder", true);
        this.client = client;
        this.data = data;
        this.dataItemNameField = new JTextField(15);
        this.dataItemNameField.setText(data.getName());
        this.dataItemNameField.addCaretListener(this);
        this.dataItemNameField.addActionListener(this);
        this.okButton = new JButton("OK");
        this.okButton.setPreferredSize(this.BUTTON_SIZE);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setPreferredSize(this.BUTTON_SIZE);
        JPanel contentPane = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.insets = new Insets(10, 20, 5, 10);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        JLabel dataSetNameLabel = new JLabel("New name for " + data.getName());
        contentPane.add((Component)dataSetNameLabel, c);
        c.gridy = 1;
        contentPane.add((Component)this.dataItemNameField, c);
        c.gridy = 2;
        c.gridwidth = 1;
        contentPane.add((Component)this.okButton, c);
        c.gridx = 1;
        contentPane.add((Component)this.cancelButton, c);
        this.setContentPane(contentPane);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton || source == this.dataItemNameField) {
            String newName = this.dataItemNameField.getText();
            this.client.renameDataItem(this.data, newName);
            this.dispose();
        }
        if (source == this.cancelButton) {
            this.dispose();
        }
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        String dataSetName = this.dataItemNameField.getText();
        if (dataSetName.length() > 0) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }
}

