/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser;

import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.description.SADLDescription;
import fi.csc.microarray.description.SADLParser;
import fi.csc.microarray.module.chipster.ChipsterSADLParser;
import fi.csc.microarray.util.IOUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;

public class SADLTool {
    private String comment;

    public SADLTool(String comment) {
        this.comment = comment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParsedScript parseScript(InputStream rScriptSource) throws IOException {
        ParsedScript parsedScript = new ParsedScript();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(rScriptSource));
            boolean inHeaderCommentBlock = true;
            String line = in.readLine();
            while (line != null) {
                if (!line.startsWith(this.comment)) {
                    inHeaderCommentBlock = false;
                }
                if (inHeaderCommentBlock) {
                    String strippedLine = line.substring(this.comment.length());
                    if (strippedLine.startsWith(" ")) {
                        strippedLine = strippedLine.substring(1);
                    }
                    parsedScript.SADL = parsedScript.SADL + strippedLine + "\n";
                } else {
                    parsedScript.code = parsedScript.code + line + "\n";
                }
                parsedScript.source = parsedScript.source + line + "\n";
                line = in.readLine();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeIfPossible(in);
            throw throwable;
        }
        IOUtils.closeIfPossible(in);
        return parsedScript;
    }

    public String toScriptString(ParsedScript parsedScript) {
        String string = "";
        for (String sadlRow : parsedScript.SADL.split("\n")) {
            string = string + this.comment + " " + sadlRow + "\n";
        }
        string = string + parsedScript.code;
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertToSADL(File scriptFile) throws IOException, SADLParser.ParseException {
        ParsedScript parsedScript;
        FileInputStream in = null;
        try {
            in = new FileInputStream(scriptFile);
            parsedScript = this.parseScript(in);
            SADLDescription sadl = new ChipsterSADLParser().parse(parsedScript.SADL, scriptFile.getName());
            for (SADLDescription.Input input : sadl.inputs()) {
                if (!"phenodata.tsv".equals(input.getName().getID())) continue;
                input.setMeta(true);
            }
            for (SADLDescription.Output output : sadl.outputs()) {
                if (!"phenodata.tsv".equals(output.getName().getID())) continue;
                output.setMeta(true);
            }
            parsedScript.SADL = sadl.toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeIfPossible(in);
            throw throwable;
        }
        IOUtils.closeIfPossible(in);
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileOutputStream(scriptFile));
            out.print(this.toScriptString(parsedScript));
        }
        catch (Throwable throwable) {
            IOUtils.closeIfPossible(out);
            throw throwable;
        }
        IOUtils.closeIfPossible(out);
    }

    public static void main(String[] args) throws Exception {
        DirectoryLayout.initialiseUnitTestLayout();
        SADLTool.convertBeanshell();
    }

    public static void convertACGH() throws Exception {
        for (String moduleDir : new String[]{"src/main/modules/microarray/R-2.12", "src/main/modules/ngs/R-2.12"}) {
            for (File file : new File(moduleDir).listFiles()) {
                if (!file.getName().endsWith(".R")) continue;
                System.out.println(file.getCanonicalPath());
                new SADLTool("#").convertToSADL(file);
            }
        }
    }

    public static void convertSomeScripts() throws Exception {
        File[] files;
        for (File file : files = new File[]{new File("src/main/modules/microarray/R-2.12/annotate-agilent-miRNA.R"), new File("src/main/modules/ngs/R-2.12/ngs-annotate-miRNA-targets.R"), new File("src/main/modules/ngs/R-2.12/ngs-correlation-analysis-mirna.R"), new File("src/main/modules/ngs/R-2.12/ngs-extract-target-gene-expression.R"), new File("src/main/modules/ngs/R-2.12/ngs-filter-annotations.R"), new File("src/main/modules/ngs/R-2.12/ngs-filter-results-column.R"), new File("src/main/modules/ngs/R-2.12/ngs-pathways-mirna-hyperg-go.R"), new File("src/main/modules/ngs/R-2.12/ngs-pathways-mirna-hyperg-kegg.R"), new File("src/main/modules/ngs/R-2.12/ngs-up-down-analysis-mirna.R")}) {
            if (!file.getName().endsWith(".R")) continue;
            System.out.println(file.getCanonicalPath());
            new SADLTool("#").convertToSADL(file);
        }
    }

    public static void convertBeanshell() throws Exception {
        for (File file : new File("src/main/modules/microarray/bsh").listFiles()) {
            if (!file.getName().endsWith(".bsh")) continue;
            System.out.println(file.getCanonicalPath());
            new SADLTool("//").convertToSADL(file);
        }
    }

    public static class ParsedScript {
        public String SADL = "";
        public String source = "";
        public String code = "";
    }
}

