/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser;

import fi.csc.microarray.analyser.AnalysisException;
import fi.csc.microarray.analyser.ToolDescription;
import fi.csc.microarray.analyser.ToolRuntime;
import fi.csc.microarray.messaging.message.ModuleDescriptionMessage;
import fi.csc.microarray.util.XmlUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class RepositoryModule {
    private static final Logger logger = Logger.getLogger(RepositoryModule.class);
    private LinkedList<CategoryInModule> categories = new LinkedList();
    private LinkedHashMap<String, ToolDescription> descriptions = new LinkedHashMap();
    private LinkedHashSet<String> supportedDescriptions = new LinkedHashSet();
    private LinkedHashSet<String> visibleDescriptions = new LinkedHashSet();
    private File moduleDir;
    private File moduleFile;
    private long moduleFileTimestamp;
    private HashMap<String, ToolRuntime> runtimes;
    private String summary = null;
    private String moduleName = null;

    public RepositoryModule(File moduleDir, File moduleFile, HashMap<String, ToolRuntime> runtimes) throws ParserConfigurationException, FileNotFoundException, SAXException, IOException {
        this.moduleFile = moduleFile;
        this.moduleDir = moduleDir;
        this.runtimes = runtimes;
        this.load();
    }

    public synchronized ModuleDescriptionMessage getModuleDescriptionMessage() {
        this.reloadModuleIfNeeded();
        ModuleDescriptionMessage msg = new ModuleDescriptionMessage(this.moduleName);
        for (CategoryInModule categoryInModule : this.categories) {
            ModuleDescriptionMessage.Category category = new ModuleDescriptionMessage.Category(categoryInModule.getName(), categoryInModule.getColor(), categoryInModule.isHidden());
            for (ToolDescription tool : categoryInModule.getTools()) {
                ToolDescription freshTool = this.reloadToolIfNeeded(tool);
                category.addTool(freshTool.getSADL(), freshTool.getHelpURL());
            }
            msg.addCategory(category);
        }
        return msg;
    }

    public synchronized ToolDescription getDescription(String id) {
        this.reloadModuleIfNeeded();
        ToolDescription desc = this.descriptions.get(id);
        if (desc == null) {
            return null;
        }
        this.reloadToolIfNeeded(desc);
        return this.descriptions.get(id);
    }

    private ToolDescription reloadToolIfNeeded(ToolDescription oldDesc) {
        if (oldDesc != null && !oldDesc.isUptodate()) {
            ToolDescription newDesc = this.updateDescription(oldDesc);
            logger.info((Object)("updated tool: " + oldDesc.getID()));
            return newDesc;
        }
        return oldDesc;
    }

    public synchronized boolean isSupportedDescription(String id) {
        this.reloadModuleIfNeeded();
        return this.supportedDescriptions.contains(id);
    }

    public synchronized File getModuleDir() {
        return this.moduleDir;
    }

    public synchronized String getSummary() throws FileNotFoundException, SAXException, IOException, ParserConfigurationException {
        this.reloadModuleIfNeeded();
        return this.summary;
    }

    private synchronized ToolDescription updateDescription(ToolDescription oldDescription) {
        ToolDescription newDescription;
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            newDescription = oldDescription.getHandler().handle(this.moduleDir, oldDescription.getToolFile().getName(), params);
        }
        catch (AnalysisException e) {
            return oldDescription;
        }
        if (newDescription == null) {
            return oldDescription;
        }
        newDescription.setUpdatedSinceStartup();
        if (oldDescription.getID().equals(newDescription.getID())) {
            this.descriptions.put(newDescription.getID(), newDescription);
            if (this.supportedDescriptions.contains(oldDescription.getID())) {
                this.supportedDescriptions.add(newDescription.getID());
            }
            if (this.visibleDescriptions.contains(oldDescription.getID())) {
                this.visibleDescriptions.add(newDescription.getID());
            }
        } else {
            logger.warn((Object)"name of the tool was changed, keeping both old and new");
            if (this.descriptions.containsKey(newDescription.getID())) {
                logger.warn((Object)"descriptions already contains a tool with the new name, ignoring reload");
                return oldDescription;
            }
            this.descriptions.put(newDescription.getID(), newDescription);
            if (this.supportedDescriptions.contains(oldDescription.getID())) {
                this.supportedDescriptions.add(newDescription.getID());
            }
            if (this.visibleDescriptions.contains(oldDescription.getID())) {
                this.visibleDescriptions.add(newDescription.getID());
            }
        }
        return newDescription;
    }

    private synchronized void load() throws FileNotFoundException, SAXException, IOException, ParserConfigurationException {
        this.moduleFileTimestamp = this.moduleFile.lastModified();
        Document document = XmlUtil.parseReader(new FileReader(this.moduleFile));
        Element moduleElement = (Element)document.getElementsByTagName("module").item(0);
        this.moduleName = moduleElement.getAttribute("name");
        if (this.moduleName.isEmpty()) {
            this.summary = "not loading a module without a name";
            logger.warn((Object)this.summary);
            return;
        }
        int totalCount = 0;
        int successfullyLoadedCount = 0;
        int hiddenCount = 0;
        int disabledCount = 0;
        for (Element categoryElement : XmlUtil.getChildElements(moduleElement, "category")) {
            String categoryName = categoryElement.getAttribute("name");
            if (categoryName.isEmpty()) {
                logger.warn((Object)"not loading a category without a name");
                continue;
            }
            boolean categoryDisabled = categoryElement.getAttribute("disabled").equals("true");
            if (categoryDisabled) {
                logger.info((Object)("not loading category " + categoryName + ": disabled"));
                continue;
            }
            String categoryColor = categoryElement.getAttribute("color");
            if (categoryColor.isEmpty()) {
                logger.warn((Object)("not loading category " + categoryName + ": no color"));
                continue;
            }
            boolean categoryHidden = Boolean.valueOf(categoryElement.getAttribute("hidden"));
            CategoryInModule category = new CategoryInModule(categoryName, categoryColor, categoryHidden);
            this.categories.add(category);
            for (Element toolElement : XmlUtil.getChildElements(categoryElement, "tool")) {
                ToolDescription description;
                ToolRuntime runtime;
                boolean toolHidden;
                boolean toolDisabled;
                block19: {
                    ++totalCount;
                    Element resourceElement = XmlUtil.getChildElement(toolElement, "resource");
                    if (resourceElement == null) {
                        logger.warn((Object)"not loading a tool without resource element");
                        continue;
                    }
                    String resource = resourceElement.getTextContent().trim();
                    if (resource == null || resource.isEmpty()) {
                        logger.warn((Object)"not loading a tool with empty resource element");
                        continue;
                    }
                    toolDisabled = toolElement.getAttribute("disabled").equals("true");
                    toolHidden = categoryHidden;
                    String runtimeName = toolElement.getAttribute("runtime");
                    runtime = this.runtimes.get(runtimeName);
                    if (runtime == null) {
                        logger.warn((Object)("not loading " + resource + ": runtime " + runtimeName + " not found"));
                        continue;
                    }
                    boolean parametersOk = true;
                    HashMap<String, String> parameters = new HashMap<String, String>();
                    for (Element parameterElement : XmlUtil.getChildElements(toolElement, "parameter")) {
                        String parameterName = XmlUtil.getChildElement(parameterElement, "name").getTextContent().trim();
                        if (parameterName == null || parameterName.isEmpty()) {
                            logger.warn((Object)"parameter without a name");
                            parametersOk = false;
                            break;
                        }
                        String parameterValue = XmlUtil.getChildElement(parameterElement, "value").getTextContent().trim();
                        if (parameterValue == null) {
                            logger.warn((Object)"parameter without a value");
                            parametersOk = false;
                            break;
                        }
                        parameters.put(parameterName, parameterValue);
                    }
                    if (!parametersOk) {
                        logger.warn((Object)("not loading " + resource + ": parameters not ok"));
                        continue;
                    }
                    try {
                        description = runtime.getHandler().handle(this.moduleDir, resource, parameters);
                        ToolDescription previousDescription = this.getDescription(description.getID());
                        if (previousDescription != null) {
                            logger.warn((Object)("not loading " + resource + ": tool with the same ID already exists in this module"));
                        }
                        break block19;
                    }
                    catch (AnalysisException e) {
                        logger.warn((Object)("loading " + resource + " failed, could not create description"), (Throwable)e);
                    }
                    continue;
                }
                this.descriptions.put(description.getID(), description);
                ++successfullyLoadedCount;
                String disabledStatus = "";
                if (!runtime.isDisabled() && !toolDisabled) {
                    this.supportedDescriptions.add(description.getID());
                } else {
                    disabledStatus = " DISABLED";
                    ++disabledCount;
                }
                category.addTool(description);
                String hiddenStatus = "";
                if (toolHidden) {
                    hiddenStatus = " HIDDEN";
                    ++hiddenCount;
                }
                logger.info((Object)("loaded " + description.getID() + " " + description.getDisplayName() + " " + description.getToolFile() + disabledStatus + hiddenStatus));
            }
        }
        this.summary = "loaded " + this.moduleName + " " + successfullyLoadedCount + "/" + totalCount + " tools, " + disabledCount + " disabled, " + hiddenCount + " hidden";
        logger.info((Object)this.summary);
    }

    private synchronized void reloadModuleIfNeeded() {
        if (this.moduleFile.lastModified() > this.moduleFileTimestamp) {
            this.categories.clear();
            this.descriptions.clear();
            this.moduleName = null;
            this.summary = null;
            this.supportedDescriptions.clear();
            this.visibleDescriptions.clear();
            try {
                this.load();
            }
            catch (Exception e) {
                logger.error((Object)("reloading module " + this.moduleName + " failed"), (Throwable)e);
            }
        }
    }

    public static class CategoryInModule {
        private String name;
        private String color;
        private Boolean hidden;
        private List<ToolDescription> tools = new LinkedList<ToolDescription>();

        public CategoryInModule(String name, String color, Boolean hidden) {
            this.name = name;
            this.color = color;
            this.hidden = hidden;
        }

        public String getName() {
            return this.name;
        }

        public String getColor() {
            return this.color;
        }

        public Boolean isHidden() {
            return this.hidden;
        }

        public void addTool(ToolDescription tool) {
            this.tools.add(tool);
        }

        public List<ToolDescription> getTools() {
            return this.tools;
        }
    }
}

