/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.scheduler;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.jms.MessageFormatException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CronParser {
    private static final int NUMBER_TOKENS = 5;
    private static final int MINUTES = 0;
    private static final int HOURS = 1;
    private static final int DAY_OF_MONTH = 2;
    private static final int MONTH = 3;
    private static final int DAY_OF_WEEK = 4;

    public static long getNextScheduledTime(String cronEntry, long currentTime) throws MessageFormatException {
        long result = 0L;
        if (cronEntry != null && cronEntry.length() > 0) {
            int currentDayOfMonth;
            int currentMonth;
            int currentDayOfWeek;
            int currentHours;
            List<String> list = CronParser.tokenize(cronEntry);
            List<CronEntry> entries = CronParser.buildCronEntries(list);
            Calendar working = Calendar.getInstance();
            working.setTimeInMillis(currentTime);
            CronEntry minutes = entries.get(0);
            CronEntry hours = entries.get(1);
            CronEntry dayOfMonth = entries.get(2);
            CronEntry month = entries.get(3);
            CronEntry dayOfWeek = entries.get(2);
            int currentMinutes = working.get(12);
            if (!CronParser.isCurrent(minutes, currentMinutes)) {
                int nextMinutes = CronParser.getNext(minutes, currentMinutes);
                working.add(12, nextMinutes);
                result = working.getTimeInMillis();
            }
            if (!CronParser.isCurrent(hours, currentHours = working.get(11))) {
                int nextHour = CronParser.getNext(hours, currentHours);
                working.add(11, nextHour);
                result = working.getTimeInMillis();
            }
            if (!CronParser.isCurrent(dayOfWeek, currentDayOfWeek = working.get(7) - 1)) {
                int nextDay = CronParser.getNext(dayOfWeek, currentDayOfWeek);
                working.add(7, nextDay);
                result = working.getTimeInMillis();
            }
            if (!CronParser.isCurrent(month, currentMonth = working.get(2) + 1)) {
                int nextMonth = CronParser.getNext(month, currentMonth);
                working.add(2, nextMonth);
                result = working.getTimeInMillis();
            }
            if (!CronParser.isCurrent(dayOfMonth, currentDayOfMonth = working.get(5))) {
                int nextDay = CronParser.getNext(dayOfMonth, currentMonth);
                working.add(5, nextDay);
                result = working.getTimeInMillis();
            }
            if (result == 0L) {
                result = currentTime + 60000L;
                result = result / 1000L * 1000L;
            }
        }
        return result;
    }

    static List<String> tokenize(String cron) throws IllegalArgumentException {
        StringTokenizer tokenize = new StringTokenizer(cron);
        ArrayList<String> result = new ArrayList<String>();
        while (tokenize.hasMoreTokens()) {
            result.add(tokenize.nextToken());
        }
        if (result.size() != 5) {
            throw new IllegalArgumentException("Not a valid cron entry - wrong number of tokens(" + result.size() + "): " + cron);
        }
        return result;
    }

    public static void validate(String cronEntry) throws MessageFormatException {
        List<String> list = CronParser.tokenize(cronEntry);
        List<CronEntry> entries = CronParser.buildCronEntries(list);
        for (CronEntry e : entries) {
            CronParser.validate(e);
        }
    }

    static void validate(CronEntry entry) throws MessageFormatException {
        List<Integer> list = CronParser.calculateValues(entry);
        if (list.isEmpty() || list.get(0) < entry.start || list.get(list.size() - 1) > entry.end) {
            throw new MessageFormatException("Invalid token: " + entry);
        }
    }

    static int getNext(CronEntry entry, int current) throws MessageFormatException {
        int result = 0;
        List<Integer> list = CronParser.calculateValues(entry);
        Collections.sort(list);
        int next = -1;
        for (Integer i : list) {
            if (i <= current) continue;
            next = i;
            break;
        }
        if (next != -1) {
            result = next - current;
        } else {
            int first = list.get(0);
            result = entry.end + first - entry.start - current;
        }
        return result;
    }

    static boolean isCurrent(CronEntry entry, int current) throws MessageFormatException {
        List<Integer> list = CronParser.calculateValues(entry);
        boolean result = list.contains(new Integer(current));
        return result;
    }

    protected static List<Integer> calculateValues(CronEntry entry) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (CronParser.isAll(entry.token)) {
            for (int i = entry.start; i <= entry.end; ++i) {
                result.add(i);
            }
        } else if (CronParser.isAStep(entry.token)) {
            int denominator = CronParser.getDenominator(entry.token);
            String numerator = CronParser.getNumerator(entry.token);
            CronEntry ce = new CronEntry(entry.name, numerator, entry.start, entry.end);
            List<Integer> list = CronParser.calculateValues(ce);
            for (Integer i : list) {
                if (i % denominator != 0) continue;
                result.add(i);
            }
        } else if (CronParser.isAList(entry.token)) {
            StringTokenizer tokenizer = new StringTokenizer(entry.token, ",");
            while (tokenizer.hasMoreTokens()) {
                String str = tokenizer.nextToken();
                CronEntry ce = new CronEntry(entry.name, str, entry.start, entry.end);
                List<Integer> list = CronParser.calculateValues(ce);
                result.addAll(list);
            }
        } else if (CronParser.isARange(entry.token)) {
            int index = entry.token.indexOf(45);
            int first = Integer.parseInt(entry.token.substring(0, index));
            int last = Integer.parseInt(entry.token.substring(index + 1));
            for (int i = first; i <= last; ++i) {
                result.add(i);
            }
        } else {
            int value = Integer.parseInt(entry.token);
            result.add(value);
        }
        return result;
    }

    protected static boolean isARange(String token) {
        return token != null && token.indexOf(45) >= 0;
    }

    protected static boolean isAStep(String token) {
        return token != null && token.indexOf(47) >= 0;
    }

    protected static boolean isAList(String token) {
        return token != null && token.indexOf(44) >= 0;
    }

    protected static boolean isAll(String token) {
        return token != null && token.length() == 1 && token.charAt(0) == '*';
    }

    protected static int getDenominator(String token) {
        int result = 0;
        int index = token.indexOf(47);
        String str = token.substring(index + 1);
        result = Integer.parseInt(str);
        return result;
    }

    protected static String getNumerator(String token) {
        int index = token.indexOf(47);
        String str = token.substring(0, index);
        return str;
    }

    static List<CronEntry> buildCronEntries(List<String> tokens) {
        ArrayList<CronEntry> result = new ArrayList<CronEntry>();
        CronEntry minutes = new CronEntry("Minutes", tokens.get(0), 0, 60);
        result.add(minutes);
        CronEntry hours = new CronEntry("Hours", tokens.get(1), 0, 24);
        result.add(hours);
        CronEntry dayOfMonth = new CronEntry("DayOfMonth", tokens.get(2), 1, 31);
        result.add(dayOfMonth);
        CronEntry month = new CronEntry("Month", tokens.get(3), 1, 12);
        result.add(month);
        CronEntry dayOfWeek = new CronEntry("DayOfWeek", tokens.get(4), 0, 6);
        result.add(dayOfWeek);
        return result;
    }

    static class CronEntry {
        final String name;
        final String token;
        final int start;
        final int end;

        CronEntry(String name, String token, int start, int end) {
            this.name = name;
            this.token = token;
            this.start = start;
            this.end = end;
        }

        public String toString() {
            return this.name + ":" + this.token;
        }
    }
}

