/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.StreamException;
import com.thoughtworks.xstream.io.json.JettisonStaxWriter;
import com.thoughtworks.xstream.io.xml.QNameMap;
import com.thoughtworks.xstream.io.xml.StaxReader;
import com.thoughtworks.xstream.io.xml.StaxWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import org.codehaus.jettison.mapped.Configuration;
import org.codehaus.jettison.mapped.MappedNamespaceConvention;
import org.codehaus.jettison.mapped.MappedXMLInputFactory;
import org.codehaus.jettison.mapped.MappedXMLOutputFactory;

public class JettisonMappedXmlDriver
implements HierarchicalStreamDriver {
    private final MappedXMLOutputFactory mof;
    private final MappedXMLInputFactory mif;
    private final MappedNamespaceConvention convention;
    private boolean useSerializeAsArray = true;

    public JettisonMappedXmlDriver() {
        this(new Configuration(), true);
    }

    public JettisonMappedXmlDriver(Configuration config, boolean useSerializeAsArray) {
        this.mof = new MappedXMLOutputFactory(config);
        this.mif = new MappedXMLInputFactory(config);
        this.convention = new MappedNamespaceConvention(config);
        this.useSerializeAsArray = useSerializeAsArray;
    }

    public HierarchicalStreamReader createReader(Reader reader) {
        try {
            return new StaxReader(new QNameMap(), this.mif.createXMLStreamReader(reader));
        }
        catch (XMLStreamException e) {
            throw new StreamException((Throwable)e);
        }
    }

    public HierarchicalStreamReader createReader(InputStream input) {
        try {
            return new StaxReader(new QNameMap(), this.mif.createXMLStreamReader(input));
        }
        catch (XMLStreamException e) {
            throw new StreamException((Throwable)e);
        }
    }

    public HierarchicalStreamWriter createWriter(Writer writer) {
        try {
            if (this.useSerializeAsArray) {
                return new JettisonStaxWriter(new QNameMap(), this.mof.createXMLStreamWriter(writer), this.convention);
            }
            return new StaxWriter(new QNameMap(), this.mof.createXMLStreamWriter(writer));
        }
        catch (XMLStreamException e) {
            throw new StreamException((Throwable)e);
        }
    }

    public HierarchicalStreamWriter createWriter(OutputStream output) {
        try {
            if (this.useSerializeAsArray) {
                return new JettisonStaxWriter(new QNameMap(), this.mof.createXMLStreamWriter(output), this.convention);
            }
            return new StaxWriter(new QNameMap(), this.mof.createXMLStreamWriter(output));
        }
        catch (XMLStreamException e) {
            throw new StreamException((Throwable)e);
        }
    }
}

