/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui.sequenceChooser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.gui.form.SectionPanel;
import org.emboss.jemboss.gui.form.TextFieldSink;
import org.emboss.jemboss.gui.sequenceChooser.SequenceFilter;

public class FileChooser {
    private final JFileChooser fc;
    private TextFieldSink fileName;
    private JLabel lname;

    public FileChooser(Box box, String string, final JembossParams jembossParams) {
        SecurityManager securityManager = System.getSecurityManager();
        System.setSecurityManager(null);
        this.fc = new JFileChooser();
        System.setSecurityManager(securityManager);
        JButton jButton = new JButton("Browse files...");
        this.fileName = new TextFieldSink();
        Box box2 = Box.createHorizontalBox();
        this.lname = new JLabel(string);
        this.lname.setFont(SectionPanel.labfont);
        box.add(box2);
        box2.add(this.lname);
        box2.add(Box.createHorizontalGlue());
        Box box3 = Box.createHorizontalBox();
        box.add(box3);
        box3.add(this.fileName);
        box3.add(Box.createRigidArea(new Dimension(2, 2)));
        box3.add(jButton);
        this.fc.addChoosableFileFilter(new SequenceFilter());
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                String string = jembossParams.getUserHome();
                File file = new File(string);
                if (file.isDirectory() && file.canRead()) {
                    FileChooser.this.fc.setCurrentDirectory(file);
                }
                if ((n = FileChooser.this.fc.showOpenDialog(FileChooser.this.fc)) == 0) {
                    String string2 = FileChooser.this.fc.getSelectedFile().getAbsolutePath();
                    String string3 = FileChooser.this.fc.getCurrentDirectory().getPath();
                    FileChooser.this.fileName.setText(string2);
                }
            }
        });
        box3.add(Box.createHorizontalGlue());
    }

    public String getFileChosen() {
        return this.fileName.getText();
    }

    public JFileChooser getJFileChooser() {
        return this.fc;
    }

    public TextFieldSink getTextFieldSink() {
        return this.fileName;
    }

    public void setText(String string) {
        this.fileName.setText(string);
    }

    public void setSize(Dimension dimension) {
        this.fileName.setPreferredSize(dimension);
        this.fileName.setMinimumSize(dimension);
        this.fileName.setMaximumSize(dimension);
    }

    public void setPreferredSize(Dimension dimension) {
        this.fileName.setPreferredSize(dimension);
    }

    public Dimension getPreferredSize() {
        return this.fileName.getPreferredSize();
    }

    public void setForeground(Color color) {
        this.lname.setForeground(color);
    }
}

