/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

class TabListCellRenderer
extends JLabel
implements ListCellRenderer {
    protected static Border m_noFocusBorder;
    protected FontMetrics m_fm = null;
    protected Insets m_insets = new Insets(0, 0, 0, 0);
    protected int m_defaultTab = 50;
    protected int[] m_tabs = null;

    public TabListCellRenderer() {
        m_noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        this.setOpaque(true);
        this.setBorder(m_noFocusBorder);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        this.setText(object.toString());
        this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
        this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
        this.setFont(jList.getFont());
        this.setBorder(bl2 ? UIManager.getBorder("List.focusCellHighlightBorder") : m_noFocusBorder);
        return this;
    }

    public void setDefaultTab(int n) {
        this.m_defaultTab = n;
    }

    public int getDefaultTab() {
        return this.m_defaultTab;
    }

    public void setTabs(int[] nArray) {
        this.m_tabs = nArray;
    }

    public int[] getTabs() {
        return this.m_tabs;
    }

    public int getTab(int n) {
        if (this.m_tabs == null) {
            return this.m_defaultTab * n;
        }
        int n2 = this.m_tabs.length;
        if (n >= 0 && n < n2) {
            return this.m_tabs[n];
        }
        return this.m_tabs[n2 - 1] + this.m_defaultTab * (n - n2 + 1);
    }

    public void paint(Graphics graphics) {
        this.m_fm = graphics.getFontMetrics();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.getBorder().paintBorder(this, graphics, 0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(this.getForeground());
        graphics.setFont(this.getFont());
        this.m_insets = this.getInsets();
        int n = this.m_insets.left;
        int n2 = this.m_insets.top + this.m_fm.getAscent();
        StringTokenizer stringTokenizer = new StringTokenizer(this.getText(), "\t");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            graphics.drawString(string, n, n2);
            n += this.m_fm.stringWidth(string);
            if (!stringTokenizer.hasMoreTokens()) break;
            int n3 = 0;
            while (n >= this.getTab(n3)) {
                ++n3;
            }
            n = this.getTab(n3);
        }
    }
}

