/*
 * Decompiled with CFR 0.152.
 */
package org.testng.junit;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import org.testng.IClass;
import org.testng.IRetryAnalyzer;
import org.testng.ITestClass;
import org.testng.ITestNGMethod;
import org.testng.TestNGException;

public class JUnitUtils {
    private static final String[] EMTPY_STRINGARRAY = new String[0];
    private static final ITestNGMethod[] EMPTY_METHODARRAY = new ITestNGMethod[0];

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JUnitTestClass
    implements ITestClass {
        private List<ITestNGMethod> m_testMethods = new ArrayList<ITestNGMethod>();
        private Class m_realClass;
        private Object[] m_instances;
        private long[] m_instanceHashes;

        public JUnitTestClass(Test test) {
            this.m_realClass = test.getClass();
            this.m_instances = new Object[]{test};
            this.m_instanceHashes = new long[]{test.hashCode()};
        }

        List<ITestNGMethod> getTestMethodList() {
            return this.m_testMethods;
        }

        @Override
        public int getInstanceCount() {
            return 1;
        }

        @Override
        public long[] getInstanceHashCodes() {
            return this.m_instanceHashes;
        }

        @Override
        public Object[] getInstances(boolean reuse) {
            return this.m_instances;
        }

        @Override
        public ITestNGMethod[] getTestMethods() {
            return this.m_testMethods.toArray(new ITestNGMethod[this.m_testMethods.size()]);
        }

        @Override
        public ITestNGMethod[] getAfterClassMethods() {
            return EMPTY_METHODARRAY;
        }

        @Override
        public ITestNGMethod[] getAfterGroupsMethods() {
            return EMPTY_METHODARRAY;
        }

        @Override
        public ITestNGMethod[] getAfterSuiteMethods() {
            return EMPTY_METHODARRAY;
        }

        @Override
        public ITestNGMethod[] getAfterTestConfigurationMethods() {
            return EMPTY_METHODARRAY;
        }

        @Override
        public ITestNGMethod[] getAfterTestMethods() {
            return EMPTY_METHODARRAY;
        }

        @Override
        public ITestNGMethod[] getBeforeClassMethods() {
            return EMPTY_METHODARRAY;
        }

        @Override
        public ITestNGMethod[] getBeforeGroupsMethods() {
            return EMPTY_METHODARRAY;
        }

        @Override
        public ITestNGMethod[] getBeforeSuiteMethods() {
            return EMPTY_METHODARRAY;
        }

        @Override
        public ITestNGMethod[] getBeforeTestConfigurationMethods() {
            return EMPTY_METHODARRAY;
        }

        @Override
        public ITestNGMethod[] getBeforeTestMethods() {
            return EMPTY_METHODARRAY;
        }

        @Override
        public void addInstance(Object instance) {
            throw new IllegalStateException("addInstance is not supported for JUnit");
        }

        @Override
        public String getName() {
            return this.m_realClass.getName();
        }

        @Override
        public Class getRealClass() {
            return this.m_realClass;
        }
    }

    public static class JUnitTestMethod
    implements ITestNGMethod {
        private final ITestClass m_testClass;
        private final Class m_methodClass;
        private final Object[] m_instances;
        private final long[] m_instanceHashes;
        private Method m_method;
        private String m_methodName = "N/A";
        private String m_signature;
        private int m_currentInvocationCount = 0;
        private int m_parameterInvocationCount = 0;
        private long m_date;
        private String m_id;
        private IRetryAnalyzer retryAnalyzer = null;

        public JUnitTestMethod(Test test, JUnitTestClass testClass) {
            this.m_testClass = testClass;
            this.m_instances = new Object[]{test};
            this.m_instanceHashes = new long[]{test.hashCode()};
            this.m_methodClass = test.getClass();
            this.init(test);
            testClass.getTestMethodList().add(this);
        }

        private void init(Test test) {
            if (TestCase.class.isAssignableFrom(test.getClass())) {
                TestCase tc = (TestCase)test;
                this.m_methodName = tc.getName();
                this.m_signature = this.m_methodClass.getName() + "." + this.m_methodName + "()";
                try {
                    this.m_method = test.getClass().getMethod(tc.getName(), new Class[0]);
                }
                catch (Exception ex) {
                    throw new TestNGException("cannot retrieve JUnit method", ex);
                }
            }
        }

        public long getDate() {
            return this.m_date;
        }

        public String getDescription() {
            return "";
        }

        public String getId() {
            return this.m_id;
        }

        public long[] getInstanceHashCodes() {
            return this.m_instanceHashes;
        }

        public Object[] getInstances() {
            return this.m_instances;
        }

        public Method getMethod() {
            return this.m_method;
        }

        public String getMethodName() {
            return this.m_methodName;
        }

        public Class getRealClass() {
            return this.m_methodClass;
        }

        public void setDate(long date) {
            this.m_date = date;
        }

        public void setId(String id) {
            this.m_id = id;
        }

        public int compareTo(Object o) {
            Class otherClass;
            int result = -2;
            Class thisClass = this.getRealClass();
            if (thisClass.isAssignableFrom(otherClass = ((ITestNGMethod)o).getRealClass())) {
                result = -1;
            } else if (otherClass.isAssignableFrom(thisClass)) {
                result = 1;
            } else if (this.equals(o)) {
                result = 0;
            }
            return result;
        }

        public boolean isTest() {
            return true;
        }

        public boolean canRunFromClass(IClass testClass) {
            throw new IllegalStateException("canRunFromClass is not supported for JUnit");
        }

        public void setTestClass(ITestClass cls) {
            throw new IllegalStateException("setTestClass is not supported for JUnit");
        }

        public ITestClass getTestClass() {
            return this.m_testClass;
        }

        public void addMethodDependedUpon(String methodName) {
            throw new IllegalStateException("addMethodDependedUpon is not supported for JUnit");
        }

        public void setMissingGroup(String group) {
            throw new IllegalStateException("setMissingGroup is not supported for JUnit");
        }

        public String[] getAfterGroups() {
            return EMTPY_STRINGARRAY;
        }

        public String[] getBeforeGroups() {
            return EMTPY_STRINGARRAY;
        }

        public String[] getGroups() {
            return EMTPY_STRINGARRAY;
        }

        public String[] getGroupsDependedUpon() {
            return EMTPY_STRINGARRAY;
        }

        public int getInvocationCount() {
            return 1;
        }

        public String[] getMethodsDependedUpon() {
            return EMTPY_STRINGARRAY;
        }

        public String getMissingGroup() {
            return null;
        }

        public int getSuccessPercentage() {
            return 100;
        }

        public int getThreadPoolSize() {
            return 1;
        }

        public long getTimeOut() {
            return 0L;
        }

        public boolean isAfterClassConfiguration() {
            return false;
        }

        public boolean isAfterGroupsConfiguration() {
            return false;
        }

        public boolean isAfterMethodConfiguration() {
            return false;
        }

        public boolean isAfterSuiteConfiguration() {
            return false;
        }

        public boolean isAfterTestConfiguration() {
            return false;
        }

        public boolean isAlwaysRun() {
            return false;
        }

        public boolean isBeforeClassConfiguration() {
            return false;
        }

        public boolean isBeforeGroupsConfiguration() {
            return false;
        }

        public boolean isBeforeMethodConfiguration() {
            return false;
        }

        public boolean isBeforeSuiteConfiguration() {
            return false;
        }

        public boolean isBeforeTestConfiguration() {
            return false;
        }

        public int getCurrentInvocationCount() {
            return this.m_currentInvocationCount;
        }

        public void incrementCurrentInvocationCount() {
            ++this.m_currentInvocationCount;
        }

        public void setParameterInvocationCount(int n) {
            this.m_parameterInvocationCount = n;
        }

        public int getParameterInvocationCount() {
            return this.m_parameterInvocationCount;
        }

        public String toString() {
            return this.m_signature;
        }

        public ITestNGMethod clone() {
            throw new IllegalStateException("clone is not supported for JUnit");
        }

        public void setInvocationCount(int count) {
            throw new IllegalStateException("setInvocationCount is not supported for JUnit");
        }

        public void setThreadPoolSize(int threadPoolSize) {
            throw new IllegalStateException("setThreadPoolSize is not supported for JUnit");
        }

        public IRetryAnalyzer getRetryAnalyzer() {
            return this.retryAnalyzer;
        }

        public void setRetryAnalyzer(IRetryAnalyzer retryAnalyzer) {
            this.retryAnalyzer = retryAnalyzer;
        }

        public void setSkipFailedInvocations(boolean skip) {
        }

        public boolean skipFailedInvocations() {
            return false;
        }

        public void setIgnoreMissingDependencies(boolean ignore) {
        }

        public boolean ignoreMissingDependencies() {
            return false;
        }

        public boolean isFirstTimeOnly() {
            return false;
        }

        public boolean isLastTimeOnly() {
            return false;
        }

        public long getInvocationTimeOut() {
            return 0L;
        }
    }
}

