/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.ClassMethodMap;
import org.testng.IMethodInstance;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.internal.ConfigurationGroupMethods;
import org.testng.internal.IInvoker;
import org.testng.internal.IMethodWorker;
import org.testng.internal.Utils;
import org.testng.internal.thread.ThreadUtil;
import org.testng.xml.XmlSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestMethodWorker
implements IMethodWorker {
    protected IMethodInstance[] m_testMethods;
    protected IInvoker m_invoker = null;
    protected Map<String, String> m_parameters = null;
    protected XmlSuite m_suite = null;
    protected ITestNGMethod[] m_allTestMethods;
    protected List<ITestResult> m_testResults = new ArrayList<ITestResult>();
    protected ConfigurationGroupMethods m_groupMethods = null;
    protected ClassMethodMap m_classMethodMap = null;
    private ITestContext m_testContext = null;

    public TestMethodWorker(IInvoker invoker, IMethodInstance[] testMethods, XmlSuite suite, Map<String, String> parameters, ITestNGMethod[] allTestMethods, ConfigurationGroupMethods groupMethods, ClassMethodMap classMethodMap, ITestContext testContext) {
        this.m_invoker = invoker;
        this.m_testMethods = testMethods;
        this.m_suite = suite;
        this.m_parameters = parameters;
        this.m_allTestMethods = allTestMethods;
        this.m_groupMethods = groupMethods;
        this.m_classMethodMap = classMethodMap;
        this.m_testContext = testContext;
    }

    @Override
    public long getMaxTimeOut() {
        long result = 0L;
        for (IMethodInstance mi : this.m_testMethods) {
            ITestNGMethod tm = mi.getMethod();
            if (tm.getTimeOut() <= result) continue;
            result = tm.getTimeOut();
        }
        return result;
    }

    public String toString() {
        return "[Worker on thread:" + Thread.currentThread().getId() + " " + this.m_testMethods[0].getMethod() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        for (int indexMethod = 0; indexMethod < this.m_testMethods.length; ++indexMethod) {
            ITestNGMethod tm = this.m_testMethods[indexMethod].getMethod();
            ITestClass testClass = tm.getTestClass();
            this.invokeBeforeClassMethods(testClass, this.m_testMethods[indexMethod]);
            try {
                this.invokeTestMethods(tm, this.m_testMethods[indexMethod].getInstances(), this.m_testContext);
                continue;
            }
            finally {
                this.invokeAfterClassMethods(testClass, this.m_testMethods[indexMethod]);
            }
        }
    }

    protected void invokeTestMethods(ITestNGMethod tm, Object[] instances, ITestContext testContext) {
        List<ITestResult> testResults = this.m_invoker.invokeTestMethods(tm, this.m_allTestMethods, this.indexOf(tm, this.m_allTestMethods), this.m_suite, this.m_parameters, this.m_groupMethods, instances, testContext);
        if (testResults != null) {
            this.m_testResults.addAll(testResults);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeBeforeClassMethods(ITestClass testClass, IMethodInstance mi) {
        Map<ITestClass, Set<Object>> invokedBeforeClassMethods;
        if (null == this.m_classMethodMap || null == this.m_classMethodMap.getInvokedBeforeClassMethods()) {
            return;
        }
        ITestNGMethod[] classMethods = testClass.getBeforeClassMethods();
        if (null == classMethods || classMethods.length == 0) {
            return;
        }
        Map<ITestClass, Set<Object>> map = invokedBeforeClassMethods = this.m_classMethodMap.getInvokedBeforeClassMethods();
        synchronized (map) {
            Set<Object> instances = invokedBeforeClassMethods.get(testClass);
            if (null == instances) {
                instances = new HashSet<Object>();
                invokedBeforeClassMethods.put(testClass, instances);
            }
            for (Object instance : mi.getInstances()) {
                if (instances.contains(instance)) continue;
                instances.add(instance);
                this.m_invoker.invokeConfigurations(testClass, testClass.getBeforeClassMethods(), this.m_suite, this.m_parameters, null, instance);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void invokeAfterClassMethods(ITestClass testClass, IMethodInstance mi) {
        if (null == this.m_classMethodMap || null == this.m_classMethodMap.getInvokedAfterClassMethods()) {
            return;
        }
        ITestNGMethod[] afterClassMethods = testClass.getAfterClassMethods();
        if (null == afterClassMethods || afterClassMethods.length == 0) {
            return;
        }
        ArrayList<Object> invokeInstances = new ArrayList<Object>();
        ITestNGMethod tm = mi.getMethod();
        if (this.m_classMethodMap.removeAndCheckIfLast(tm)) {
            Map<ITestClass, Set<Object>> invokedAfterClassMethods;
            Map<ITestClass, Set<Object>> map = invokedAfterClassMethods = this.m_classMethodMap.getInvokedAfterClassMethods();
            synchronized (map) {
                Set<Object> set = invokedAfterClassMethods.get(testClass);
                if (null == set) {
                    HashSet hashSet = new HashSet();
                    invokedAfterClassMethods.put(testClass, hashSet);
                }
                for (Object inst : mi.getInstances()) {
                    void var8_10;
                    if (var8_10.contains(inst)) continue;
                    invokeInstances.add(inst);
                }
            }
            for (Object e : invokeInstances) {
                this.m_invoker.invokeConfigurations(testClass, afterClassMethods, this.m_suite, this.m_parameters, null, e);
            }
        }
    }

    protected int indexOf(ITestNGMethod tm, ITestNGMethod[] allTestMethods) {
        for (int i = 0; i < allTestMethods.length; ++i) {
            if (allTestMethods[i] != tm) continue;
            return i;
        }
        return -1;
    }

    @Override
    public List<ITestResult> getTestResults() {
        return this.m_testResults;
    }

    private void ppp(String s) {
        Utils.log("TestMethodWorker", 2, ThreadUtil.currentThreadInfo() + ":" + s);
    }

    public void setAllTestMethods(ITestNGMethod[] allTestMethods) {
        this.m_allTestMethods = allTestMethods;
    }
}

