/* =======================================================================
 * A visualisation library extension for JFreeChart. Please see JFreeChart
 * for further information.
 * =======================================================================
 * Copyright (C) 2006  University of Helsinki, Department of Computer Science
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 * -----------------------------
 * Contact:  ohtu@cs.helsinki.fi
 * -----------------------------
 *
 */

package org.jfree.chart.event;

import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.plot.Plot;

import java.awt.Rectangle;

/**
 * An event describing a selection change.
 */
public class SelectionChangeEvent extends PlotChangeEvent {

    private Rectangle oldSelection;

    /**
     * Creates a new selection change event.
     *
     * @param plot  the plot this event is associated with.
     * @param oldSelection  the selection before the change.
     */
    public SelectionChangeEvent (Plot plot, Rectangle oldSelection) {

	super(plot);
	this.oldSelection = oldSelection;

    }

    /**
     * Returns the selection before the change.
     *
     * @return  a rectangle specifying the selection.
     */
    public Rectangle getOldSelection() {

	return this.oldSelection;

    }

}

