/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.plot.HCPlot;

public class HCOptionsEditor
implements ChangeListener {
    private JCheckBox verticalClusteringCB;
    private JCheckBox rowNamesCB;
    private JCheckBox columnNamesCB;
    private HCPlot plot;

    public HCOptionsEditor(HCPlot plot) {
        this.plot = plot;
        this.verticalClusteringCB = null;
        this.rowNamesCB = null;
        this.columnNamesCB = null;
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.verticalClusteringCB) {
            boolean value = this.verticalClusteringCB.isSelected();
            if (value) {
                this.plot.showRowTree();
            } else {
                this.plot.hideRowTree();
            }
        } else if (e.getSource() == this.columnNamesCB) {
            boolean value = this.columnNamesCB.isSelected();
            if (value) {
                this.plot.showColumnNames();
            } else {
                this.plot.hideColumnNames();
            }
        } else if (e.getSource() == this.rowNamesCB) {
            boolean value = this.rowNamesCB.isSelected();
            if (value) {
                this.plot.showRowNames();
            } else {
                this.plot.hideRowNames();
            }
        }
    }

    public JPanel getPanel() {
        ResourceBundle lr = ResourceBundle.getBundle("org.jfree.chart.editor.viski_bundle.LocalizationBundle");
        JPanel panel = new JPanel();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(new GridBagLayout());
        c.fill = 3;
        panel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        c.gridx = 0;
        c.gridy = 0;
        this.verticalClusteringCB = new JCheckBox(lr.getString("Show_row_clustering"), this.plot.getRowTreeVisibility());
        this.verticalClusteringCB.addChangeListener(this);
        panel.add((Component)this.verticalClusteringCB, c);
        ++c.gridy;
        this.columnNamesCB = new JCheckBox(lr.getString("Show_column_names"), this.plot.getColumnNamesVisibility());
        this.columnNamesCB.addChangeListener(this);
        panel.add((Component)this.columnNamesCB, c);
        ++c.gridy;
        this.rowNamesCB = new JCheckBox(lr.getString("Show_row_names"), this.plot.getRowNamesVisibility());
        this.rowNamesCB.addChangeListener(this);
        panel.add((Component)this.rowNamesCB, c);
        return panel;
    }
}

