/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.draw;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFileChooser;

public class EmbossCirdnaReader {
    private File cirdnaFile;
    private boolean reading = false;
    private Vector restrictionEnzyme = new Vector();
    private Vector block = new Vector();
    private Color[] embossColor = new Color[]{Color.black, Color.red, Color.yellow, Color.green, Color.decode("#99CCFF"), Color.decode("#FFCCCC"), Color.decode("#FFFFCC"), Color.gray, Color.decode("#993300"), Color.blue, Color.decode("#9933FF"), Color.cyan, Color.decode("#33FFCC"), Color.decode("#FF00FF"), Color.decode("#FF9966"), Color.white};
    int start = 0;
    int end = 0;

    public EmbossCirdnaReader() {
        SecurityManager securityManager = System.getSecurityManager();
        System.setSecurityManager(null);
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.home"));
        System.setSecurityManager(securityManager);
        int n = jFileChooser.showOpenDialog(jFileChooser);
        if (n == 0) {
            this.cirdnaFile = jFileChooser.getSelectedFile();
            this.readFile();
            this.reading = true;
        }
    }

    public EmbossCirdnaReader(File file) {
        this.cirdnaFile = file;
        this.readFile();
        this.reading = true;
    }

    public boolean isReading() {
        return this.reading;
    }

    public Vector readFile() {
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new FileReader(this.cirdnaFile));
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim().toLowerCase()).equals("")) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                if (string.startsWith("start ")) {
                    stringTokenizer.nextElement();
                    this.start = Integer.parseInt((String)stringTokenizer.nextElement());
                    continue;
                }
                if (string.startsWith("end ")) {
                    stringTokenizer.nextElement();
                    this.end = Integer.parseInt((String)stringTokenizer.nextElement());
                    continue;
                }
                if (!string.startsWith("group")) continue;
                while ((string = bufferedReader.readLine()) != null && !(string = string.trim().toLowerCase()).startsWith("endgroup")) {
                    Serializable serializable;
                    Object object;
                    Serializable serializable2;
                    Serializable serializable3;
                    if (string.startsWith("block ")) {
                        String string2;
                        stringTokenizer = new StringTokenizer(string, " ");
                        serializable3 = new Vector();
                        stringTokenizer.nextElement();
                        serializable2 = new Integer((String)stringTokenizer.nextElement());
                        object = new Integer((String)stringTokenizer.nextElement());
                        serializable = Color.red;
                        if (stringTokenizer.hasMoreTokens()) {
                            serializable = this.embossColor[Integer.parseInt((String)stringTokenizer.nextElement())];
                        }
                        if ((string2 = bufferedReader.readLine().trim()).equals("endlabel")) {
                            string2 = "";
                        }
                        ((Vector)serializable3).add(string2);
                        ((Vector)serializable3).add(serializable2);
                        ((Vector)serializable3).add(object);
                        ((Vector)serializable3).add(serializable);
                        ((Vector)serializable3).add(new Float(10.0f));
                        ((Vector)serializable3).add(new Boolean(false));
                        ((Vector)serializable3).add(new Boolean(false));
                        this.block.add(serializable3);
                        continue;
                    }
                    if (!string.startsWith("tick")) continue;
                    stringTokenizer = new StringTokenizer(string, " ");
                    stringTokenizer.nextElement();
                    serializable3 = new Integer((String)stringTokenizer.nextElement());
                    serializable2 = Color.red;
                    if (stringTokenizer.hasMoreTokens()) {
                        serializable2 = this.embossColor[Integer.parseInt((String)stringTokenizer.nextElement())];
                    }
                    object = bufferedReader.readLine();
                    if (string.equals("endlabel")) {
                        object = "";
                    }
                    serializable = new Vector();
                    ((Vector)serializable).add(object);
                    ((Vector)serializable).add(serializable3);
                    ((Vector)serializable).add(serializable2);
                    this.restrictionEnzyme.add(serializable);
                }
            }
        }
        catch (IOException iOException) {
            System.out.println("SequenceReader Error");
        }
        System.out.println("Start : " + this.start);
        System.out.println("End   : " + this.end);
        return null;
    }

    protected Vector getRestrictionEnzyme() {
        return this.restrictionEnzyme;
    }

    protected Vector getBlock() {
        return this.block;
    }

    protected int getStart() {
        return this.start;
    }

    protected int getEnd() {
        return this.end;
    }
}

