/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.webapp.WebAppContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeclareRolesAnnotationHandler
implements AnnotationParser.AnnotationHandler {
    protected WebAppContext _wac;

    public DeclareRolesAnnotationHandler(WebAppContext wac) {
        this._wac = wac;
    }

    @Override
    public void handleClass(String className, int version, int access, String signature, String superName, String[] interfaces, String annotation, List<AnnotationParser.Value> values) {
        HashSet<String> roles = new HashSet<String>();
        try {
            Set<String> existing = ((ConstraintSecurityHandler)this._wac.getSecurityHandler()).getRoles();
            roles.addAll(existing);
            if (values != null && values.size() == 1) {
                AnnotationParser.Value v = values.get(0);
                if (v instanceof AnnotationParser.SimpleValue) {
                    roles.add((String)((AnnotationParser.SimpleValue)v).getValue());
                } else if (v instanceof AnnotationParser.ListValue) {
                    for (AnnotationParser.Value vv : ((AnnotationParser.ListValue)v).getList()) {
                        roles.add((String)((AnnotationParser.SimpleValue)vv).getValue());
                    }
                }
            }
        }
        catch (Exception e) {
            Log.warn(e);
        }
    }

    @Override
    public void handleField(String className, String fieldName, int access, String fieldType, String signature, Object value, String annotation, List<AnnotationParser.Value> values) {
        Log.warn("@DeclareRoles annotation not applicable for field: " + className + "." + fieldName);
    }

    @Override
    public void handleMethod(String className, String methodName, int access, String desc, String signature, String[] exceptions, String annotation, List<AnnotationParser.Value> values) {
        Log.warn("@DeclareRoles annotation not applicable for method: " + className + "." + methodName);
    }
}

