/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.container;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.activemq.kaha.impl.container.ContainerCollectionSupport;
import org.apache.activemq.kaha.impl.container.ContainerValueCollectionIterator;
import org.apache.activemq.kaha.impl.container.MapContainerImpl;
import org.apache.activemq.kaha.impl.index.IndexItem;
import org.apache.activemq.kaha.impl.index.IndexLinkedList;

class ContainerValueCollection
extends ContainerCollectionSupport
implements Collection {
    ContainerValueCollection(MapContainerImpl container) {
        super(container);
    }

    public boolean contains(Object o) {
        return this.container.containsValue(o);
    }

    public Iterator iterator() {
        IndexLinkedList list = this.container.getItemList();
        return new ContainerValueCollectionIterator(this.container, list, list.getRoot());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        IndexLinkedList list;
        Object[] result = null;
        IndexLinkedList indexLinkedList = list = this.container.getItemList();
        synchronized (indexLinkedList) {
            result = new Object[list.size()];
            IndexItem item = list.getFirst();
            int count = 0;
            while (item != null) {
                Object value = this.container.getValue(item);
                result[count++] = value;
                item = list.getNextEntry(item);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] result) {
        IndexLinkedList list;
        IndexLinkedList indexLinkedList = list = this.container.getItemList();
        synchronized (indexLinkedList) {
            if (result.length <= list.size()) {
                IndexItem item = list.getFirst();
                int count = 0;
                while (item != null) {
                    Object value = this.container.getValue(item);
                    result[count++] = value;
                    item = list.getNextEntry(item);
                }
            }
        }
        return result;
    }

    public boolean add(Object o) {
        throw new UnsupportedOperationException("Can't add an object here");
    }

    public boolean remove(Object o) {
        return this.container.removeValue(o);
    }

    public boolean containsAll(Collection c) {
        boolean result = !c.isEmpty();
        Iterator i = c.iterator();
        while (i.hasNext()) {
            if (this.contains(i.next())) continue;
            result = false;
            break;
        }
        return result;
    }

    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException("Can't add everything here!");
    }

    public boolean removeAll(Collection c) {
        boolean result = true;
        for (Object obj : c) {
            result &= this.remove(obj);
        }
        return result;
    }

    public boolean retainAll(Collection c) {
        ArrayList tmpList = new ArrayList();
        for (Object o : c) {
            if (this.contains(o)) continue;
            tmpList.add(o);
        }
        Iterator i = tmpList.iterator();
        while (i.hasNext()) {
            this.remove(i.next());
        }
        return !tmpList.isEmpty();
    }

    public void clear() {
        this.container.clear();
    }
}

