/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.util.ftp;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.tribble.util.ftp.FTPClient;
import org.broad.tribble.util.ftp.FTPReply;
import org.broad.tribble.util.ftp.UserPasswordInput;

public class FTPUtils {
    private static Logger log = Logger.getLogger(FTPUtils.class);
    static Map<String, String> userCredentials = new HashMap<String, String>();

    public static boolean resourceAvailable(URL url) {
        InputStream is = null;
        try {
            URLConnection conn = url.openConnection();
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(10000);
            is = conn.getInputStream();
            boolean bl = is.read() >= 0;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error closing connection", (Throwable)e);
                }
            }
        }
    }

    public static synchronized FTPClient connect(String host, String userInfo, UserPasswordInput userPasswordInput) throws IOException {
        log.info((Object)"connect");
        FTPClient ftp = new FTPClient();
        FTPReply reply = ftp.connect(host);
        if (!reply.isSuccess()) {
            throw new RuntimeException("Could not connect to " + host);
        }
        String user = "anonymous";
        String password = "igv@broadinstitute.org";
        if (userInfo == null) {
            userInfo = userCredentials.get(host);
        }
        if (userInfo != null) {
            String[] tmp = userInfo.split(":");
            user = tmp[0];
            if (tmp.length > 1) {
                password = tmp[1];
            }
        }
        if (!(reply = ftp.login(user, password)).isSuccess()) {
            if (userPasswordInput == null) {
                throw new RuntimeException("Login failure for host: " + host);
            }
            userPasswordInput.setHost(host);
            boolean success = false;
            while (!success) {
                if (!userPasswordInput.showDialog()) break;
                user = userPasswordInput.getUser();
                password = userPasswordInput.getPassword();
                reply = ftp.login(user, password);
                success = reply.isSuccess();
            }
            if (success) {
                userInfo = String.valueOf(user) + ":" + password;
                userCredentials.put(host, userInfo);
            } else {
                throw new RuntimeException("Login failure for host: " + host);
            }
        }
        if (!(reply = ftp.binary()).isSuccess()) {
            throw new RuntimeException("Could not set binary mode on host: " + host);
        }
        log.info((Object)("Connected to " + host));
        return ftp;
    }
}

