/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.icepdf.core.pobjects.fonts.FontFile;
import org.icepdf.core.pobjects.graphics.text.GlyphText;
import org.icepdf.core.util.Defs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextSprite {
    private static final boolean OPTIMIZED_DRAWING_ENABLED = Defs.booleanProperty("org.icepdf.core.text.optimized", true);
    private ArrayList<GlyphText> glyphTexts;
    Rectangle2D.Float bounds;
    private AffineTransform graphicStateTransform;
    private Color strokeColor;
    private int rmode;
    private FontFile font;

    public TextSprite(FontFile font, int size, AffineTransform graphicStateTransform) {
        this.glyphTexts = new ArrayList(size);
        this.graphicStateTransform = graphicStateTransform;
        this.font = font;
        this.bounds = new Rectangle2D.Float();
    }

    public GlyphText addText(char character, char unicode, float x, float y, float width) {
        float w = width;
        float h = (float)(this.font.getAscent() + this.font.getDescent());
        if (h <= 0.0f) {
            h = (float)this.font.getMaxCharBounds().getHeight();
        }
        if (w <= 0.0f) {
            w = (float)this.font.getMaxCharBounds().getWidth();
        }
        if (h <= 0.0f) {
            h = 1.0f;
        }
        if (w <= 0.0f) {
            w = 1.0f;
        }
        Rectangle2D.Float glyphBounds = new Rectangle2D.Float(x, y - (float)this.font.getAscent(), w, h);
        this.bounds.add(glyphBounds);
        GlyphText glyphText = new GlyphText(x, y, glyphBounds, character, unicode);
        glyphText.normalizeToUserSpace(this.graphicStateTransform);
        this.glyphTexts.add(glyphText);
        return glyphText;
    }

    public ArrayList<GlyphText> getGlyphSprites() {
        return this.glyphTexts;
    }

    public AffineTransform getGraphicStateTransform() {
        return this.graphicStateTransform;
    }

    public void setGraphicStateTransform(AffineTransform graphicStateTransform) {
        this.graphicStateTransform = graphicStateTransform;
        for (GlyphText sprite : this.glyphTexts) {
            sprite.normalizeToUserSpace(this.graphicStateTransform);
        }
    }

    public void setRMode(int rmode) {
        if (rmode >= 0) {
            this.rmode = rmode;
        }
    }

    public String toString() {
        StringBuilder text = new StringBuilder(this.glyphTexts.size());
        for (GlyphText glyphText : this.glyphTexts) {
            text.append(glyphText.getUnicode());
        }
        return text.toString();
    }

    public void setStrokeColor(Color color) {
        this.strokeColor = color;
    }

    public Rectangle2D.Float getBounds() {
        return this.bounds;
    }

    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        for (GlyphText glyphText : this.glyphTexts) {
            this.font.drawEstring(g2d, String.valueOf((char)glyphText.getCid()), glyphText.getX(), glyphText.getY(), 0L, this.rmode, this.strokeColor);
        }
    }

    public boolean intersects(Shape shape) {
        return !OPTIMIZED_DRAWING_ENABLED || shape.intersects(this.bounds);
    }

    public void dispose() {
        this.glyphTexts.clear();
        this.glyphTexts.trimToSize();
        this.strokeColor = null;
        this.font = null;
    }
}

