/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.message;

public class Chromosome
implements Comparable<Chromosome> {
    public static final String CHROMOSOME_PREFIX = "chr";
    private String chr;
    private Integer intValue;
    private String chrNormalised;

    public Chromosome(String chr) {
        this.chr = chr;
        this.chrNormalised = this.normalise(chr);
        try {
            this.intValue = Integer.parseInt(this.chrNormalised);
        }
        catch (NumberFormatException e) {
            this.intValue = null;
        }
    }

    private String normalise(String original) {
        if (original.indexOf(".") != -1) {
            original = original.substring(0, original.indexOf("."));
        }
        return original.replace(CHROMOSOME_PREFIX, "");
    }

    public Chromosome(Chromosome chromosome) {
        this(chromosome.chr);
    }

    public boolean equals(Object o) {
        if (o instanceof Chromosome) {
            Chromosome other = (Chromosome)o;
            return this.chrNormalised.equals(other.chrNormalised);
        }
        return false;
    }

    public int hashCode() {
        return this.chrNormalised.hashCode();
    }

    @Override
    public int compareTo(Chromosome o) {
        if (this.intValue != null && o.intValue != null) {
            return this.intValue.compareTo(o.intValue);
        }
        if (this.intValue != null && o.intValue == null) {
            return -1;
        }
        if (this.intValue == null && o.intValue != null) {
            return 1;
        }
        return this.chrNormalised.compareTo(o.chrNormalised);
    }

    public String getOriginalName() {
        return this.chr;
    }

    public String toString() {
        return this.chrNormalised;
    }

    public String toNormalisedString() {
        return this.chrNormalised;
    }

    public Chromosome clone() {
        return new Chromosome(this.chr);
    }
}

