/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.Chunk;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnDefinition;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.FileDefinition;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.TsvParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.Type;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import fi.csc.microarray.util.IOUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class VcfParser
extends TsvParser {
    private static final String VCF_HEADER_START = "#";
    public static List<ColumnDefinition> completeVcfColumns = Arrays.asList(new ColumnDefinition(ColumnType.CHROMOSOME, Type.STRING), new ColumnDefinition(ColumnType.BP_START, Type.LONG));
    private Long headerLength;

    public VcfParser() {
        super(new FileDefinition((Collection<ColumnDefinition>)completeVcfColumns));
    }

    public VcfParser(FileDefinition fileDefinition) {
        super(fileDefinition);
    }

    @Override
    public String getName() {
        return "Vcf";
    }

    @Override
    public long getDefaulChunkLength() {
        return 256L;
    }

    @Override
    public Object get(String[] cols, ColumnType col) {
        if (col == ColumnType.BP_END) {
            Object obj = super.get(cols, ColumnType.BP_START);
            return obj;
        }
        Object obj = super.get(cols, col);
        return obj;
    }

    @Override
    public RegionContent[] concise(Chunk chunk) {
        return new RegionContent[0];
    }

    public long getHeaderLength(String string) throws IOException {
        BufferedReader reader = new BufferedReader(new StringReader(string));
        return this.getHeaderLength(reader);
    }

    public long getHeaderLength(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        long bytes = 0L;
        while (line != null && line.startsWith(VCF_HEADER_START)) {
            bytes += (long)(line.length() + 1);
            line = reader.readLine();
        }
        return bytes - 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getHeaderLength(File file) throws IOException {
        if (this.headerLength == null) {
            BufferedReader in = null;
            try {
                in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                this.headerLength = this.getHeaderLength(in);
            }
            catch (Throwable throwable) {
                IOUtils.closeIfPossible(in);
                throw throwable;
            }
            IOUtils.closeIfPossible(in);
        }
        return this.headerLength;
    }
}

