/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.Chunk;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnDefinition;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.FileDefinition;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.TsvParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.Type;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import fi.csc.microarray.util.IOUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class BEDParser
extends TsvParser {
    private static final String BED_HEADER_STRING = "track";
    public static List<ColumnDefinition> completeBedColumns = Arrays.asList(new ColumnDefinition(ColumnType.CHROMOSOME, Type.STRING), new ColumnDefinition(ColumnType.BP_START, Type.LONG), new ColumnDefinition(ColumnType.BP_END, Type.LONG), new ColumnDefinition(ColumnType.ID, Type.STRING), new ColumnDefinition(ColumnType.VALUE, Type.FLOAT), new ColumnDefinition(ColumnType.STRAND, Type.STRING), new ColumnDefinition(ColumnType.THICK_START, Type.STRING), new ColumnDefinition(ColumnType.THICK_END, Type.STRING), new ColumnDefinition(ColumnType.ITEM_RGB, Type.STRING), new ColumnDefinition(ColumnType.BLOCK_COUNT, Type.STRING), new ColumnDefinition(ColumnType.BLOCK_SIZES, Type.STRING), new ColumnDefinition(ColumnType.BLOCK_STARTS, Type.STRING));

    public BEDParser() {
        super(new FileDefinition((Collection<ColumnDefinition>)completeBedColumns));
    }

    public BEDParser(FileDefinition fileDefinition) {
        super(fileDefinition);
    }

    @Override
    public String getName() {
        return "Chipster peaks";
    }

    @Override
    public long getDefaulChunkLength() {
        return 128L;
    }

    @Override
    public RegionContent[] concise(Chunk chunk) {
        return new RegionContent[0];
    }

    @Override
    public Object get(String[] cols, ColumnType col) {
        Object obj = super.get(cols, col);
        return obj;
    }

    public long getHeaderLength(String string) throws IOException {
        BufferedReader reader = new BufferedReader(new StringReader(string));
        return this.getHeaderLength(reader);
    }

    public long getHeaderLength(BufferedReader reader) throws IOException {
        String firstLine = reader.readLine();
        if (firstLine != null && firstLine.startsWith(BED_HEADER_STRING)) {
            return firstLine.length();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getHeaderLength(File file) throws IOException {
        long l;
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            l = this.getHeaderLength(in);
        }
        catch (Throwable throwable) {
            IOUtils.closeIfPossible(in);
            throw throwable;
        }
        IOUtils.closeIfPossible(in);
        return l;
    }
}

