/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher;

import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;

public class Cytoband
implements Comparable<Cytoband> {
    private Region region;
    private String band;
    private Stain stain;

    public Cytoband(Region region, String band, String stain) {
        this.region = region;
        this.band = band;
        this.stain = this.getStain(stain);
    }

    public Cytoband(Region region, String band, Stain stain) {
        this.region = region;
        this.band = band;
        this.stain = stain;
    }

    public Cytoband(BpCoord coord) {
        this.region = new Region(coord, coord);
    }

    private Stain getStain(String id) {
        for (Stain stain : Stain.values()) {
            if (!stain.getId().equals(id)) continue;
            return stain;
        }
        return Stain.UNRECOGNIZED;
    }

    @Override
    public int compareTo(Cytoband other) {
        int regionComparison = this.region.compareTo(other.region);
        int bandComparison = 0;
        int stainComparison = 0;
        if (this.band != null && other.getBand() != null) {
            bandComparison = this.band.compareTo(other.getBand());
        } else if (this.band == null && other.getBand() == null) {
            bandComparison = 0;
        } else if (this.band == null) {
            bandComparison = -1;
        }
        if (this.stain != null && other.getBand() != null) {
            stainComparison = this.stain.compareTo(other.getStain());
        } else if (this.stain == null && other.getBand() == null) {
            stainComparison = 0;
        } else if (this.stain == null) {
            stainComparison = -1;
        }
        if (regionComparison != 0) {
            return regionComparison;
        }
        if (bandComparison != 0) {
            return bandComparison;
        }
        return stainComparison;
    }

    public Stain getStain() {
        return this.stain;
    }

    public String getBand() {
        return this.band;
    }

    public int hashCode() {
        return this.region.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Cytoband) {
            return this.compareTo((Cytoband)o) == 0;
        }
        return false;
    }

    public String toString() {
        return this.region.toString(true) + ", " + this.band + ", " + this.stain.getId();
    }

    public Region getRegion() {
        return this.region;
    }

    public static enum Stain {
        GNEG("gneg"),
        GPOS25("gpos25"),
        GPOS33("gpos33"),
        GPOS50("gpos50"),
        GPOS66("gpos66"),
        GPOS75("gpos75"),
        GPOS100("gpos100"),
        GPOS("gpos"),
        ACEN("acen"),
        GVAR("gvar"),
        STALK("stalk"),
        TIP("tip"),
        UNRECOGNIZED(null);

        private String id;

        private Stain(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }
}

