/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaResultListener;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaResult;
import java.util.Queue;
import javax.swing.SwingUtilities;

public abstract class AreaRequestHandler
extends Thread {
    private Queue<AreaRequest> areaRequestQueue;
    private AreaResultListener areaResultListener;
    private boolean poison = false;

    public AreaRequestHandler(Queue<AreaRequest> areaRequestQueue, AreaResultListener areaResultListener) {
        this.areaRequestQueue = areaRequestQueue;
        this.areaResultListener = areaResultListener;
        this.setDaemon(true);
    }

    @Override
    public synchronized void run() {
        while (!this.poison) {
            AreaRequest areaRequest = this.areaRequestQueue.poll();
            if (areaRequest != null) {
                areaRequest.status.areaRequestCount = this.areaRequestQueue.size();
                this.processAreaRequest(areaRequest);
            }
            boolean isWorkToDo = this.checkOtherQueues();
            if (areaRequest != null || isWorkToDo) continue;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected boolean checkOtherQueues() {
        return false;
    }

    public synchronized void notifyAreaRequestHandler() {
        this.notifyAll();
    }

    protected void processAreaRequest(AreaRequest areaRequest) {
        if (areaRequest.status.poison) {
            this.areaResultListener = null;
            this.poison = true;
        }
    }

    public void createAreaResult(final AreaResult areaResult) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AreaRequestHandler.this.areaResultListener != null) {
                    AreaRequestHandler.this.areaResultListener.processAreaResult(areaResult);
                }
            }
        });
    }
}

