/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation;

import fi.csc.microarray.client.visualisation.methods.gbrowser.GenomePlot;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;

public class NonScalableChartPanel
extends ChartPanel {
    private GenomePlot genomePlot;

    public NonScalableChartPanel() {
        super(null);
    }

    public NonScalableChartPanel(JFreeChart chart) {
        super(chart);
    }

    public void paintComponent(Graphics g) {
        int height = this.getParent().getSize().height;
        if (this.genomePlot != null && this.genomePlot.isFullHeight()) {
            height = this.genomePlot.getHeightTotal();
        }
        Dimension size = new Dimension(this.getParent().getSize().width, height);
        this.setPreferredSize(size);
        this.setSize(size);
        Insets insets = this.getInsets();
        Rectangle2D.Double available = new Rectangle2D.Double(insets.left, insets.top, size.getWidth() - (double)insets.left - (double)insets.right, size.getHeight() - (double)insets.top - (double)insets.bottom);
        this.setMinimumDrawWidth((int)((RectangularShape)available).getWidth() - 1);
        this.setMinimumDrawHeight((int)((RectangularShape)available).getHeight() - 1);
        this.setMaximumDrawWidth((int)((RectangularShape)available).getWidth() + 1);
        this.setMaximumDrawHeight((int)((RectangularShape)available).getHeight() + 1);
        super.paintComponent(g);
    }

    public void setGenomePlot(GenomePlot plot) {
        this.genomePlot = plot;
    }
}

