/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dialog;

import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.SwingClientApplication;
import fi.csc.microarray.client.dataimport.ImportUtils;
import fi.csc.microarray.constants.VisualConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class URLImportDialog
extends JDialog
implements ActionListener {
    private final Dimension BUTTON_SIZE = new Dimension(70, 25);
    private final Dimension COMBO_SIZE = new Dimension(300, 25);
    private final Dimension LABEL_SIZE = new Dimension(100, 25);
    private final int RECENT_URL_COUNT = 10;
    private JCheckBox skipCheckBox;
    private JLabel label;
    private JButton okButton;
    private JButton cancelButton;
    private JComboBox URLComboBox;
    private JComboBox folderNameCombo;
    private static LinkedList<String> recentURLs;
    private SwingClientApplication client;
    private URL selectedURL;

    public URLImportDialog(SwingClientApplication client) {
        super((Frame)client.getMainFrame(), true);
        if (recentURLs == null) {
            recentURLs = new LinkedList();
        }
        this.client = client;
        this.setTitle("Import data from URL");
        this.setModal(true);
        this.label = new JLabel("Insert URL");
        this.label.setFont(this.label.getFont().deriveFont(1));
        this.label.setPreferredSize(this.LABEL_SIZE);
        this.folderNameCombo = new JComboBox<Object>(ImportUtils.getFolderNames(true).toArray());
        this.folderNameCombo.setEditable(true);
        this.skipCheckBox = new JCheckBox(VisualConstants.getImportDirectlyText());
        if (!Session.getSession().getApplication().isStandalone()) {
            this.skipCheckBox.setSelected(true);
        } else {
            this.skipCheckBox.setSelected(false);
        }
        this.okButton = new JButton("OK");
        this.okButton.setPreferredSize(this.BUTTON_SIZE);
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setPreferredSize(this.BUTTON_SIZE);
        this.cancelButton.addActionListener(this);
        String[] comboValues = new String[recentURLs.size() + 1];
        comboValues[0] = "http://";
        for (int i = 0; i < recentURLs.size(); ++i) {
            comboValues[i + 1] = recentURLs.get(i);
        }
        this.URLComboBox = new JComboBox<String>(comboValues);
        this.URLComboBox.setBackground(Color.WHITE);
        this.URLComboBox.setPreferredSize(this.COMBO_SIZE);
        this.URLComboBox.setEditable(true);
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        c.anchor = 17;
        c.insets.set(10, 10, 5, 10);
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.label, c);
        c.insets.set(0, 10, 10, 10);
        ++c.gridy;
        this.add((Component)this.URLComboBox, c);
        c.insets.set(10, 10, 5, 10);
        ++c.gridy;
        this.add((Component)new JLabel("Insert in folder"), c);
        c.fill = 2;
        c.insets.set(0, 10, 10, 10);
        ++c.gridy;
        this.add((Component)this.folderNameCombo, c);
        c.insets.set(10, 10, 10, 10);
        c.anchor = 13;
        ++c.gridy;
        this.add((Component)this.skipCheckBox, c);
        c.fill = 2;
        ++c.gridy;
        JPanel keepButtonsRightPanel = new JPanel();
        keepButtonsRightPanel.add(this.okButton);
        keepButtonsRightPanel.add(this.cancelButton);
        this.add((Component)keepButtonsRightPanel, c);
        this.pack();
        this.setLocationRelativeTo(null);
        this.URLComboBox.requestFocusInWindow();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.setSelectedURL();
            this.dispose();
        } else if (e.getSource() == this.cancelButton) {
            this.selectedURL = null;
            this.dispose();
        }
    }

    public URL getSelectedURL() {
        return this.selectedURL;
    }

    public String getSelectedFolderName() {
        return this.folderNameCombo.getSelectedItem().toString();
    }

    public boolean isSkipSelected() {
        return this.skipCheckBox.isSelected();
    }

    private void setSelectedURL() {
        URL url;
        try {
            url = new URL(this.URLComboBox.getSelectedItem().toString());
        }
        catch (MalformedURLException e1) {
            JOptionPane.showMessageDialog(this.client.getMainFrame(), "Malformed URL", "Malformed URL", 0);
            url = null;
        }
        if (url != null) {
            this.selectedURL = url;
            this.addToRecentURLList(url.toString());
        } else {
            this.selectedURL = null;
        }
    }

    private void addToRecentURLList(String url) {
        if (!recentURLs.contains(this.selectedURL.toString())) {
            if (recentURLs.size() == 10) {
                recentURLs.removeLast();
            }
            recentURLs.addFirst(url);
        }
    }
}

