/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dataviews.vertexes;

import fi.csc.microarray.client.dataviews.vertexes.AbstractGraphVertex;
import fi.csc.microarray.client.dataviews.vertexes.GraphVertex;
import fi.csc.microarray.client.dataviews.vertexes.GroupVertex;
import fi.csc.microarray.client.dataviews.vertexes.PhenodataVertex;
import fi.csc.microarray.constants.VisualConstants;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.image.ImageObserver;
import javax.swing.ImageIcon;
import org.jgraph.JGraph;
import org.jgraph.graph.CellView;
import org.jgraph.graph.VertexRenderer;

public class GraphRenderer
extends VertexRenderer {
    public static Rectangle phenodata = new Rectangle(0, 0, 0, 0);
    protected boolean isGroup = false;
    protected boolean isPhenodata = false;
    protected boolean isSelected = false;
    protected Color graphForeground = Color.black;
    private JGraph graph;
    private AbstractGraphVertex vertex;

    public Component getRendererComponent(JGraph graph, CellView view, boolean sel, boolean focus, boolean preview) {
        this.isSelected = sel;
        this.graphForeground = graph.getForeground();
        this.isGroup = view.getCell() instanceof GroupVertex;
        this.isPhenodata = view.getCell() instanceof PhenodataVertex;
        if (view.getCell() instanceof AbstractGraphVertex) {
            this.vertex = this.isGroup ? (GroupVertex)((Object)view.getCell()) : (this.isPhenodata ? (PhenodataVertex)((Object)view.getCell()) : (GraphVertex)((Object)view.getCell()));
        }
        this.graph = graph;
        return super.getRendererComponent(graph, view, sel, focus, preview);
    }

    public void paint(Graphics g) {
        if (this.isGroup) {
            if (this.hasFocus || this.selected) {
                this.setFont(this.getFont().deriveFont(1));
            }
        } else if (this.selected) {
            this.setFont(this.getFont().deriveFont(1));
        }
        if (this.isPhenodata) {
            int b = this.borderWidth;
            Graphics2D g2 = (Graphics2D)g;
            Dimension d = this.getSize();
            if (super.isOpaque()) {
                g.setColor(super.getBackground());
                if (this.gradientColor != null && !this.preview) {
                    this.setOpaque(false);
                    g2.setPaint(new GradientPaint(0.0f, 0.0f, this.getBackground(), this.getWidth(), this.getHeight(), this.gradientColor, true));
                }
                g.fillOval(b - 1, b - 1, d.width - b, d.height - b);
            }
            this.setBorder(null);
            super.paint(g);
            if (!this.selected) {
                g.setColor(this.bordercolor);
                g2.setStroke(new BasicStroke(b));
                g.drawOval(0, 0, d.width - 1, d.height - 1);
            }
        } else {
            super.paint(g);
        }
        if (this.isPhenodata && !((PhenodataVertex)this.vertex).isPhenodataSet()) {
            ImageIcon icon = VisualConstants.PHENODATA_ICON;
            double iconHeight = icon.getIconHeight();
            double iconWidth = icon.getIconWidth();
            Dimension d = this.getSize();
            Image img = icon.getImage();
            double xPos = 2.4f;
            double yPos = 1.3f;
            g.setClip((int)(g.getClipBounds().getX() - iconWidth / xPos), (int)g.getClipBounds().getY(), (int)(g.getClipBounds().getWidth() + iconWidth / (1.0 / xPos)), (int)(g.getClipBounds().getHeight() + iconHeight / (1.0 / yPos)));
            g.drawImage(img, (int)(-iconWidth / xPos), (int)(d.getHeight() - iconHeight / yPos), (int)iconWidth, (int)iconHeight, (ImageObserver)this.graph);
            phenodata.setBounds(new Rectangle((int)(-iconWidth / xPos), (int)(d.getHeight() - iconHeight / yPos), (int)iconWidth, (int)iconHeight));
        }
    }

    public void paintSelectionBorder(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Stroke previousStroke = g2.getStroke();
        boolean paintBorders = false;
        if (this.selected) {
            g2.setStroke(GraphVertex.SELECTION_STROKE);
            g.setColor(GraphVertex.SELECTED_BORDER_COLOR);
            paintBorders = true;
        }
        if (paintBorders) {
            Dimension d = this.getSize();
            if (this.isPhenodata) {
                g.drawOval(0, 0, d.width - 1, d.height - 1);
            } else {
                g.drawRect(0, 0, d.width - 1, d.height - 1);
            }
        }
        g2.setStroke(previousStroke);
    }
}

