/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser.ws;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;

public class ResultTableCollector {
    private LinkedList<ResultRow> resultRows = new LinkedList();
    private Set<String> fieldNames = new LinkedHashSet<String>();

    public void addAnnotation(int index, String fieldName, String value) {
        this.addRowsTo(index);
        this.resultRows.get(index).addValue(fieldName, value);
        this.fieldNames.add(fieldName);
    }

    public void filterRows(RowFilter filter) {
        LinkedList<ResultRow> removed = new LinkedList<ResultRow>();
        for (ResultRow row : this.resultRows) {
            if (!filter.shouldRemove(row)) continue;
            removed.add(row);
        }
        this.resultRows.removeAll(removed);
    }

    public String[][] asTable(String[] columns) {
        String[][] table = new String[this.resultRows.size()][columns.length];
        int n = 0;
        int m = 0;
        for (ResultRow row : this.resultRows) {
            for (String column : columns) {
                table[n][m] = row.getValue(column);
                ++m;
            }
            ++n;
            m = 0;
        }
        return table;
    }

    private void addRowsTo(int index) {
        while (this.resultRows.size() < index + 1) {
            this.resultRows.add(new ResultRow());
        }
    }

    public String[] getFieldNames() {
        return this.fieldNames.toArray(new String[this.fieldNames.size()]);
    }

    public static interface RowFilter {
        public boolean shouldRemove(ResultRow var1);
    }

    private static class ResultField {
        private String name;
        private String value;

        public ResultField(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class ResultRow {
        private HashMap<String, ResultField> fields = new HashMap();

        public void addValue(String fieldName, String value) {
            if (this.fields.containsKey(fieldName)) {
                throw new IllegalStateException(fieldName + " already added");
            }
            this.fields.put(fieldName, new ResultField(fieldName, value));
        }

        public String getValue(String fieldName) {
            if (!this.fields.containsKey(fieldName)) {
                throw new IllegalArgumentException("field " + fieldName + " not found");
            }
            return this.fields.get(fieldName).getValue();
        }
    }
}

