/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser.emboss;

import fi.csc.microarray.analyser.emboss.ACDDescription;
import fi.csc.microarray.analyser.emboss.ACDParameter;
import fi.csc.microarray.analyser.emboss.ACDToSADL;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.description.SADLDescription;
import fi.csc.microarray.description.SADLParser;
import java.io.File;
import org.testng.Assert;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Test;

public class ACDToSADLTest {
    private static String path = "src/test/resources/";

    @BeforeSuite
    protected void setUp() throws Exception {
        DirectoryLayout.initialiseSimpleLayout();
    }

    public static ACDDescription getTestDescription(String appName) {
        ACDDescription acd = new ACDDescription(new File(path + appName + ".acd"));
        return acd;
    }

    @Test
    public void testACDToSADL() {
        ACDDescription acd = ACDToSADLTest.getTestDescription("water");
        SADLDescription sadl = ACDToSADL.convert(acd, "water.acd");
        Assert.assertEquals((int)sadl.parameters().size(), (int)3);
        Assert.assertEquals((int)sadl.inputs().size(), (int)2);
        Assert.assertEquals((int)sadl.outputs().size(), (int)1);
        Assert.assertEquals((String)sadl.parameters().get(0).getFrom(), (String)"0.0");
        Assert.assertEquals((String)sadl.parameters().get(0).getTo(), (String)"100.0");
        ACDParameter acdParam = new ACDParameter("list", "param", "", null);
        String[] titles = new String[]{"all", "your", "base"};
        String[] values = new String[]{"a", "y", "b"};
        acdParam.setList(titles, values);
        acdParam.setAttribute("information", "List param");
        acdParam.setAttribute("help", "Long description");
        SADLDescription.Parameter sadlParam = ACDToSADL.SADLParameterCreator.createParameter(acdParam);
        Assert.assertEquals((String)sadlParam.getName().getDisplayName(), (String)"List param");
        Assert.assertEquals((String)sadlParam.getComment(), (String)"Long description");
        Assert.assertEquals((String)sadlParam.getSelectionOptions()[0].toString(), (String)SADLDescription.Name.createName("a", "all").toString());
        acd = ACDToSADLTest.getTestDescription("complex");
        sadl = ACDToSADL.convert(acd, "complex.acd");
        Assert.assertEquals((int)acd.getParameter("multiple").getDefaults().length, (int)3);
        for (SADLDescription.Parameter parameter : sadl.parameters()) {
            if (!parameter.getName().getID().equals("multiple")) continue;
            Assert.assertEquals((String)parameter.getFrom(), (String)"1");
            Assert.assertEquals((String)parameter.getTo(), (String)"4");
            Assert.assertEquals((int)parameter.getDefaultValues().length, (int)3);
            Assert.assertEquals((String)parameter.getDefaultValues()[0], (String)"b");
            Assert.assertEquals((String)parameter.getDefaultValues()[1], (String)"o");
            Assert.assertEquals((String)parameter.getDefaultValues()[2], (String)"g");
        }
        try {
            sadl = new SADLParser().parse(sadl.toString());
            for (SADLDescription.Parameter parameter : sadl.parameters()) {
                if (!parameter.getName().getID().equals("multiple")) continue;
                Assert.assertEquals((String)parameter.getFrom(), (String)"1");
                Assert.assertEquals((String)parameter.getTo(), (String)"4");
                Assert.assertEquals((int)parameter.getDefaultValues().length, (int)3);
                Assert.assertEquals((String)parameter.getDefaultValues()[0], (String)"b");
                Assert.assertEquals((String)parameter.getDefaultValues()[1], (String)"o");
                Assert.assertEquals((String)parameter.getDefaultValues()[2], (String)"g");
            }
        }
        catch (SADLParser.ParseException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        ACDToSADLTest test = new ACDToSADLTest();
        test.setUp();
        test.testACDToSADL();
    }
}

