/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import org.apache.camel.BinaryPredicate;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;

public final class PredicateAssertHelper {
    private PredicateAssertHelper() {
    }

    public static void assertMatches(Predicate predicate, String text, Exchange exchange) {
        if (predicate instanceof BinaryPredicate) {
            BinaryPredicate eval = (BinaryPredicate)predicate;
            if (!eval.matches(exchange)) {
                String evalText = eval.getLeftValue() + " " + eval.getOperator() + " " + eval.getRightValue();
                if (text == null) {
                    throw new AssertionError((Object)(predicate + " evaluated as " + evalText + "  on " + exchange));
                }
                throw new AssertionError((Object)(text + predicate + " evaluated as: " + evalText + " on " + exchange));
            }
        } else {
            PredicateAssertHelper.doAssertMatches(predicate, text, exchange);
        }
    }

    private static void doAssertMatches(Predicate predicate, String text, Exchange exchange) {
        if (!predicate.matches(exchange)) {
            if (text == null) {
                throw new AssertionError((Object)(predicate + " on " + exchange));
            }
            throw new AssertionError((Object)(text + predicate + " on " + exchange));
        }
    }
}

