/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.activemq.broker.SslContext;
import org.apache.activemq.command.DiscoveryEvent;
import org.apache.activemq.network.DemandForwardingBridge;
import org.apache.activemq.network.NetworkBridge;
import org.apache.activemq.network.NetworkBridgeFactory;
import org.apache.activemq.network.NetworkBridgeListener;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportDisposedIOException;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.transport.discovery.DiscoveryAgent;
import org.apache.activemq.transport.discovery.DiscoveryAgentFactory;
import org.apache.activemq.transport.discovery.DiscoveryListener;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.util.ServiceSupport;
import org.apache.activemq.util.URISupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DiscoveryNetworkConnector
extends NetworkConnector
implements DiscoveryListener {
    private static final Log LOG = LogFactory.getLog(DiscoveryNetworkConnector.class);
    private DiscoveryAgent discoveryAgent;
    private Map<String, String> parameters;

    public DiscoveryNetworkConnector() {
    }

    public DiscoveryNetworkConnector(URI discoveryURI) throws IOException {
        this.setUri(discoveryURI);
    }

    public void setUri(URI discoveryURI) throws IOException {
        this.setDiscoveryAgent(DiscoveryAgentFactory.createDiscoveryAgent(discoveryURI));
        try {
            this.parameters = URISupport.parseParameters(discoveryURI);
            IntrospectionSupport.setProperties(this.getDiscoveryAgent(), this.parameters);
        }
        catch (URISyntaxException e) {
            LOG.warn((Object)("failed to parse query parameters from discoveryURI: " + discoveryURI), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onServiceAdd(DiscoveryEvent event) {
        if (this.serviceSupport.isStopped() || this.serviceSupport.isStopping()) {
            return;
        }
        String url = event.getServiceName();
        if (url != null) {
            Transport localTransport;
            Transport remoteTransport;
            URI uri;
            try {
                uri = new URI(url);
            }
            catch (URISyntaxException e) {
                LOG.warn((Object)("Could not connect to remote URI: " + url + " due to bad URI syntax: " + e), (Throwable)e);
                return;
            }
            if (this.bridges.containsKey(uri)) {
                LOG.debug((Object)("Discovery agent generated a duplicate onServiceAdd event for: " + uri));
                return;
            }
            if (this.localURI.equals(uri) || this.connectionFilter != null && !this.connectionFilter.connectTo(uri)) {
                LOG.debug((Object)("not connecting loopback: " + uri));
                return;
            }
            URI connectUri = uri;
            try {
                connectUri = URISupport.removeQuery(connectUri);
                connectUri = URISupport.applyParameters(connectUri, this.parameters);
            }
            catch (URISyntaxException e) {
                LOG.warn((Object)("could not apply query parameters: " + this.parameters + " to: " + connectUri), (Throwable)e);
            }
            LOG.info((Object)("Establishing network connection from " + this.localURI + " to " + connectUri));
            try {
                SslContext.setCurrentSslContext(this.getBrokerService().getSslContext());
                try {
                    remoteTransport = TransportFactory.connect(connectUri);
                }
                catch (Exception e) {
                    LOG.warn((Object)("Could not connect to remote URI: " + connectUri + ": " + e.getMessage()));
                    LOG.debug((Object)("Connection failure exception: " + e), (Throwable)e);
                    SslContext.setCurrentSslContext(null);
                    return;
                }
                try {
                    localTransport = this.createLocalTransport();
                }
                catch (Exception e) {
                    ServiceSupport.dispose(remoteTransport);
                    LOG.warn((Object)("Could not connect to local URI: " + this.localURI + ": " + e.getMessage()));
                    LOG.debug((Object)("Connection failure exception: " + e), (Throwable)e);
                    SslContext.setCurrentSslContext(null);
                    return;
                }
            }
            finally {
                SslContext.setCurrentSslContext(null);
            }
            NetworkBridge bridge = this.createBridge(localTransport, remoteTransport, event);
            try {
                bridge.start();
                this.bridges.put(uri, bridge);
            }
            catch (TransportDisposedIOException e) {
                LOG.warn((Object)("Network bridge between: " + this.localURI + " and: " + uri + " was correctly stopped before it was correctly started."));
            }
            catch (Exception e) {
                ServiceSupport.dispose(localTransport);
                ServiceSupport.dispose(remoteTransport);
                LOG.warn((Object)("Could not start network bridge between: " + this.localURI + " and: " + uri + " due to: " + e));
                LOG.debug((Object)("Start failure exception: " + e), (Throwable)e);
                try {
                    this.discoveryAgent.serviceFailed(event);
                }
                catch (IOException e1) {
                    LOG.debug((Object)("Discovery agent failure while handling failure event: " + e1.getMessage()), (Throwable)e1);
                }
                return;
            }
        }
    }

    public void onServiceRemove(DiscoveryEvent event) {
        String url = event.getServiceName();
        if (url != null) {
            URI uri;
            try {
                uri = new URI(url);
            }
            catch (URISyntaxException e) {
                LOG.warn((Object)("Could not connect to remote URI: " + url + " due to bad URI syntax: " + e), (Throwable)e);
                return;
            }
            NetworkBridge bridge = (NetworkBridge)this.bridges.remove(uri);
            if (bridge == null) {
                return;
            }
            ServiceSupport.dispose(bridge);
        }
    }

    public DiscoveryAgent getDiscoveryAgent() {
        return this.discoveryAgent;
    }

    public void setDiscoveryAgent(DiscoveryAgent discoveryAgent) {
        this.discoveryAgent = discoveryAgent;
        if (discoveryAgent != null) {
            this.discoveryAgent.setDiscoveryListener(this);
        }
    }

    protected void handleStart() throws Exception {
        if (this.discoveryAgent == null) {
            throw new IllegalStateException("You must configure the 'discoveryAgent' property");
        }
        this.discoveryAgent.start();
        super.handleStart();
    }

    protected void handleStop(ServiceStopper stopper) throws Exception {
        for (NetworkBridge bridge : this.bridges.values()) {
            try {
                bridge.stop();
            }
            catch (Exception e) {
                stopper.onException(this, e);
            }
        }
        try {
            this.discoveryAgent.stop();
        }
        catch (Exception e) {
            stopper.onException(this, e);
        }
        super.handleStop(stopper);
    }

    protected NetworkBridge createBridge(Transport localTransport, Transport remoteTransport, final DiscoveryEvent event) {
        NetworkBridgeListener listener = new NetworkBridgeListener(){

            public void bridgeFailed() {
                if (!DiscoveryNetworkConnector.this.serviceSupport.isStopped()) {
                    try {
                        DiscoveryNetworkConnector.this.discoveryAgent.serviceFailed(event);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }

            public void onStart(NetworkBridge bridge) {
                DiscoveryNetworkConnector.this.registerNetworkBridgeMBean(bridge);
            }

            public void onStop(NetworkBridge bridge) {
                DiscoveryNetworkConnector.this.unregisterNetworkBridgeMBean(bridge);
            }
        };
        DemandForwardingBridge result = NetworkBridgeFactory.createBridge(this, localTransport, remoteTransport, listener);
        result.setBrokerService(this.getBrokerService());
        return this.configureBridge(result);
    }

    public String getName() {
        String name = super.getName();
        if (name == null) {
            name = this.discoveryAgent.toString();
            super.setName(name);
        }
        return name;
    }

    public String toString() {
        return "DiscoveryNetworkConnector:" + this.getName() + ":" + this.getBrokerService();
    }
}

