/*
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * "The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations under
 * the License.
 *
 * The Original Code is ICEpdf 4.1 open source software code, released
 * May 1st, 2009. The Initial Developer of the Original Code is ICEsoft
 * Technologies Canada, Corp. Portions created by ICEsoft are Copyright (C)
 * 2004-2010 ICEsoft Technologies Canada, Corp. All Rights Reserved.
 *
 * Contributor(s): _____________________.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"
 * License), in which case the provisions of the LGPL License are
 * applicable instead of those above. If you wish to allow use of your
 * version of this file only under the terms of the LGPL License and not to
 * allow others to use your version of this file under the MPL, indicate
 * your decision by deleting the provisions above and replace them with
 * the notice and other provisions required by the LGPL License. If you do
 * not delete the provisions above, a recipient may use your version of
 * this file under either the MPL or the LGPL License."
 *
 */
package org.icepdf.core.pobjects.fonts.ofont;

import java.util.Hashtable;

/**
 * put your documentation comment here
 */
public class Encoding implements org.icepdf.core.pobjects.fonts.Encoding {
    private char enc[];

    private Encoding(char e[]) {
        enc = e;
    }

    public char get(char i) {
        if (i >= 0 && i < 256) {
//            char c = enc[i];
            //            if (c >= 0)
            return enc[i];
        }
        return i;
    }

    static Encoding getStandard() {
        return new Encoding(se);
    }

    static Encoding getMacRoman() {
        return new Encoding(mre);
    }

    static Encoding getWinAnsi() {
        return new Encoding(wae);
    }

    public static Encoding getPDFDoc() {
        return new Encoding(pde);
    }

    static Encoding getSymbol() {
        return new Encoding(sym);
    }

    static Encoding getZapfDingBats() {
        return new Encoding(zap);
    }

    static int getUV(String glyphName) {
        Integer UV = h.get(glyphName);
        if (UV != null)
            return UV;
        if (glyphName.startsWith("G")) {
            try {
                String s = glyphName.substring(1);
                return Integer.parseInt(s);
            } catch (Exception ex) {
                //
            }
        }
        return -1;
    }

    static private Hashtable<String, Integer> h;
    static private char se[], mre[], wae[], pde[], sym[], zap[];

    // common symbol alaises,  displayable, followed by aliases
    // More symbols should be added here as mappings are needed.  
    public static int[][] symbolAlaises = {{183, 61623, 8226}, // bullets
            {169, 61667, 61651, 63721, 63193}, // copy rights
            {174, 61650, 61666, 61614}, // registered
            {80, 8364}  // euro
    };
    public static int[] registeredAlaises = {182};

    static {
        h = new Hashtable<String, Integer>(1046);
        h.put("A", 65);
        h.put("AE", 198);
        h.put("AEacute",508);
        h.put("AEsmall", 63462);
        h.put("Aacute", 193);
        h.put("Aacutesmall", 63457);
        h.put("Abreve", 258);
        h.put("Acircumflex", 194);
        h.put("Acircumflexsmall", 63458);
        h.put("Acute", 63177);
        h.put("Acutesmall", 63412);
        h.put("Adieresis", 196);
        h.put("Adieresissmall", 63460);
        h.put("Agrave", 192);
        h.put("Agravesmall", 63456);
        h.put("Alpha", 913);
        h.put("Alphatonos", 902);
        h.put("Amacron", 256);
        h.put("Aogonek", 260);
        h.put("Aring", 197);
        h.put("Aringacute", 506);
        h.put("Aringsmall", 63461);
        h.put("Asmall", 63329);
        h.put("Atilde", 195);
        h.put("Atildesmall", 63459);
        h.put("B", 66);
        h.put("Beta", 914);
        h.put("Brevesmall", 63220);
        h.put("Bsmall", 63330);
        h.put("C", 67);
        h.put("Cacute", 262);
        h.put("Caron", 63178);
        h.put("Caronsmall", 63221);
        h.put("Ccaron", 268);
        h.put("Ccedilla", 199);
        h.put("Ccedillasmall", 63463);
        h.put("Ccircumflex", 264);
        h.put("Cdotaccent", 266);
        h.put("Cedillasmall", 63416);
        h.put("Chi", 935);
        h.put("Circumflexsmall", 63222);
        h.put("Csmall", 63331);
        h.put("D", 68);
        h.put("Dcaron", 270);
        h.put("Dcroat", 272);
        h.put("Delta", 8710);
        h.put("Delta", 916);
        h.put("Dieresis", 63179);
        h.put("DieresisAcute", 63180);
        h.put("DieresisGrave", 63181);
        h.put("Dieresissmall", 63400);
        h.put("Dotaccentsmall", 63223);
        h.put("Dsmall", 63332);
        h.put("E", 69);
        h.put("Eacute", 201);
        h.put("Eacutesmall", 63465);
        h.put("Ebreve", 276);
        h.put("Ecaron", 282);
        h.put("Ecircumflex", 202);
        h.put("Ecircumflexsmall", 63466);
        h.put("Edieresis", 203);
        h.put("Edieresissmall", 63467);
        h.put("Edotaccent", 278);
        h.put("Egrave", 200);
        h.put("Egravesmall", 63464);
        h.put("Emacron", 274);
        h.put("Eng", 330);
        h.put("Eogonek", 280);
        h.put("Epsilon", 917);
        h.put("Epsilontonos", 904);
        h.put("Esmall", 63333);
        h.put("Eta", 919);
        h.put("Etatonos", 905);
        h.put("Eth", 208);
        h.put("Ethsmall", 63472);
        h.put("Euro", 8364);
        h.put("F", 70);
        h.put("Fsmall", 63334);
        h.put("G", 71);
        h.put("Gamma", 915);
        h.put("Gbreve", 286);
        h.put("Gcaron", 486);
        h.put("Gcircumflex", 284);
        h.put("Gcommaaccent", 290);
        h.put("Gdotaccent", 288);
        h.put("Grave", 63182);
        h.put("Gravesmall", 63328);
        h.put("Gsmall", 63335);
        h.put("H", 72);
        h.put("H18533", 9679);
        h.put("H18543", 9642);
        h.put("H18551", 9643);
        h.put("H22073", 9633);
        h.put("Hbar", 294);
        h.put("Hcircumflex", 292);
        h.put("Hsmall", 63336);
        h.put("Hungarumlaut", 63183);
        h.put("Hungarumlautsmall", 63224);
        h.put("I", 73);
        h.put("IJ", 306);
        h.put("Iacute", 205);
        h.put("Iacutesmall", 63469);
        h.put("Ibreve", 300);
        h.put("Icircumflex", 206);
        h.put("Icircumflexsmall", 63470);
        h.put("Idieresis", 207);
        h.put("Idieresissmall", 63471);
        h.put("Idotaccent", 304);
        h.put("Ifraktur", 8465);
        h.put("Igrave", 204);
        h.put("Igravesmall", 63468);
        h.put("Imacron", 298);
        h.put("Iogonek", 302);
        h.put("Iota", 921);
        h.put("Iotadieresis", 938);
        h.put("Iotatonos", 906);
        h.put("Ismall", 63337);
        h.put("Itilde", 296);
        h.put("J", 74);
        h.put("Jcircumflex", 308);
        h.put("Jsmall", 63338);
        h.put("K", 75);
        h.put("Kappa", 922);
        h.put("Kcommaaccent", 310);
        h.put("Ksmall", 63339);
        h.put("L", 76);
        h.put("LL", 63167);
        h.put("Lacute", 313);
        h.put("Lambda", 923);
        h.put("Lcaron", 317);
        h.put("Lcommaaccent", 315);
        h.put("Ldot", 319);
        h.put("Lslash", 321);
        h.put("Lslashsmall", 63225);
        h.put("Lsmall", 63340);
        h.put("M", 77);
        h.put("Macron", 63184);
        h.put("Macronsmall", 63407);
        h.put("Msmall", 63341);
        h.put("Mu", 924);
        h.put("N", 78);
        h.put("Nacute", 323);
        h.put("Ncaron", 327);
        h.put("Ncommaaccent", 325);
        h.put("Nsmall", 63342);
        h.put("Ntilde", 209);
        h.put("Ntildesmall", 63473);
        h.put("Nu", 925);
        h.put("O", 79);
        h.put("OE", 338);
        h.put("OEsmall", 63226);
        h.put("Oacute", 211);
        h.put("Oacutesmall", 63475);
        h.put("Obreve", 334);
        h.put("Ocircumflex", 212);
        h.put("Ocircumflexsmall", 63476);
        h.put("Odieresis", 214);
        h.put("Odieresissmall", 63478);
        h.put("Ogoneksmall", 63227);
        h.put("Ograve", 210);
        h.put("Ogravesmall", 63474);
        h.put("Ohorn", 416);
        h.put("Ohungarumlaut", 336);
        h.put("Omacron", 332);
        h.put("Omega", 8486);
        h.put("Omega", 937);
        h.put("Omegatonos", 911);
        h.put("Omicron", 927);
        h.put("Omicrontonos", 908);
        h.put("Oslash", 216);
        h.put("Oslashacute", 510);
        h.put("Oslashsmall", 63480);
        h.put("Osmall", 63343);
        h.put("Otilde", 213);
        h.put("Otildesmall", 63477);
        h.put("P", 80);
        h.put("Phi", 934);
        h.put("Pi", 928);
        h.put("Psi", 936);
        h.put("Psmall", 63344);
        h.put("Q", 81);
        h.put("Qsmall", 63345);
        h.put("R", 82);
        h.put("Racute", 340);
        h.put("Rcaron", 344);
        h.put("Rcommaaccent", 342);
        h.put("Rfraktur", 8476);
        h.put("Rho", 929);
        h.put("Ringsmall", 63228);
        h.put("Rsmall", 63346);
        h.put("S", 83);
        h.put("SF010000", 9484);
        h.put("SF020000", 9492);
        h.put("SF030000", 9488);
        h.put("SF040000", 9496);
        h.put("SF050000", 9532);
        h.put("SF060000", 9516);
        h.put("SF070000", 9524);
        h.put("SF080000", 9500);
        h.put("SF090000", 9508);
        h.put("SF100000", 9472);
        h.put("SF110000", 9474);
        h.put("SF190000", 9569);
        h.put("SF200000", 9570);
        h.put("SF210000", 9558);
        h.put("SF220000", 9557);
        h.put("SF230000", 9571);
        h.put("SF240000", 9553);
        h.put("SF250000", 9559);
        h.put("SF260000", 9565);
        h.put("SF270000", 9564);
        h.put("SF280000", 9563);
        h.put("SF360000", 9566);
        h.put("SF370000", 9567);
        h.put("SF380000", 9562);
        h.put("SF390000", 9556);
        h.put("SF400000", 9577);
        h.put("SF410000", 9574);
        h.put("SF420000", 9568);
        h.put("SF430000", 9552);
        h.put("SF440000", 9580);
        h.put("SF450000", 9575);
        h.put("SF460000", 9576);
        h.put("SF470000", 9572);
        h.put("SF480000", 9573);
        h.put("SF490000", 9561);
        h.put("SF500000", 9560);
        h.put("SF510000", 9554);
        h.put("SF520000", 9555);
        h.put("SF530000", 9579);
        h.put("SF540000", 9578);
        h.put("Sacute", 346);
        h.put("Scaron", 352);
        h.put("Scaronsmall", 63229);
        h.put("Scedilla", 350);
        h.put("Scedilla", 63169);
        h.put("Scircumflex", 348);
        h.put("Scommaaccent", 536);
        h.put("Sigma", 931);
        h.put("Ssmall", 63347);
        h.put("T", 84);
        h.put("Tau", 932);
        h.put("Tbar", 358);
        h.put("Tcaron", 356);
        h.put("Tcommaaccent", 354);
        h.put("Tcommaaccent", 538);
        h.put("Theta", 920);
        h.put("Thorn", 222);
        h.put("Thornsmall", 63486);
        h.put("Tildesmall", 63230);
        h.put("Tsmall", 63348);
        h.put("U", 85);
        h.put("Uacute", 218);
        h.put("Uacutesmall", 63482);
        h.put("Ubreve", 364);
        h.put("Ucircumflex", 219);
        h.put("Ucircumflexsmall", 63483);
        h.put("Udieresis", 220);
        h.put("Udieresissmall", 63484);
        h.put("Ugrave", 217);
        h.put("Ugravesmall", 63481);
        h.put("Uhorn", 431);
        h.put("Uhungarumlaut", 368);
        h.put("Umacron", 362);
        h.put("Uogonek", 370);
        h.put("Upsilon", 933);
        h.put("Upsilon1", 978);
        h.put("Upsilondieresis", 939);
        h.put("Upsilontonos", 910);
        h.put("Uring", 366);
        h.put("Usmall", 63349);
        h.put("Utilde", 360);
        h.put("V", 86);
        h.put("Vsmall", 63350);
        h.put("W", 87);
        h.put("Wacute", 7810);
        h.put("Wcircumflex", 372);
        h.put("Wdieresis", 7812);
        h.put("Wgrave", 7808);
        h.put("Wsmall", 63351);
        h.put("X", 88);
        h.put("Xi", 926);
        h.put("Xsmall", 63352);
        h.put("Y", 89);
        h.put("Yacute", 221);
        h.put("Yacutesmall", 63485);
        h.put("Ycircumflex", 374);
        h.put("Ydieresis", 376);
        h.put("Ydieresissmall", 63487);
        h.put("Ygrave", 7922);
        h.put("Ysmall", 63353);
        h.put("Z", 90);
        h.put("Zacute", 377);
        h.put("Zcaron", 381);
        h.put("Zcaronsmall", 63231);
        h.put("Zdotaccent", 379);
        h.put("Zeta", 918);
        h.put("Zsmall", 63354);
        h.put("a", 97);
        h.put("aacute", 225);
        h.put("abreve", 259);
        h.put("acircumflex", 226);
        h.put("acute", 180);
        h.put("acutecomb", 769);
        h.put("adieresis", 228);
        h.put("ae", 230);
        h.put("aeacute", 509);
        h.put("afii00208", 8213);
        h.put("afii10017", 1040);
        h.put("afii10018", 1041);
        h.put("afii10019", 1042);
        h.put("afii10020", 1043);
        h.put("afii10021", 1044);
        h.put("afii10022", 1045);
        h.put("afii10023", 1025);
        h.put("afii10024", 1046);
        h.put("afii10025", 1047);
        h.put("afii10026", 1048);
        h.put("afii10027", 1049);
        h.put("afii10028", 1050);
        h.put("afii10029", 1051);
        h.put("afii10030", 1052);
        h.put("afii10031", 1053);
        h.put("afii10032", 1054);
        h.put("afii10033", 1055);
        h.put("afii10034", 1056);
        h.put("afii10035", 1057);
        h.put("afii10036", 1058);
        h.put("afii10037", 1059);
        h.put("afii10038", 1060);
        h.put("afii10039", 1061);
        h.put("afii10040", 1062);
        h.put("afii10041", 1063);
        h.put("afii10042", 1064);
        h.put("afii10043", 1065);
        h.put("afii10044", 1066);
        h.put("afii10045", 1067);
        h.put("afii10046", 1068);
        h.put("afii10047", 1069);
        h.put("afii10048", 1070);
        h.put("afii10049", 1071);
        h.put("afii10050", 1168);
        h.put("afii10051", 1026);
        h.put("afii10052", 1027);
        h.put("afii10053", 1028);
        h.put("afii10054", 1029);
        h.put("afii10055", 1030);
        h.put("afii10056", 1031);
        h.put("afii10057", 1032);
        h.put("afii10058", 1033);
        h.put("afii10059", 1034);
        h.put("afii10060", 1035);
        h.put("afii10061", 1036);
        h.put("afii10062", 1038);
        h.put("afii10063", 63172);
        h.put("afii10064", 63173);
        h.put("afii10065", 1072);
        h.put("afii10066", 1073);
        h.put("afii10067", 1074);
        h.put("afii10068", 1075);
        h.put("afii10069", 1076);
        h.put("afii10070", 1077);
        h.put("afii10071", 1105);
        h.put("afii10072", 1078);
        h.put("afii10073", 1079);
        h.put("afii10074", 1080);
        h.put("afii10075", 1081);
        h.put("afii10076", 1082);
        h.put("afii10077", 1083);
        h.put("afii10078", 1084);
        h.put("afii10079", 1085);
        h.put("afii10080", 1086);
        h.put("afii10081", 1087);
        h.put("afii10082", 1088);
        h.put("afii10083", 1089);
        h.put("afii10084", 1090);
        h.put("afii10085", 1091);
        h.put("afii10086", 1092);
        h.put("afii10087", 1093);
        h.put("afii10088", 1094);
        h.put("afii10089", 1095);
        h.put("afii10090", 1096);
        h.put("afii10091", 1097);
        h.put("afii10092", 1098);
        h.put("afii10093", 1099);
        h.put("afii10094", 1100);
        h.put("afii10095", 1101);
        h.put("afii10096", 1102);
        h.put("afii10097", 1103);
        h.put("afii10098", 1169);
        h.put("afii10099", 1106);
        h.put("afii10100", 1107);
        h.put("afii10101", 1108);
        h.put("afii10102", 1109);
        h.put("afii10103", 1110);
        h.put("afii10104", 1111);
        h.put("afii10105", 1112);
        h.put("afii10106", 1113);
        h.put("afii10107", 1114);
        h.put("afii10108", 1115);
        h.put("afii10109", 1116);
        h.put("afii10110", 1118);
        h.put("afii10145", 1039);
        h.put("afii10146", 1122);
        h.put("afii10147", 1138);
        h.put("afii10148", 1140);
        h.put("afii10192", 63174);
        h.put("afii10193", 1119);
        h.put("afii10194", 1123);
        h.put("afii10195", 1139);
        h.put("afii10196", 1141);
        h.put("afii10831", 63175);
        h.put("afii10832", 63176);
        h.put("afii10846", 1241);
        h.put("afii299", 8206);
        h.put("afii300", 8207);
        h.put("afii301", 8205);
        h.put("afii57381", 1642);
        h.put("afii57388", 1548);
        h.put("afii57392", 1632);
        h.put("afii57393", 1633);
        h.put("afii57394", 1634);
        h.put("afii57395", 1635);
        h.put("afii57396", 1636);
        h.put("afii57397", 1637);
        h.put("afii57398", 1638);
        h.put("afii57399", 1639);
        h.put("afii57400", 1640);
        h.put("afii57401", 1641);
        h.put("afii57403", 1563);
        h.put("afii57407", 1567);
        h.put("afii57409", 1569);
        h.put("afii57410", 1570);
        h.put("afii57411", 1571);
        h.put("afii57412", 1572);
        h.put("afii57413", 1573);
        h.put("afii57414", 1574);
        h.put("afii57415", 1575);
        h.put("afii57416", 1576);
        h.put("afii57417", 1577);
        h.put("afii57418", 1578);
        h.put("afii57419", 1579);
        h.put("afii57420", 1580);
        h.put("afii57421", 1581);
        h.put("afii57422", 1582);
        h.put("afii57423", 1583);
        h.put("afii57424", 1584);
        h.put("afii57425", 1585);
        h.put("afii57426", 1586);
        h.put("afii57427", 1587);
        h.put("afii57428", 1588);
        h.put("afii57429", 1589);
        h.put("afii57430", 1590);
        h.put("afii57431", 1591);
        h.put("afii57432", 1592);
        h.put("afii57433", 1593);
        h.put("afii57434", 1594);
        h.put("afii57440", 1600);
        h.put("afii57441", 1601);
        h.put("afii57442", 1602);
        h.put("afii57443", 1603);
        h.put("afii57444", 1604);
        h.put("afii57445", 1605);
        h.put("afii57446", 1606);
        h.put("afii57448", 1608);
        h.put("afii57449", 1609);
        h.put("afii57450", 1610);
        h.put("afii57451", 1611);
        h.put("afii57452", 1612);
        h.put("afii57453", 1613);
        h.put("afii57454", 1614);
        h.put("afii57455", 1615);
        h.put("afii57456", 1616);
        h.put("afii57457", 1617);
        h.put("afii57458", 1618);
        h.put("afii57470", 1607);
        h.put("afii57505", 1700);
        h.put("afii57506", 1662);
        h.put("afii57507", 1670);
        h.put("afii57508", 1688);
        h.put("afii57509", 1711);
        h.put("afii57511", 1657);
        h.put("afii57512", 1672);
        h.put("afii57513", 1681);
        h.put("afii57514", 1722);
        h.put("afii57519", 1746);
        h.put("afii57534", 1749);
        h.put("afii57636", 8362);
        h.put("afii57645", 1470);
        h.put("afii57658", 1475);
        h.put("afii57664", 1488);
        h.put("afii57665", 1489);
        h.put("afii57666", 1490);
        h.put("afii57667", 1491);
        h.put("afii57668", 1492);
        h.put("afii57669", 1493);
        h.put("afii57670", 1494);
        h.put("afii57671", 1495);
        h.put("afii57672", 1496);
        h.put("afii57673", 1497);
        h.put("afii57674", 1498);
        h.put("afii57675", 1499);
        h.put("afii57676", 1500);
        h.put("afii57677", 1501);
        h.put("afii57678", 1502);
        h.put("afii57679", 1503);
        h.put("afii57680", 1504);
        h.put("afii57681", 1505);
        h.put("afii57682", 1506);
        h.put("afii57683", 1507);
        h.put("afii57684", 1508);
        h.put("afii57685", 1509);
        h.put("afii57686", 1510);
        h.put("afii57687", 1511);
        h.put("afii57688", 1512);
        h.put("afii57689", 1513);
        h.put("afii57690", 1514);
        h.put("afii57694", 64298);
        h.put("afii57695", 64299);
        h.put("afii57700", 64331);
        h.put("afii57705", 64287);
        h.put("afii57716", 1520);
        h.put("afii57717", 1521);
        h.put("afii57718", 1522);
        h.put("afii57723", 64309);
        h.put("afii57793", 1460);
        h.put("afii57794", 1461);
        h.put("afii57795", 1462);
        h.put("afii57796", 1467);
        h.put("afii57797", 1464);
        h.put("afii57798", 1463);
        h.put("afii57799", 1456);
        h.put("afii57800", 1458);
        h.put("afii57801", 1457);
        h.put("afii57802", 1459);
        h.put("afii57803", 1474);
        h.put("afii57804", 1473);
        h.put("afii57806", 1465);
        h.put("afii57807", 1468);
        h.put("afii57839", 1469);
        h.put("afii57841", 1471);
        h.put("afii57842", 1472);
        h.put("afii57929", 700);
        h.put("afii61248", 8453);
        h.put("afii61289", 8467);
        h.put("afii61352", 8470);
        h.put("afii61573", 8236);
        h.put("afii61574", 8237);
        h.put("afii61575", 8238);
        h.put("afii61664", 8204);
        h.put("afii63167", 1645);
        h.put("afii64937", 701);
        h.put("agrave", 224);
        h.put("aleph", 8501);
        h.put("alpha", 945);
        h.put("alphatonos", 940);
        h.put("amacron", 257);
        h.put("ampersand", 38);
        h.put("ampersandsmall", 63270);
        h.put("angle", 8736);
        h.put("angleleft", 9001);
        h.put("angleright", 9002);
        h.put("anoteleia", 903);
        h.put("aogonek", 261);
        h.put("approxequal", 8776);
        h.put("aring", 229);
        h.put("aringacute", 507);
        h.put("arrowboth", 8596);
        h.put("arrowdblboth", 8660);
        h.put("arrowdbldown", 8659);
        h.put("arrowdblleft", 8656);
        h.put("arrowdblright", 8658);
        h.put("arrowdblup", 8657);
        h.put("arrowdown", 8595);
        h.put("arrowhorizex", 63719);
        h.put("arrowleft", 8592);
        h.put("arrowright", 8594);
        h.put("arrowup", 8593);
        h.put("arrowupdn", 8597);
        h.put("arrowupdnbse", 8616);
        h.put("arrowvertex", 63718);
        h.put("asciicircum", 94);
        h.put("asciitilde", 126);
        h.put("asterisk", 42);
        h.put("asteriskmath", 8727);
        h.put("asuperior", 63209);
        h.put("at", 64);
        h.put("atilde", 227);
        h.put("b", 98);
        h.put("backslash", 92);
        h.put("bar", 124);
        h.put("beta", 946);
        h.put("block", 9608);
        h.put("braceex", 63732);
        h.put("braceleft", 123);
        h.put("braceleftbt", 63731);
        h.put("braceleftmid", 63730);
        h.put("bracelefttp", 63729);
        h.put("braceright", 125);
        h.put("bracerightbt", 63742);
        h.put("bracerightmid", 63741);
        h.put("bracerighttp", 63740);
        h.put("bracketleft", 91);
        h.put("bracketleftbt", 63728);
        h.put("bracketleftex", 63727);
        h.put("bracketlefttp", 63726);
        h.put("bracketright", 93);
        h.put("bracketrightbt", 63739);
        h.put("bracketrightex", 63738);
        h.put("bracketrighttp", 63737);
        h.put("breve", 728);
        h.put("brokenbar", 166);
        h.put("bsuperior", 63210);
        h.put("bullet", 8226);
        h.put("c", 99);
        h.put("cacute", 263);
        h.put("caron", 711);
        h.put("carriagereturn", 8629);
        h.put("ccaron", 269);
        h.put("ccedilla", 231);
        h.put("ccircumflex", 265);
        h.put("cdotaccent", 267);
        h.put("cedilla", 184);
        h.put("cent", 162);
        h.put("centinferior", 63199);
        h.put("centoldstyle", 63394);
        h.put("centsuperior", 63200);
        h.put("chi", 967);
        h.put("circle", 9675);
        h.put("circlemultiply", 8855);
        h.put("circleplus", 8853);
        h.put("circumflex", 710);
        h.put("club", 9827);
        h.put("colon", 58);
        h.put("colonmonetary", 8353);
        h.put("comma", 44);
        h.put("commaaccent", 63171);
        h.put("commainferior", 63201);
        h.put("commasuperior", 63202);
        h.put("congruent", 8773);
        h.put("copyright", 169);
        h.put("copyrightsans", 63721);
        h.put("copyrightserif", 63193);
        h.put("currency", 164);
        h.put("cyrBreve", 63185);
        h.put("cyrFlex", 63186);
        h.put("cyrbreve", 63188);
        h.put("cyrflex", 63189);
        h.put("d", 100);
        h.put("dagger", 8224);
        h.put("daggerdbl", 8225);
        h.put("dblGrave", 63187);
        h.put("dblgrave", 63190);
        h.put("dcaron", 271);
        h.put("dcroat", 273);
        h.put("degree", 176);
        h.put("delta", 948);
        h.put("diamond", 9830);
        h.put("dieresis", 168);
        h.put("dieresisacute", 63191);
        h.put("dieresisgrave", 63192);
        h.put("dieresistonos", 901);
        h.put("divide", 247);
        h.put("dkshade", 9619);
        h.put("dnblock", 9604);
        h.put("dollar", 36);
        h.put("dollarinferior", 63203);
        h.put("dollaroldstyle", 63268);
        h.put("dollarsuperior", 63204);
        h.put("dong", 8363);
        h.put("dotaccent", 729);
        h.put("dotbelowcomb", 803);
        h.put("dotlessi", 305);
        h.put("dotlessj", 63166);
        h.put("dotmath", 8901);
        h.put("dsuperior", 63211);
        h.put("e", 101);
        h.put("eacute", 233);
        h.put("ebreve", 277);
        h.put("ecaron", 283);
        h.put("ecircumflex", 234);
        h.put("edieresis", 235);
        h.put("edotaccent", 279);
        h.put("egrave", 232);
        h.put("eight", 56);
        h.put("eightinferior", 8328);
        h.put("eightoldstyle", 63288);
        h.put("eightsuperior", 8312);
        h.put("element", 8712);
        h.put("ellipsis", 8230);
        h.put("emacron", 275);
        h.put("emdash", 8212);
        h.put("emptyset", 8709);
        h.put("endash", 8211);
        h.put("eng", 331);
        h.put("eogonek", 281);
        h.put("epsilon", 949);
        h.put("epsilontonos", 941);
        h.put("equal", 61);
        h.put("equivalence", 8801);
        h.put("estimated", 8494);
        h.put("esuperior", 63212);
        h.put("eta", 951);
        h.put("etatonos", 942);
        h.put("eth", 240);
        h.put("exclam", 33);
        h.put("exclamdbl", 8252);
        h.put("exclamdown", 161);
        h.put("exclamdownsmall", 63393);
        h.put("exclamsmall", 63265);
        h.put("existential", 8707);
        h.put("f", 102);
        h.put("female", 9792);
        h.put("ff", 64256);
        h.put("ffi", 64259);
        h.put("ffl", 64260);
        h.put("fi", 64257);
        h.put("figuredash", 8210);
        h.put("filledbox", 9632);
        h.put("filledrect", 9644);
        h.put("five", 53);
        h.put("fiveeighths", 8541);
        h.put("fiveinferior", 8325);
        h.put("fiveoldstyle", 63285);
        h.put("fivesuperior", 8309);
        h.put("fl", 64258);
        h.put("florin", 402);
        h.put("four", 52);
        h.put("fourinferior", 8324);
        h.put("fouroldstyle", 63284);
        h.put("foursuperior", 8308);
        h.put("fraction", 8260);
        h.put("fraction", 8725);
        h.put("franc", 8355);
        h.put("g", 103);
        h.put("gamma", 947);
        h.put("gbreve", 287);
        h.put("gcaron", 487);
        h.put("gcircumflex", 285);
        h.put("gcommaaccent", 291);
        h.put("gdotaccent", 289);
        h.put("germandbls", 223);
        h.put("gradient", 8711);
        h.put("grave", 96);
        h.put("gravecomb", 768);
        h.put("greater", 62);
        h.put("greaterequal", 8805);
        h.put("guillemotleft", 171);
        h.put("guillemotright", 187);
        h.put("guilsinglleft", 8249);
        h.put("guilsinglright", 8250);
        h.put("h", 104);
        h.put("hbar", 295);
        h.put("hcircumflex", 293);
        h.put("heart", 9829);
        h.put("hookabovecomb", 777);
        h.put("house", 8962);
        h.put("hungarumlaut", 733);
        h.put("hyphen", 45);
        //h.put("hyphen",173);
        h.put("hypheninferior", 63205);
        h.put("hyphensuperior", 63206);
        h.put("i", 105);
        h.put("iacute", 237);
        h.put("ibreve", 301);
        h.put("icircumflex", 238);
        h.put("idieresis", 239);
        h.put("igrave", 236);
        h.put("ij", 307);
        h.put("imacron", 299);
        h.put("infinity", 8734);
        h.put("integral", 8747);
        h.put("integralbt", 8993);
        h.put("integralex", 63733);
        h.put("integraltp", 8992);
        h.put("intersection", 8745);
        h.put("invbullet", 9688);
        h.put("invcircle", 9689);
        h.put("invsmileface", 9787);
        h.put("iogonek", 303);
        h.put("iota", 953);
        h.put("iotadieresis", 970);
        h.put("iotadieresistonos", 912);
        h.put("iotatonos", 943);
        h.put("isuperior", 63213);
        h.put("itilde", 297);
        h.put("j", 106);
        h.put("jcircumflex", 309);
        h.put("k", 107);
        h.put("kappa", 954);
        h.put("kcommaaccent", 311);
        h.put("kgreenlandic", 312);
        h.put("l", 108);
        h.put("lacute", 314);
        h.put("lambda", 955);
        h.put("lcaron", 318);
        h.put("lcommaaccent", 316);
        h.put("ldot", 320);
        h.put("less", 60);
        h.put("lessequal", 8804);
        h.put("lfblock", 9612);
        h.put("lira", 8356);
        h.put("ll", 63168);
        h.put("logicaland", 8743);
        h.put("logicalnot", 172);
        h.put("logicalor", 8744);
        h.put("longs", 383);
        h.put("lozenge", 9674);
        h.put("lslash", 322);
        h.put("lsuperior", 63214);
        h.put("ltshade", 9617);
        h.put("m", 109);
        h.put("macron", 175);
        //h.put("macron",713);
        h.put("male", 9794);
        h.put("minus", 8722);
        h.put("minute", 8242);
        h.put("msuperior", 63215);
        h.put("mu", 181);
        //h.put("mu",956);
        h.put("multiply", 215);
        h.put("musicalnote", 9834);
        h.put("musicalnotedbl", 9835);
        h.put("n", 110);
        h.put("nacute", 324);
        h.put("napostrophe", 329);
        h.put("ncaron", 328);
        h.put("ncommaaccent", 326);
        h.put("nine", 57);
        h.put("nineinferior", 8329);
        h.put("nineoldstyle", 63289);
        h.put("ninesuperior", 8313);
        h.put("notelement", 8713);
        h.put("notequal", 8800);
        h.put("notsubset", 8836);
        h.put("nsuperior", 8319);
        h.put("ntilde", 241);
        h.put("nu", 957);
        h.put("numbersign", 35);
        h.put("o", 111);
        h.put("oacute", 243);
        h.put("obreve", 335);
        h.put("ocircumflex", 244);
        h.put("odieresis", 246);
        h.put("oe", 339);
        h.put("ogonek", 731);
        h.put("ograve", 242);
        h.put("ohorn", 417);
        h.put("ohungarumlaut", 337);
        h.put("omacron", 333);
        h.put("omega", 969);
        h.put("omega1", 982);
        h.put("omegatonos", 974);
        h.put("omicron", 959);
        h.put("omicrontonos", 972);
        h.put("one", 49);
        h.put("onedotenleader", 8228);
        h.put("oneeighth", 8539);
        h.put("onefitted", 63196);
        h.put("onehalf", 189);
        h.put("oneinferior", 8321);
        h.put("oneoldstyle", 63281);
        h.put("onequarter", 188);
        h.put("onesuperior", 185);
        h.put("onethird", 8531);
        h.put("openbullet", 9702);
        h.put("ordfeminine", 170);
        h.put("ordmasculine", 186);
        h.put("orthogonal", 8735);
        h.put("oslash", 248);
        h.put("oslashacute", 511);
        h.put("osuperior", 63216);
        h.put("otilde", 245);
        h.put("p", 112);
        h.put("paragraph", 182);
        h.put("parenleft", 40);
        h.put("parenleftbt", 63725);
        h.put("parenleftex", 63724);
        h.put("parenleftinferior", 8333);
        h.put("parenleftsuperior", 8317);
        h.put("parenlefttp", 63723);
        h.put("parenright", 41);
        h.put("parenrightbt", 63736);
        h.put("parenrightex", 63735);
        h.put("parenrightinferior", 8334);
        h.put("parenrightsuperior", 8318);
        h.put("parenrighttp", 63734);
        h.put("partialdiff", 8706);
        h.put("percent", 37);
        h.put("period", 46);
        h.put("periodcentered", 183);
        h.put("periodcentered", 8729);
        h.put("periodinferior", 63207);
        h.put("periodsuperior", 63208);
        h.put("perpendicular", 8869);
        h.put("perthousand", 8240);
        h.put("peseta", 8359);
        h.put("phi", 966);
        h.put("phi1", 981);
        h.put("pi", 960);
        h.put("plus", 43);
        h.put("plusminus", 177);
        h.put("prescription", 8478);
        h.put("product", 8719);
        h.put("propersubset", 8834);
        h.put("propersuperset", 8835);
        h.put("proportional", 8733);
        h.put("psi", 968);
        h.put("q", 113);
        h.put("question", 63);
        h.put("questiondown", 191);
        h.put("questiondownsmall", 63423);
        h.put("questionsmall", 63295);
        h.put("quotedbl", 34);
        h.put("quotedblbase", 8222);
        h.put("quotedblleft", 8220);
        h.put("quotedblright", 8221);
        h.put("quoteleft", 8216);
        h.put("quotereversed", 8219);
        h.put("quoteright", 8217);
        h.put("quotesinglbase", 8218);
        h.put("quotesingle", 39);
        h.put("r", 114);
        h.put("racute", 341);
        h.put("radical", 8730);
        h.put("radicalex", 63717);
        h.put("rcaron", 345);
        h.put("rcommaaccent", 343);
        h.put("reflexsubset", 8838);
        h.put("reflexsuperset", 8839);
        h.put("registered", 174);
        h.put("registersans", 63720);
        h.put("registerserif", 63194);
        h.put("revlogicalnot", 8976);
        h.put("rho", 961);
        h.put("ring", 730);
        h.put("rsuperior", 63217);
        h.put("rtblock", 9616);
        h.put("rupiah", 63197);
        h.put("s", 115);
        h.put("sacute", 347);
        h.put("scaron", 353);
        h.put("scedilla", 351);
        h.put("scedilla", 63170);
        h.put("scircumflex", 349);
        h.put("scommaaccent", 537);
        h.put("second", 8243);
        h.put("section", 167);
        h.put("semicolon", 59);
        h.put("seven", 55);
        h.put("seveneighths", 8542);
        h.put("seveninferior", 8327);
        h.put("sevenoldstyle", 63287);
        h.put("sevensuperior", 8311);
        h.put("shade", 9618);
        h.put("sigma", 963);
        h.put("sigma1", 962);
        h.put("similar", 8764);
        h.put("six", 54);
        h.put("sixinferior", 8326);
        h.put("sixoldstyle", 63286);
        h.put("sixsuperior", 8310);
        h.put("slash", 47);
        h.put("smileface", 9786);
        h.put("space", 32);
        //h.put("space",160);
        h.put("spade", 9824);
        h.put("ssuperior", 63218);
        h.put("sterling", 163);
        h.put("suchthat", 8715);
        h.put("summation", 8721);
        h.put("sun", 9788);
        h.put("t", 116);
        h.put("tau", 964);
        h.put("tbar", 359);
        h.put("tcaron", 357);
        h.put("tcommaaccent", 355);
        h.put("tcommaaccent", 539);
        h.put("therefore", 8756);
        h.put("theta", 952);
        h.put("theta1", 977);
        h.put("thorn", 254);
        h.put("three", 51);
        h.put("threeeighths", 8540);
        h.put("threeinferior", 8323);
        h.put("threeoldstyle", 63283);
        h.put("threequarters", 190);
        h.put("threequartersemdash", 63198);
        h.put("threesuperior", 179);
        h.put("tilde", 732);
        h.put("tildecomb", 771);
        h.put("tonos", 900);
        h.put("trademark", 8482);
        h.put("trademarksans", 63722);
        h.put("trademarkserif", 63195);
        h.put("triagdn", 9660);
        h.put("triaglf", 9668);
        h.put("triagrt", 9658);
        h.put("triagup", 9650);
        h.put("tsuperior", 63219);
        h.put("two", 50);
        h.put("twodotenleader", 8229);
        h.put("twoinferior", 8322);
        h.put("twooldstyle", 63282);
        h.put("twosuperior", 178);
        h.put("twothirds", 8532);
        h.put("u", 117);
        h.put("uacute", 250);
        h.put("ubreve", 365);
        h.put("ucircumflex", 251);
        h.put("udieresis", 252);
        h.put("ugrave", 249);
        h.put("uhorn", 432);
        h.put("uhungarumlaut", 369);
        h.put("umacron", 363);
        h.put("underscore", 95);
        h.put("underscoredbl", 8215);
        h.put("union", 8746);
        h.put("universal", 8704);
        h.put("uogonek", 371);
        h.put("upblock", 9600);
        h.put("upsilon", 965);
        h.put("upsilondieresis", 971);
        h.put("upsilondieresistonos", 944);
        h.put("upsilontonos", 973);
        h.put("uring", 367);
        h.put("utilde", 361);
        h.put("v", 118);
        h.put("w", 119);
        h.put("wacute", 7811);
        h.put("wcircumflex", 373);
        h.put("wdieresis", 7813);
        h.put("weierstrass", 8472);
        h.put("wgrave", 7809);
        h.put("x", 120);
        h.put("xi", 958);
        h.put("y", 121);
        h.put("yacute", 253);
        h.put("ycircumflex", 375);
        h.put("ydieresis", 255);
        h.put("yen", 165);
        h.put("ygrave", 7923);
        h.put("z", 122);
        h.put("zacute", 378);
        h.put("zcaron", 382);
        h.put("zdotaccent", 380);
        h.put("zero", 48);
        h.put("zeroinferior", 8320);
        h.put("zerooldstyle", 63280);
        h.put("zerosuperior", 8304);
        h.put("zeta", 950);
        h.put("a1", 9985);
        h.put("a2", 9986);
        h.put("a202", 9987);
        h.put("a3", 9988);
        h.put("a4", 9742);
        h.put("a5", 9990);
        h.put("a119", 9991);
        h.put("a118", 9992);
        h.put("a117", 9993);
        h.put("a11", 9755);
        h.put("a12", 9758);
        h.put("a13", 9996);
        h.put("a14", 9997);
        h.put("a15", 9998);
        h.put("a16", 9999);
        h.put("a105", 10000);
        h.put("a17", 10001);
        h.put("a18", 10002);
        h.put("a19", 10003);
        h.put("a20", 10004);
        h.put("a21", 10005);
        h.put("a22", 10006);
        h.put("a23", 10007);
        h.put("a24", 10008);
        h.put("a25", 10009);
        h.put("a26", 10010);
        h.put("a27", 10011);
        h.put("a28", 10012);
        h.put("a6", 10013);
        h.put("a7", 10014);
        h.put("a8", 10015);
        h.put("a9", 10016);
        h.put("a10", 10017);
        h.put("a29", 10018);
        h.put("a30", 10019);
        h.put("a31", 10020);
        h.put("a32", 10021);
        h.put("a33", 10022);
        h.put("a34", 10023);
        h.put("a35", 9733);
        h.put("a36", 10025);
        h.put("a37", 10026);
        h.put("a38", 10027);
        h.put("a39", 10028);
        h.put("a40", 10029);
        h.put("a41", 10030);
        h.put("a42", 10031);
        h.put("a43", 10032);
        h.put("a44", 10033);
        h.put("a45", 10034);
        h.put("a46", 10035);
        h.put("a47", 10036);
        h.put("a48", 10037);
        h.put("a49", 10038);
        h.put("a50", 10039);
        h.put("a51", 10040);
        h.put("a52", 10041);
        h.put("a53", 10042);
        h.put("a54", 10043);
        h.put("a55", 10044);
        h.put("a56", 10045);
        h.put("a57", 10046);
        h.put("a58", 10047);
        h.put("a59", 10048);
        h.put("a60", 10049);
        h.put("a61", 10050);
        h.put("a62", 10051);
        h.put("a63", 10052);
        h.put("a64", 10053);
        h.put("a65", 10054);
        h.put("a66", 10055);
        h.put("a67", 10056);
        h.put("a68", 10057);
        h.put("a69", 10058);
        h.put("a70", 10059);
        h.put("a71", 9679);
        h.put("a72", 10061);
        h.put("a73", 9632);
        h.put("a74", 10063);
        h.put("a203", 10064);
        h.put("a75", 10065);
        h.put("a204", 10066);
        h.put("a76", 9650);
        h.put("a77", 9660);
        h.put("a78", 9670);
        h.put("a79", 10070);
        h.put("a81", 9687);
        h.put("a82", 10072);
        h.put("a83", 10073);
        h.put("a84", 10074);
        h.put("a97", 10075);
        h.put("a98", 10076);
        h.put("a99", 10077);
        h.put("a100", 10078);
        h.put("a89", 63703);
        h.put("a90", 63704);
        h.put("a93", 63705);
        h.put("a94", 63706);
        h.put("a91", 63707);
        h.put("a92", 63708);
        h.put("a205", 63709);
        h.put("a85", 63710);
        h.put("a206", 63711);
        h.put("a86", 63712);
        h.put("a87", 63713);
        h.put("a88", 63714);
        h.put("a95", 63715);
        h.put("a96", 63716);
        h.put("a101", 10081);
        h.put("a102", 10082);
        h.put("a103", 10083);
        h.put("a104", 10084);
        h.put("a106", 10085);
        h.put("a107", 10086);
        h.put("a108", 10087);
        h.put("a112", 9827);
        h.put("a111", 9830);
        h.put("a110", 9829);
        h.put("a109", 9824);
        h.put("a120", 9312);
        h.put("a121", 9313);
        h.put("a122", 9314);
        h.put("a123", 9315);
        h.put("a124", 9316);
        h.put("a125", 9317);
        h.put("a126", 9318);
        h.put("a127", 9319);
        h.put("a128", 9320);
        h.put("a129", 9321);
        h.put("a130", 10102);
        h.put("a131", 10103);
        h.put("a132", 10104);
        h.put("a133", 10105);
        h.put("a134", 10106);
        h.put("a135", 10107);
        h.put("a136", 10108);
        h.put("a137", 10109);
        h.put("a138", 10110);
        h.put("a139", 10111);
        h.put("a140", 10112);
        h.put("a141", 10113);
        h.put("a142", 10114);
        h.put("a143", 10115);
        h.put("a144", 10116);
        h.put("a145", 10117);
        h.put("a146", 10118);
        h.put("a147", 10119);
        h.put("a148", 10120);
        h.put("a149", 10121);
        h.put("a150", 10122);
        h.put("a151", 10123);
        h.put("a152", 10124);
        h.put("a153", 10125);
        h.put("a154", 10126);
        h.put("a155", 10127);
        h.put("a156", 10128);
        h.put("a157", 10129);
        h.put("a158", 10130);
        h.put("a159", 10131);
        h.put("a160", 10132);
        h.put("a161", 8594);
        h.put("a163", 8596);
        h.put("a164", 8597);
        h.put("a196", 10136);
        h.put("a165", 10137);
        h.put("a192", 10138);
        h.put("a166", 10139);
        h.put("a167", 10140);
        h.put("a168", 10141);
        h.put("a169", 10142);
        h.put("a170", 10143);
        h.put("a171", 10144);
        h.put("a172", 10145);
        h.put("a173", 10146);
        h.put("a162", 10147);
        h.put("a174", 10148);
        h.put("a175", 10149);
        h.put("a176", 10150);
        h.put("a177", 10151);
        h.put("a178", 10152);
        h.put("a179", 10153);
        h.put("a193", 10154);
        h.put("a180", 10155);
        h.put("a199", 10156);
        h.put("a181", 10157);
        h.put("a200", 10158);
        h.put("a182", 10159);
        h.put("a201", 10161);
        h.put("a183", 10162);
        h.put("a184", 10163);
        h.put("a197", 10164);
        h.put("a185", 10165);
        h.put("a194", 10166);
        h.put("a198", 10167);
        h.put("a186", 10168);
        h.put("a195", 10169);
        h.put("a187", 10170);
        h.put("a188", 10171);
        h.put("a189", 10172);
        h.put("a190", 10173);
        h.put("a191", 10174);
        // UNKNOWN
        h.put("apple", 32);
        // END
        se = new char[256];
        mre = new char[256];
        wae = new char[256];
        pde = new char[256];
        sym = new char[256];
        zap = new char[256];
        for (int i = 0; i < 256; i++) {
            se[i] = '?';
            mre[i] = '?';
            wae[i] = '?';
            if (i > 040) {
                wae[i] =  (char)h.get("bullet").intValue();
            }
            pde[i] = '?';
            sym[i] = '?';
            zap[i] = '?';
        }
        pde[24] = (char) h.get("breve").intValue();
        pde[25] = (char) h.get("caron").intValue();
        pde[26] = (char) h.get("circumflex").intValue();
        pde[27] = (char) h.get("dotaccent").intValue();
        pde[28] = (char) h.get("hungarumlaut").intValue();
        pde[29] = (char) h.get("ogonek").intValue();
        pde[30] = (char) h.get("ring").intValue();
        pde[31] = (char) h.get("tilde").intValue();
        se[32] = (char) h.get("space").intValue();
        mre[32] = (char) h.get("space").intValue();
        wae[32] = (char) h.get("space").intValue();
        pde[32] = (char) h.get("space").intValue();
        se[33] = (char) h.get("exclam").intValue();
        mre[33] = (char) h.get("exclam").intValue();
        wae[33] = (char) h.get("exclam").intValue();
        pde[33] = (char) h.get("exclam").intValue();
        se[34] = (char) h.get("quotedbl").intValue();
        mre[34] = (char) h.get("quotedbl").intValue();
        wae[34] = (char) h.get("quotedbl").intValue();
        pde[34] = (char) h.get("quotedbl").intValue();
        se[35] = (char) h.get("numbersign").intValue();
        mre[35] = (char) h.get("numbersign").intValue();
        wae[35] = (char) h.get("numbersign").intValue();
        pde[35] = (char) h.get("numbersign").intValue();
        se[36] = (char) h.get("dollar").intValue();
        mre[36] = (char) h.get("dollar").intValue();
        wae[36] = (char) h.get("dollar").intValue();
        pde[36] = (char) h.get("dollar").intValue();
        se[37] = (char) h.get("percent").intValue();
        mre[37] = (char) h.get("percent").intValue();
        wae[37] = (char) h.get("percent").intValue();
        pde[37] = (char) h.get("percent").intValue();
        se[38] = (char) h.get("ampersand").intValue();
        mre[38] = (char) h.get("ampersand").intValue();
        wae[38] = (char) h.get("ampersand").intValue();
        pde[38] = (char) h.get("ampersand").intValue();
        se[39] = (char) h.get("quoteright").intValue();
        mre[39] = (char) h.get("quotesingle").intValue();
        wae[39] = (char) h.get("quotesingle").intValue();
        pde[39] = (char) h.get("quotesingle").intValue();
        se[40] = (char) h.get("parenleft").intValue();
        mre[40] = (char) h.get("parenleft").intValue();
        wae[40] = (char) h.get("parenleft").intValue();
        pde[40] = (char) h.get("parenleft").intValue();
        se[41] = (char) h.get("parenright").intValue();
        mre[41] = (char) h.get("parenright").intValue();
        wae[41] = (char) h.get("parenright").intValue();
        pde[41] = (char) h.get("parenright").intValue();
        se[42] = (char) h.get("asterisk").intValue();
        mre[42] = (char) h.get("asterisk").intValue();
        wae[42] = (char) h.get("asterisk").intValue();
        pde[42] = (char) h.get("asterisk").intValue();
        se[43] = (char) h.get("plus").intValue();
        mre[43] = (char) h.get("plus").intValue();
        wae[43] = (char) h.get("plus").intValue();
        pde[43] = (char) h.get("plus").intValue();
        se[44] = (char) h.get("comma").intValue();
        mre[44] = (char) h.get("comma").intValue();
        wae[44] = (char) h.get("comma").intValue();
        pde[44] = (char) h.get("comma").intValue();
        se[45] = (char) h.get("hyphen").intValue();
        mre[45] = (char) h.get("hyphen").intValue();
        wae[45] = (char) h.get("hyphen").intValue();
        pde[45] = (char) h.get("hyphen").intValue();
        se[46] = (char) h.get("period").intValue();
        mre[46] = (char) h.get("period").intValue();
        wae[46] = (char) h.get("period").intValue();
        pde[46] = (char) h.get("period").intValue();
        se[47] = (char) h.get("slash").intValue();
        mre[47] = (char) h.get("slash").intValue();
        wae[47] = (char) h.get("slash").intValue();
        pde[47] = (char) h.get("slash").intValue();
        se[48] = (char) h.get("zero").intValue();
        mre[48] = (char) h.get("zero").intValue();
        wae[48] = (char) h.get("zero").intValue();
        pde[48] = (char) h.get("zero").intValue();
        se[49] = (char) h.get("one").intValue();
        mre[49] = (char) h.get("one").intValue();
        wae[49] = (char) h.get("one").intValue();
        pde[49] = (char) h.get("one").intValue();
        se[50] = (char) h.get("two").intValue();
        mre[50] = (char) h.get("two").intValue();
        wae[50] = (char) h.get("two").intValue();
        pde[50] = (char) h.get("two").intValue();
        se[51] = (char) h.get("three").intValue();
        mre[51] = (char) h.get("three").intValue();
        wae[51] = (char) h.get("three").intValue();
        pde[51] = (char) h.get("three").intValue();
        se[52] = (char) h.get("four").intValue();
        mre[52] = (char) h.get("four").intValue();
        wae[52] = (char) h.get("four").intValue();
        pde[52] = (char) h.get("four").intValue();
        se[53] = (char) h.get("five").intValue();
        mre[53] = (char) h.get("five").intValue();
        wae[53] = (char) h.get("five").intValue();
        pde[53] = (char) h.get("five").intValue();
        se[54] = (char) h.get("six").intValue();
        mre[54] = (char) h.get("six").intValue();
        wae[54] = (char) h.get("six").intValue();
        pde[54] = (char) h.get("six").intValue();
        se[55] = (char) h.get("seven").intValue();
        mre[55] = (char) h.get("seven").intValue();
        wae[55] = (char) h.get("seven").intValue();
        pde[55] = (char) h.get("seven").intValue();
        se[56] = (char) h.get("eight").intValue();
        mre[56] = (char) h.get("eight").intValue();
        wae[56] = (char) h.get("eight").intValue();
        pde[56] = (char) h.get("eight").intValue();
        se[57] = (char) h.get("nine").intValue();
        mre[57] = (char) h.get("nine").intValue();
        wae[57] = (char) h.get("nine").intValue();
        pde[57] = (char) h.get("nine").intValue();
        se[58] = (char) h.get("colon").intValue();
        mre[58] = (char) h.get("colon").intValue();
        wae[58] = (char) h.get("colon").intValue();
        pde[58] = (char) h.get("colon").intValue();
        se[59] = (char) h.get("semicolon").intValue();
        mre[59] = (char) h.get("semicolon").intValue();
        wae[59] = (char) h.get("semicolon").intValue();
        pde[59] = (char) h.get("semicolon").intValue();
        se[60] = (char) h.get("less").intValue();
        mre[60] = (char) h.get("less").intValue();
        wae[60] = (char) h.get("less").intValue();
        pde[60] = (char) h.get("less").intValue();
        se[61] = (char) h.get("equal").intValue();
        mre[61] = (char) h.get("equal").intValue();
        wae[61] = (char) h.get("equal").intValue();
        pde[61] = (char) h.get("equal").intValue();
        se[62] = (char) h.get("greater").intValue();
        mre[62] = (char) h.get("greater").intValue();
        wae[62] = (char) h.get("greater").intValue();
        pde[62] = (char) h.get("greater").intValue();
        se[63] = (char) h.get("question").intValue();
        mre[63] = (char) h.get("question").intValue();
        wae[63] = (char) h.get("question").intValue();
        pde[63] = (char) h.get("question").intValue();
        se[64] = (char) h.get("at").intValue();
        mre[64] = (char) h.get("at").intValue();
        wae[64] = (char) h.get("at").intValue();
        pde[64] = (char) h.get("at").intValue();
        se[65] = (char) h.get("A").intValue();
        mre[65] = (char) h.get("A").intValue();
        wae[65] = (char) h.get("A").intValue();
        pde[65] = (char) h.get("A").intValue();
        se[66] = (char) h.get("B").intValue();
        mre[66] = (char) h.get("B").intValue();
        wae[66] = (char) h.get("B").intValue();
        pde[66] = (char) h.get("B").intValue();
        se[67] = (char) h.get("C").intValue();
        mre[67] = (char) h.get("C").intValue();
        wae[67] = (char) h.get("C").intValue();
        pde[67] = (char) h.get("C").intValue();
        se[68] = (char) h.get("D").intValue();
        mre[68] = (char) h.get("D").intValue();
        wae[68] = (char) h.get("D").intValue();
        pde[68] = (char) h.get("D").intValue();
        se[69] = (char) h.get("E").intValue();
        mre[69] = (char) h.get("E").intValue();
        wae[69] = (char) h.get("E").intValue();
        pde[69] = (char) h.get("E").intValue();
        se[70] = (char) h.get("F").intValue();
        mre[70] = (char) h.get("F").intValue();
        wae[70] = (char) h.get("F").intValue();
        pde[70] = (char) h.get("F").intValue();
        se[71] = (char) h.get("G").intValue();
        mre[71] = (char) h.get("G").intValue();
        wae[71] = (char) h.get("G").intValue();
        pde[71] = (char) h.get("G").intValue();
        se[72] = (char) h.get("H").intValue();
        mre[72] = (char) h.get("H").intValue();
        wae[72] = (char) h.get("H").intValue();
        pde[72] = (char) h.get("H").intValue();
        se[73] = (char) h.get("I").intValue();
        mre[73] = (char) h.get("I").intValue();
        wae[73] = (char) h.get("I").intValue();
        pde[73] = (char) h.get("I").intValue();
        se[74] = (char) h.get("J").intValue();
        mre[74] = (char) h.get("J").intValue();
        wae[74] = (char) h.get("J").intValue();
        pde[74] = (char) h.get("J").intValue();
        se[75] = (char) h.get("K").intValue();
        mre[75] = (char) h.get("K").intValue();
        wae[75] = (char) h.get("K").intValue();
        pde[75] = (char) h.get("K").intValue();
        se[76] = (char) h.get("L").intValue();
        mre[76] = (char) h.get("L").intValue();
        wae[76] = (char) h.get("L").intValue();
        pde[76] = (char) h.get("L").intValue();
        se[77] = (char) h.get("M").intValue();
        mre[77] = (char) h.get("M").intValue();
        wae[77] = (char) h.get("M").intValue();
        pde[77] = (char) h.get("M").intValue();
        se[78] = (char) h.get("N").intValue();
        mre[78] = (char) h.get("N").intValue();
        wae[78] = (char) h.get("N").intValue();
        pde[78] = (char) h.get("N").intValue();
        se[79] = (char) h.get("O").intValue();
        mre[79] = (char) h.get("O").intValue();
        wae[79] = (char) h.get("O").intValue();
        pde[79] = (char) h.get("O").intValue();
        se[80] = (char) h.get("P").intValue();
        mre[80] = (char) h.get("P").intValue();
        wae[80] = (char) h.get("P").intValue();
        pde[80] = (char) h.get("P").intValue();
        se[81] = (char) h.get("Q").intValue();
        mre[81] = (char) h.get("Q").intValue();
        wae[81] = (char) h.get("Q").intValue();
        pde[81] = (char) h.get("Q").intValue();
        se[82] = (char) h.get("R").intValue();
        mre[82] = (char) h.get("R").intValue();
        wae[82] = (char) h.get("R").intValue();
        pde[82] = (char) h.get("R").intValue();
        se[83] = (char) h.get("S").intValue();
        mre[83] = (char) h.get("S").intValue();
        wae[83] = (char) h.get("S").intValue();
        pde[83] = (char) h.get("S").intValue();
        se[84] = (char) h.get("T").intValue();
        mre[84] = (char) h.get("T").intValue();
        wae[84] = (char) h.get("T").intValue();
        pde[84] = (char) h.get("T").intValue();
        se[85] = (char) h.get("U").intValue();
        mre[85] = (char) h.get("U").intValue();
        wae[85] = (char) h.get("U").intValue();
        pde[85] = (char) h.get("U").intValue();
        se[86] = (char) h.get("V").intValue();
        mre[86] = (char) h.get("V").intValue();
        wae[86] = (char) h.get("V").intValue();
        pde[86] = (char) h.get("V").intValue();
        se[87] = (char) h.get("W").intValue();
        mre[87] = (char) h.get("W").intValue();
        wae[87] = (char) h.get("W").intValue();
        pde[87] = (char) h.get("W").intValue();
        se[88] = (char) h.get("X").intValue();
        mre[88] = (char) h.get("X").intValue();
        wae[88] = (char) h.get("X").intValue();
        pde[88] = (char) h.get("X").intValue();
        se[89] = (char) h.get("Y").intValue();
        mre[89] = (char) h.get("Y").intValue();
        wae[89] = (char) h.get("Y").intValue();
        pde[89] = (char) h.get("Y").intValue();
        se[90] = (char) h.get("Z").intValue();
        mre[90] = (char) h.get("Z").intValue();
        wae[90] = (char) h.get("Z").intValue();
        pde[90] = (char) h.get("Z").intValue();
        se[91] = (char) h.get("bracketleft").intValue();
        mre[91] = (char) h.get("bracketleft").intValue();
        wae[91] = (char) h.get("bracketleft").intValue();
        pde[91] = (char) h.get("bracketleft").intValue();
        se[92] = (char) h.get("backslash").intValue();
        mre[92] = (char) h.get("backslash").intValue();
        wae[92] = (char) h.get("backslash").intValue();
        pde[92] = (char) h.get("backslash").intValue();
        se[93] = (char) h.get("bracketright").intValue();
        mre[93] = (char) h.get("bracketright").intValue();
        wae[93] = (char) h.get("bracketright").intValue();
        pde[93] = (char) h.get("bracketright").intValue();
        se[94] = (char) h.get("asciicircum").intValue();
        mre[94] = (char) h.get("asciicircum").intValue();
        wae[94] = (char) h.get("asciicircum").intValue();
        pde[94] = (char) h.get("asciicircum").intValue();
        se[95] = (char) h.get("underscore").intValue();
        mre[95] = (char) h.get("underscore").intValue();
        wae[95] = (char) h.get("underscore").intValue();
        pde[95] = (char) h.get("underscore").intValue();
        se[96] = (char) h.get("quoteleft").intValue();
        mre[96] = (char) h.get("grave").intValue();
        wae[96] = (char) h.get("grave").intValue();
        pde[96] = (char) h.get("grave").intValue();
        se[97] = (char) h.get("a").intValue();
        mre[97] = (char) h.get("a").intValue();
        wae[97] = (char) h.get("a").intValue();
        pde[97] = (char) h.get("a").intValue();
        se[98] = (char) h.get("b").intValue();
        mre[98] = (char) h.get("b").intValue();
        wae[98] = (char) h.get("b").intValue();
        pde[98] = (char) h.get("b").intValue();
        se[99] = (char) h.get("c").intValue();
        mre[99] = (char) h.get("c").intValue();
        wae[99] = (char) h.get("c").intValue();
        pde[99] = (char) h.get("c").intValue();
        se[100] = (char) h.get("d").intValue();
        mre[100] = (char) h.get("d").intValue();
        wae[100] = (char) h.get("d").intValue();
        pde[100] = (char) h.get("d").intValue();
        se[101] = (char) h.get("e").intValue();
        mre[101] = (char) h.get("e").intValue();
        wae[101] = (char) h.get("e").intValue();
        pde[101] = (char) h.get("e").intValue();
        se[102] = (char) h.get("f").intValue();
        mre[102] = (char) h.get("f").intValue();
        wae[102] = (char) h.get("f").intValue();
        pde[102] = (char) h.get("f").intValue();
        se[103] = (char) h.get("g").intValue();
        mre[103] = (char) h.get("g").intValue();
        wae[103] = (char) h.get("g").intValue();
        pde[103] = (char) h.get("g").intValue();
        se[104] = (char) h.get("h").intValue();
        mre[104] = (char) h.get("h").intValue();
        wae[104] = (char) h.get("h").intValue();
        pde[104] = (char) h.get("h").intValue();
        se[105] = (char) h.get("i").intValue();
        mre[105] = (char) h.get("i").intValue();
        wae[105] = (char) h.get("i").intValue();
        pde[105] = (char) h.get("i").intValue();
        se[106] = (char) h.get("j").intValue();
        mre[106] = (char) h.get("j").intValue();
        wae[106] = (char) h.get("j").intValue();
        pde[106] = (char) h.get("j").intValue();
        se[107] = (char) h.get("k").intValue();
        mre[107] = (char) h.get("k").intValue();
        wae[107] = (char) h.get("k").intValue();
        pde[107] = (char) h.get("k").intValue();
        se[108] = (char) h.get("l").intValue();
        mre[108] = (char) h.get("l").intValue();
        wae[108] = (char) h.get("l").intValue();
        pde[108] = (char) h.get("l").intValue();
        se[109] = (char) h.get("m").intValue();
        mre[109] = (char) h.get("m").intValue();
        wae[109] = (char) h.get("m").intValue();
        pde[109] = (char) h.get("m").intValue();
        se[110] = (char) h.get("n").intValue();
        mre[110] = (char) h.get("n").intValue();
        wae[110] = (char) h.get("n").intValue();
        pde[110] = (char) h.get("n").intValue();
        se[111] = (char) h.get("o").intValue();
        mre[111] = (char) h.get("o").intValue();
        wae[111] = (char) h.get("o").intValue();
        pde[111] = (char) h.get("o").intValue();
        se[112] = (char) h.get("p").intValue();
        mre[112] = (char) h.get("p").intValue();
        wae[112] = (char) h.get("p").intValue();
        pde[112] = (char) h.get("p").intValue();
        se[113] = (char) h.get("q").intValue();
        mre[113] = (char) h.get("q").intValue();
        wae[113] = (char) h.get("q").intValue();
        pde[113] = (char) h.get("q").intValue();
        se[114] = (char) h.get("r").intValue();
        mre[114] = (char) h.get("r").intValue();
        wae[114] = (char) h.get("r").intValue();
        pde[114] = (char) h.get("r").intValue();
        se[115] = (char) h.get("s").intValue();
        mre[115] = (char) h.get("s").intValue();
        wae[115] = (char) h.get("s").intValue();
        pde[115] = (char) h.get("s").intValue();
        se[116] = (char) h.get("t").intValue();
        mre[116] = (char) h.get("t").intValue();
        wae[116] = (char) h.get("t").intValue();
        pde[116] = (char) h.get("t").intValue();
        se[117] = (char) h.get("u").intValue();
        mre[117] = (char) h.get("u").intValue();
        wae[117] = (char) h.get("u").intValue();
        pde[117] = (char) h.get("u").intValue();
        se[118] = (char) h.get("v").intValue();
        mre[118] = (char) h.get("v").intValue();
        wae[118] = (char) h.get("v").intValue();
        pde[118] = (char) h.get("v").intValue();
        se[119] = (char) h.get("w").intValue();
        mre[119] = (char) h.get("w").intValue();
        wae[119] = (char) h.get("w").intValue();
        pde[119] = (char) h.get("w").intValue();
        se[120] = (char) h.get("x").intValue();
        mre[120] = (char) h.get("x").intValue();
        wae[120] = (char) h.get("x").intValue();
        pde[120] = (char) h.get("x").intValue();
        se[121] = (char) h.get("y").intValue();
        mre[121] = (char) h.get("y").intValue();
        wae[121] = (char) h.get("y").intValue();
        pde[121] = (char) h.get("y").intValue();
        se[122] = (char) h.get("z").intValue();
        mre[122] = (char) h.get("z").intValue();
        wae[122] = (char) h.get("z").intValue();
        pde[122] = (char) h.get("z").intValue();
        se[123] = (char) h.get("braceleft").intValue();
        mre[123] = (char) h.get("braceleft").intValue();
        wae[123] = (char) h.get("braceleft").intValue();
        pde[123] = (char) h.get("braceleft").intValue();
        se[124] = (char) h.get("bar").intValue();
        mre[124] = (char) h.get("bar").intValue();
        wae[124] = (char) h.get("bar").intValue();
        pde[124] = (char) h.get("bar").intValue();
        se[125] = (char) h.get("braceright").intValue();
        mre[125] = (char) h.get("braceright").intValue();
        wae[125] = (char) h.get("braceright").intValue();
        pde[125] = (char) h.get("braceright").intValue();
        se[126] = (char) h.get("asciitilde").intValue();
        mre[126] = (char) h.get("asciitilde").intValue();
        wae[126] = (char) h.get("asciitilde").intValue();
        pde[126] = (char) h.get("asciitilde").intValue();
        wae[127] = (char) h.get("bullet").intValue();
        mre[128] = (char) h.get("Adieresis").intValue();
        wae[128] = (char) h.get("Euro").intValue();
        pde[128] = (char) h.get("bullet").intValue();
        mre[129] = (char) h.get("Aring").intValue();
        wae[129] = (char) h.get("bullet").intValue();
        pde[129] = (char) h.get("dagger").intValue();
        mre[130] = (char) h.get("Ccedilla").intValue();
        wae[130] = (char) h.get("quotesinglbase").intValue();
        pde[130] = (char) h.get("daggerdbl").intValue();
        mre[131] = (char) h.get("Eacute").intValue();
        wae[131] = (char) h.get("florin").intValue();
        pde[131] = (char) h.get("ellipsis").intValue();
        mre[132] = (char) h.get("Ntilde").intValue();
        wae[132] = (char) h.get("quotedblbase").intValue();
        pde[132] = (char) h.get("emdash").intValue();
        mre[133] = (char) h.get("Odieresis").intValue();
        wae[133] = (char) h.get("ellipsis").intValue();
        pde[133] = (char) h.get("endash").intValue();
        mre[134] = (char) h.get("Udieresis").intValue();
        wae[134] = (char) h.get("dagger").intValue();
        pde[134] = (char) h.get("florin").intValue();
        mre[135] = (char) h.get("aacute").intValue();
        wae[135] = (char) h.get("daggerdbl").intValue();
        pde[135] = (char) h.get("fraction").intValue();
        mre[136] = (char) h.get("agrave").intValue();
        wae[136] = (char) h.get("circumflex").intValue();
        pde[136] = (char) h.get("guilsinglleft").intValue();
        mre[137] = (char) h.get("acircumflex").intValue();
        wae[137] = (char) h.get("perthousand").intValue();
        pde[137] = (char) h.get("guilsinglright").intValue();
        mre[138] = (char) h.get("adieresis").intValue();
        wae[138] = (char) h.get("Scaron").intValue();
        pde[138] = (char) h.get("minus").intValue();
        mre[139] = (char) h.get("atilde").intValue();
        wae[139] = (char) h.get("guilsinglleft").intValue();
        pde[139] = (char) h.get("perthousand").intValue();
        mre[140] = (char) h.get("aring").intValue();
        wae[140] = (char) h.get("OE").intValue();
        pde[140] = (char) h.get("quotedblbase").intValue();
        mre[141] = (char) h.get("ccedilla").intValue();
        wae[141] = (char) h.get("bullet").intValue();
        pde[141] = (char) h.get("quotedblleft").intValue();
        mre[142] = (char) h.get("eacute").intValue();
        wae[142] = (char) h.get("Zcaron").intValue();
        pde[142] = (char) h.get("quotedblright").intValue();
        mre[143] = (char) h.get("egrave").intValue();
        wae[143] = (char) h.get("bullet").intValue();
        pde[143] = (char) h.get("quoteleft").intValue();
        mre[144] = (char) h.get("ecircumflex").intValue();
        wae[144] = (char) h.get("bullet").intValue();
        pde[144] = (char) h.get("quoteright").intValue();
        mre[145] = (char) h.get("edieresis").intValue();
        wae[145] = (char) h.get("quoteleft").intValue();
        pde[145] = (char) h.get("quotesinglbase").intValue();
        mre[146] = (char) h.get("iacute").intValue();
        wae[146] = (char) h.get("quoteright").intValue();
        pde[146] = (char) h.get("trademark").intValue();
        mre[147] = (char) h.get("igrave").intValue();
        wae[147] = (char) h.get("quotedblleft").intValue();
        pde[147] = (char) h.get("fi").intValue();
        mre[148] = (char) h.get("icircumflex").intValue();
        wae[148] = (char) h.get("quotedblright").intValue();
        pde[148] = (char) h.get("fl").intValue();
        mre[149] = (char) h.get("idieresis").intValue();
        wae[149] = (char) h.get("bullet").intValue();
        pde[149] = (char) h.get("Lslash").intValue();
        mre[150] = (char) h.get("ntilde").intValue();
        wae[150] = (char) h.get("endash").intValue();
        pde[150] = (char) h.get("OE").intValue();
        mre[151] = (char) h.get("oacute").intValue();
        wae[151] = (char) h.get("emdash").intValue();
        pde[151] = (char) h.get("Scaron").intValue();
        mre[152] = (char) h.get("ograve").intValue();
        wae[152] = (char) h.get("tilde").intValue();
        pde[152] = (char) h.get("Ydieresis").intValue();
        mre[153] = (char) h.get("ocircumflex").intValue();
        wae[153] = (char) h.get("trademark").intValue();
        pde[153] = (char) h.get("Zcaron").intValue();
        mre[154] = (char) h.get("odieresis").intValue();
        wae[154] = (char) h.get("scaron").intValue();
        pde[154] = (char) h.get("dotlessi").intValue();
        mre[155] = (char) h.get("otilde").intValue();
        wae[155] = (char) h.get("guilsinglright").intValue();
        pde[155] = (char) h.get("lslash").intValue();
        mre[156] = (char) h.get("uacute").intValue();
        wae[156] = (char) h.get("oe").intValue();
        pde[156] = (char) h.get("oe").intValue();
        mre[157] = (char) h.get("ugrave").intValue();
        wae[157] = (char) h.get("bullet").intValue();
        pde[157] = (char) h.get("scaron").intValue();
        mre[158] = (char) h.get("ucircumflex").intValue();
        wae[158] = (char) h.get("zcaron").intValue();
        pde[158] = (char) h.get("zcaron").intValue();
        mre[159] = (char) h.get("udieresis").intValue();
        wae[159] = (char) h.get("Ydieresis").intValue();
        mre[160] = (char) h.get("dagger").intValue();
        wae[160] = (char) h.get("space").intValue();
        pde[160] = (char) h.get("Euro").intValue();
        se[161] = (char) h.get("exclamdown").intValue();
        mre[161] = (char) h.get("degree").intValue();
        wae[161] = (char) h.get("exclamdown").intValue();
        pde[161] = (char) h.get("exclamdown").intValue();
        se[162] = (char) h.get("cent").intValue();
        mre[162] = (char) h.get("cent").intValue();
        wae[162] = (char) h.get("cent").intValue();
        pde[162] = (char) h.get("cent").intValue();
        se[163] = (char) h.get("sterling").intValue();
        mre[163] = (char) h.get("sterling").intValue();
        wae[163] = (char) h.get("sterling").intValue();
        pde[163] = (char) h.get("sterling").intValue();
        se[164] = (char) h.get("fraction").intValue();
        mre[164] = (char) h.get("section").intValue();
        wae[164] = (char) h.get("currency").intValue();
        pde[164] = (char) h.get("currency").intValue();
        se[165] = (char) h.get("yen").intValue();
        mre[165] = (char) h.get("bullet").intValue();
        wae[165] = (char) h.get("yen").intValue();
        pde[165] = (char) h.get("yen").intValue();
        se[166] = (char) h.get("florin").intValue();
        mre[166] = (char) h.get("paragraph").intValue();
        wae[166] = (char) h.get("brokenbar").intValue();
        pde[166] = (char) h.get("brokenbar").intValue();
        se[167] = (char) h.get("section").intValue();
        mre[167] = (char) h.get("germandbls").intValue();
        wae[167] = (char) h.get("section").intValue();
        pde[167] = (char) h.get("section").intValue();
        se[168] = (char) h.get("currency").intValue();
        mre[168] = (char) h.get("registered").intValue();
        wae[168] = (char) h.get("dieresis").intValue();
        pde[168] = (char) h.get("dieresis").intValue();
        se[169] = (char) h.get("quotesingle").intValue();
        mre[169] = (char) h.get("copyright").intValue();
        wae[169] = (char) h.get("copyright").intValue();
        pde[169] = (char) h.get("copyright").intValue();
        se[170] = (char) h.get("quotedblleft").intValue();
        mre[170] = (char) h.get("trademark").intValue();
        wae[170] = (char) h.get("ordfeminine").intValue();
        pde[170] = (char) h.get("ordfeminine").intValue();
        se[171] = (char) h.get("guillemotleft").intValue();
        mre[171] = (char) h.get("acute").intValue();
        wae[171] = (char) h.get("guillemotleft").intValue();
        pde[171] = (char) h.get("guillemotleft").intValue();
        se[172] = (char) h.get("guilsinglleft").intValue();
        mre[172] = (char) h.get("dieresis").intValue();
        wae[172] = (char) h.get("logicalnot").intValue();
        pde[172] = (char) h.get("logicalnot").intValue();
        se[173] = (char) h.get("guilsinglright").intValue();
        wae[173] = (char) h.get("hyphen").intValue();
        se[174] = (char) h.get("fi").intValue();
        mre[174] = (char) h.get("AE").intValue();
        wae[174] = (char) h.get("registered").intValue();
        pde[174] = (char) h.get("registered").intValue();
        se[175] = (char) h.get("fl").intValue();
        mre[175] = (char) h.get("Oslash").intValue();
        wae[175] = (char) h.get("macron").intValue();
        pde[175] = (char) h.get("macron").intValue();
        wae[176] = (char) h.get("degree").intValue();
        pde[176] = (char) h.get("degree").intValue();
        se[177] = (char) h.get("endash").intValue();
        mre[177] = (char) h.get("plusminus").intValue();
        wae[177] = (char) h.get("plusminus").intValue();
        pde[177] = (char) h.get("plusminus").intValue();
        se[178] = (char) h.get("dagger").intValue();
        wae[178] = (char) h.get("twosuperior").intValue();
        pde[178] = (char) h.get("twosuperior").intValue();
        se[179] = (char) h.get("daggerdbl").intValue();
        wae[179] = (char) h.get("threesuperior").intValue();
        pde[179] = (char) h.get("threesuperior").intValue();
        se[180] = (char) h.get("periodcentered").intValue();
        mre[180] = (char) h.get("yen").intValue();
        wae[180] = (char) h.get("acute").intValue();
        pde[180] = (char) h.get("acute").intValue();
        mre[181] = (char) h.get("mu").intValue();
        wae[181] = (char) h.get("mu").intValue();
        pde[181] = (char) h.get("mu").intValue();
        se[182] = (char) h.get("paragraph").intValue();
        wae[182] = (char) h.get("paragraph").intValue();
        pde[182] = (char) h.get("paragraph").intValue();
        se[183] = (char) h.get("bullet").intValue();
        wae[183] = (char) h.get("periodcentered").intValue();
        pde[183] = (char) h.get("periodcentered").intValue();
        se[184] = (char) h.get("quotesinglbase").intValue();
        wae[184] = (char) h.get("cedilla").intValue();
        pde[184] = (char) h.get("cedilla").intValue();
        se[185] = (char) h.get("quotedblbase").intValue();
        wae[185] = (char) h.get("onesuperior").intValue();
        pde[185] = (char) h.get("onesuperior").intValue();
        se[186] = (char) h.get("quotedblright").intValue();
        wae[186] = (char) h.get("ordmasculine").intValue();
        pde[186] = (char) h.get("ordmasculine").intValue();
        se[187] = (char) h.get("guillemotright").intValue();
        mre[187] = (char) h.get("ordfeminine").intValue();
        wae[187] = (char) h.get("guillemotright").intValue();
        pde[187] = (char) h.get("guillemotright").intValue();
        se[188] = (char) h.get("ellipsis").intValue();
        mre[188] = (char) h.get("ordmasculine").intValue();
        wae[188] = (char) h.get("onequarter").intValue();
        pde[188] = (char) h.get("onequarter").intValue();
        se[189] = (char) h.get("perthousand").intValue();
        wae[189] = (char) h.get("onehalf").intValue();
        pde[189] = (char) h.get("onehalf").intValue();
        mre[190] = (char) h.get("ae").intValue();
        wae[190] = (char) h.get("threequarters").intValue();
        pde[190] = (char) h.get("threequarters").intValue();
        se[191] = (char) h.get("questiondown").intValue();
        mre[191] = (char) h.get("oslash").intValue();
        wae[191] = (char) h.get("questiondown").intValue();
        pde[191] = (char) h.get("questiondown").intValue();
        mre[192] = (char) h.get("questiondown").intValue();
        wae[192] = (char) h.get("Agrave").intValue();
        pde[192] = (char) h.get("Agrave").intValue();
        se[193] = (char) h.get("grave").intValue();
        mre[193] = (char) h.get("exclamdown").intValue();
        wae[193] = (char) h.get("Aacute").intValue();
        pde[193] = (char) h.get("Aacute").intValue();
        se[194] = (char) h.get("acute").intValue();
        mre[194] = (char) h.get("logicalnot").intValue();
        wae[194] = (char) h.get("Acircumflex").intValue();
        pde[194] = (char) h.get("Acircumflex").intValue();
        se[195] = (char) h.get("circumflex").intValue();
        wae[195] = (char) h.get("Atilde").intValue();
        pde[195] = (char) h.get("Atilde").intValue();
        se[196] = (char) h.get("tilde").intValue();
        mre[196] = (char) h.get("florin").intValue();
        wae[196] = (char) h.get("Adieresis").intValue();
        pde[196] = (char) h.get("Adieresis").intValue();
        se[197] = (char) h.get("macron").intValue();
        wae[197] = (char) h.get("Aring").intValue();
        pde[197] = (char) h.get("Aring").intValue();
        se[198] = (char) h.get("breve").intValue();
        wae[198] = (char) h.get("AE").intValue();
        pde[198] = (char) h.get("AE").intValue();
        se[199] = (char) h.get("dotaccent").intValue();
        mre[199] = (char) h.get("guillemotleft").intValue();
        wae[199] = (char) h.get("Ccedilla").intValue();
        pde[199] = (char) h.get("Ccedilla").intValue();
        se[200] = (char) h.get("dieresis").intValue();
        mre[200] = (char) h.get("guillemotright").intValue();
        wae[200] = (char) h.get("Egrave").intValue();
        pde[200] = (char) h.get("Egrave").intValue();
        mre[201] = (char) h.get("ellipsis").intValue();
        wae[201] = (char) h.get("Eacute").intValue();
        pde[201] = (char) h.get("Eacute").intValue();
        se[202] = (char) h.get("ring").intValue();
        mre[202] = (char) h.get("space").intValue();
        wae[202] = (char) h.get("Ecircumflex").intValue();
        pde[202] = (char) h.get("Ecircumflex").intValue();
        se[203] = (char) h.get("cedilla").intValue();
        mre[203] = (char) h.get("Agrave").intValue();
        wae[203] = (char) h.get("Edieresis").intValue();
        pde[203] = (char) h.get("Edieresis").intValue();
        mre[204] = (char) h.get("Atilde").intValue();
        wae[204] = (char) h.get("Igrave").intValue();
        pde[204] = (char) h.get("Igrave").intValue();
        se[205] = (char) h.get("hungarumlaut").intValue();
        mre[205] = (char) h.get("Otilde").intValue();
        wae[205] = (char) h.get("Iacute").intValue();
        pde[205] = (char) h.get("Iacute").intValue();
        se[206] = (char) h.get("ogonek").intValue();
        mre[206] = (char) h.get("OE").intValue();
        wae[206] = (char) h.get("Icircumflex").intValue();
        pde[206] = (char) h.get("Icircumflex").intValue();
        se[207] = (char) h.get("caron").intValue();
        mre[207] = (char) h.get("oe").intValue();
        wae[207] = (char) h.get("Idieresis").intValue();
        pde[207] = (char) h.get("Idieresis").intValue();
        se[208] = (char) h.get("emdash").intValue();
        mre[208] = (char) h.get("endash").intValue();
        wae[208] = (char) h.get("Eth").intValue();
        pde[208] = (char) h.get("Eth").intValue();
        mre[209] = (char) h.get("emdash").intValue();
        wae[209] = (char) h.get("Ntilde").intValue();
        pde[209] = (char) h.get("Ntilde").intValue();
        mre[210] = (char) h.get("quotedblleft").intValue();
        wae[210] = (char) h.get("Ograve").intValue();
        pde[210] = (char) h.get("Ograve").intValue();
        mre[211] = (char) h.get("quotedblright").intValue();
        wae[211] = (char) h.get("Oacute").intValue();
        pde[211] = (char) h.get("Oacute").intValue();
        mre[212] = (char) h.get("quoteleft").intValue();
        wae[212] = (char) h.get("Ocircumflex").intValue();
        pde[212] = (char) h.get("Ocircumflex").intValue();
        mre[213] = (char) h.get("quoteright").intValue();
        wae[213] = (char) h.get("Otilde").intValue();
        pde[213] = (char) h.get("Otilde").intValue();
        mre[214] = (char) h.get("divide").intValue();
        wae[214] = (char) h.get("Odieresis").intValue();
        pde[214] = (char) h.get("Odieresis").intValue();
        wae[215] = (char) h.get("multiply").intValue();
        pde[215] = (char) h.get("multiply").intValue();
        mre[216] = (char) h.get("ydieresis").intValue();
        wae[216] = (char) h.get("Oslash").intValue();
        pde[216] = (char) h.get("Oslash").intValue();
        mre[217] = (char) h.get("Ydieresis").intValue();
        wae[217] = (char) h.get("Ugrave").intValue();
        pde[217] = (char) h.get("Ugrave").intValue();
        mre[218] = (char) h.get("fraction").intValue();
        wae[218] = (char) h.get("Uacute").intValue();
        pde[218] = (char) h.get("Uacute").intValue();
        mre[219] = (char) h.get("currency").intValue();
        wae[219] = (char) h.get("Ucircumflex").intValue();
        pde[219] = (char) h.get("Ucircumflex").intValue();
        mre[220] = (char) h.get("guilsinglleft").intValue();
        wae[220] = (char) h.get("Udieresis").intValue();
        pde[220] = (char) h.get("Udieresis").intValue();
        mre[221] = (char) h.get("guilsinglright").intValue();
        wae[221] = (char) h.get("Yacute").intValue();
        pde[221] = (char) h.get("Yacute").intValue();
        mre[222] = (char) h.get("fi").intValue();
        wae[222] = (char) h.get("Thorn").intValue();
        pde[222] = (char) h.get("Thorn").intValue();
        mre[223] = (char) h.get("fl").intValue();
        wae[223] = (char) h.get("germandbls").intValue();
        pde[223] = (char) h.get("germandbls").intValue();
        mre[224] = (char) h.get("daggerdbl").intValue();
        wae[224] = (char) h.get("agrave").intValue();
        pde[224] = (char) h.get("agrave").intValue();
        se[225] = (char) h.get("AE").intValue();
        mre[225] = (char) h.get("periodcentered").intValue();
        wae[225] = (char) h.get("aacute").intValue();
        pde[225] = (char) h.get("aacute").intValue();
        mre[226] = (char) h.get("quotesinglbase").intValue();
        wae[226] = (char) h.get("acircumflex").intValue();
        pde[226] = (char) h.get("acircumflex").intValue();
        se[227] = (char) h.get("ordfeminine").intValue();
        mre[227] = (char) h.get("quotedblbase").intValue();
        wae[227] = (char) h.get("atilde").intValue();
        pde[227] = (char) h.get("atilde").intValue();
        mre[228] = (char) h.get("perthousand").intValue();
        wae[228] = (char) h.get("adieresis").intValue();
        pde[228] = (char) h.get("adieresis").intValue();
        mre[229] = (char) h.get("Acircumflex").intValue();
        wae[229] = (char) h.get("aring").intValue();
        pde[229] = (char) h.get("aring").intValue();
        mre[230] = (char) h.get("Ecircumflex").intValue();
        wae[230] = (char) h.get("ae").intValue();
        pde[230] = (char) h.get("ae").intValue();
        mre[231] = (char) h.get("Aacute").intValue();
        wae[231] = (char) h.get("ccedilla").intValue();
        pde[231] = (char) h.get("ccedilla").intValue();
        se[232] = (char) h.get("Lslash").intValue();
        mre[232] = (char) h.get("Edieresis").intValue();
        wae[232] = (char) h.get("egrave").intValue();
        pde[232] = (char) h.get("egrave").intValue();
        se[233] = (char) h.get("Oslash").intValue();
        mre[233] = (char) h.get("Egrave").intValue();
        wae[233] = (char) h.get("eacute").intValue();
        pde[233] = (char) h.get("eacute").intValue();
        se[234] = (char) h.get("OE").intValue();
        mre[234] = (char) h.get("Iacute").intValue();
        wae[234] = (char) h.get("ecircumflex").intValue();
        pde[234] = (char) h.get("ecircumflex").intValue();
        se[235] = (char) h.get("ordmasculine").intValue();
        mre[235] = (char) h.get("Icircumflex").intValue();
        wae[235] = (char) h.get("edieresis").intValue();
        pde[235] = (char) h.get("edieresis").intValue();
        mre[236] = (char) h.get("Idieresis").intValue();
        wae[236] = (char) h.get("igrave").intValue();
        pde[236] = (char) h.get("igrave").intValue();
        mre[237] = (char) h.get("Igrave").intValue();
        wae[237] = (char) h.get("iacute").intValue();
        pde[237] = (char) h.get("iacute").intValue();
        mre[238] = (char) h.get("Oacute").intValue();
        wae[238] = (char) h.get("icircumflex").intValue();
        pde[238] = (char) h.get("icircumflex").intValue();
        mre[239] = (char) h.get("Ocircumflex").intValue();
        wae[239] = (char) h.get("idieresis").intValue();
        pde[239] = (char) h.get("idieresis").intValue();
        wae[240] = (char) h.get("eth").intValue();
        pde[240] = (char) h.get("eth").intValue();
        se[241] = (char) h.get("ae").intValue();
        mre[241] = (char) h.get("Ograve").intValue();
        wae[241] = (char) h.get("ntilde").intValue();
        pde[241] = (char) h.get("ntilde").intValue();
        mre[242] = (char) h.get("Uacute").intValue();
        wae[242] = (char) h.get("ograve").intValue();
        pde[242] = (char) h.get("ograve").intValue();
        mre[243] = (char) h.get("Ucircumflex").intValue();
        wae[243] = (char) h.get("oacute").intValue();
        pde[243] = (char) h.get("oacute").intValue();
        mre[244] = (char) h.get("Ugrave").intValue();
        wae[244] = (char) h.get("ocircumflex").intValue();
        pde[244] = (char) h.get("ocircumflex").intValue();
        se[245] = (char) h.get("dotlessi").intValue();
        mre[245] = (char) h.get("dotlessi").intValue();
        wae[245] = (char) h.get("otilde").intValue();
        pde[245] = (char) h.get("otilde").intValue();
        mre[246] = (char) h.get("circumflex").intValue();
        wae[246] = (char) h.get("odieresis").intValue();
        pde[246] = (char) h.get("odieresis").intValue();
        mre[247] = (char) h.get("tilde").intValue();
        wae[247] = (char) h.get("divide").intValue();
        pde[247] = (char) h.get("divide").intValue();
        se[248] = (char) h.get("lslash").intValue();
        mre[248] = (char) h.get("macron").intValue();
        wae[248] = (char) h.get("oslash").intValue();
        pde[248] = (char) h.get("oslash").intValue();
        se[249] = (char) h.get("oslash").intValue();
        mre[249] = (char) h.get("breve").intValue();
        wae[249] = (char) h.get("ugrave").intValue();
        pde[249] = (char) h.get("ugrave").intValue();
        se[250] = (char) h.get("oe").intValue();
        mre[250] = (char) h.get("dotaccent").intValue();
        wae[250] = (char) h.get("uacute").intValue();
        pde[250] = (char) h.get("uacute").intValue();
        se[251] = (char) h.get("germandbls").intValue();
        mre[251] = (char) h.get("ring").intValue();
        wae[251] = (char) h.get("ucircumflex").intValue();
        pde[251] = (char) h.get("ucircumflex").intValue();
        mre[252] = (char) h.get("cedilla").intValue();
        wae[252] = (char) h.get("udieresis").intValue();
        pde[252] = (char) h.get("udieresis").intValue();
        mre[253] = (char) h.get("hungarumlaut").intValue();
        wae[253] = (char) h.get("yacute").intValue();
        pde[253] = (char) h.get("yacute").intValue();
        mre[254] = (char) h.get("ogonek").intValue();
        wae[254] = (char) h.get("thorn").intValue();
        pde[254] = (char) h.get("thorn").intValue();
        mre[255] = (char) h.get("caron").intValue();
        wae[255] = (char) h.get("ydieresis").intValue();
        pde[255] = (char) h.get("ydieresis").intValue();

        // addition of white space mappings.        
        // Line feed
        se[10] = (char)h.get("space").intValue();
        mre[10] = (char)h.get("space").intValue();
        wae[10] = (char)h.get("space").intValue();
        // carriage return
        se[13] = (char) h.get("space").intValue();
        mre[13] = (char) h.get("space").intValue();
        wae[13] = (char) h.get("space").intValue();
        // tabs
        se[9] = (char) h.get("space").intValue();
        mre[9] = (char) h.get("space").intValue();
        wae[9] = (char) h.get("space").intValue();


        sym[0x20] = (char) h.get("space").intValue();
        sym[041] = (char) h.get("exclam").intValue();
        sym[042] = (char) h.get("universal").intValue();
        sym[043] = (char) h.get("numbersign").intValue();
        sym[044] = (char) h.get("existential").intValue();
        sym[045] = (char) h.get("percent").intValue();
        sym[046] = (char) h.get("ampersand").intValue();
        sym[047] = (char) h.get("suchthat").intValue();
        sym[050] = (char) h.get("parenleft").intValue();
        sym[051] = (char) h.get("parenright").intValue();
        sym[052] = (char) h.get("asteriskmath").intValue();
        sym[053] = (char) h.get("plus").intValue();
        sym[054] = (char) h.get("comma").intValue();
        sym[055] = (char) h.get("minus").intValue();
        sym[056] = (char) h.get("period").intValue();
        sym[057] = (char) h.get("slash").intValue();
        sym[060] = (char) h.get("zero").intValue();
        sym[061] = (char) h.get("one").intValue();
        sym[062] = (char) h.get("two").intValue();
        sym[063] = (char) h.get("three").intValue();
        sym[064] = (char) h.get("four").intValue();
        sym[065] = (char) h.get("five").intValue();
        sym[066] = (char) h.get("six").intValue();
        sym[067] = (char) h.get("seven").intValue();
        sym[070] = (char) h.get("eight").intValue();
        sym[071] = (char) h.get("nine").intValue();
        sym[072] = (char) h.get("colon").intValue();
        sym[073] = (char) h.get("semicolon").intValue();
        sym[074] = (char) h.get("less").intValue();
        sym[075] = (char) h.get("equal").intValue();
        sym[076] = (char) h.get("greater").intValue();
        sym[077] = (char) h.get("question").intValue();
        sym[0100] = (char) h.get("congruent").intValue();
        sym[0101] = (char) h.get("Alpha").intValue();
        sym[0102] = (char) h.get("Beta").intValue();
        sym[0103] = (char) h.get("Chi").intValue();
        sym[0104] = (char) h.get("Delta").intValue();
        sym[0105] = (char) h.get("Epsilon").intValue();
        sym[0106] = (char) h.get("Phi").intValue();
        sym[0107] = (char) h.get("Gamma").intValue();
        sym[0110] = (char) h.get("Eta").intValue();
        sym[0111] = (char) h.get("Iota").intValue();
        sym[0112] = (char) h.get("theta1").intValue();
        sym[0113] = (char) h.get("Kappa").intValue();
        sym[0114] = (char) h.get("Lambda").intValue();
        sym[0115] = (char) h.get("Mu").intValue();
        sym[0116] = (char) h.get("Nu").intValue();
        sym[0117] = (char) h.get("Omicron").intValue();
        sym[0120] = (char) h.get("Pi").intValue();
        sym[0121] = (char) h.get("Theta").intValue();
        sym[0122] = (char) h.get("Rho").intValue();
        sym[0123] = (char) h.get("Sigma").intValue();
        sym[0124] = (char) h.get("Tau").intValue();
        sym[0125] = (char) h.get("Upsilon").intValue();
        sym[0126] = (char) h.get("sigma1").intValue();
        sym[0127] = (char) h.get("Omega").intValue();
        sym[0130] = (char) h.get("Xi").intValue();
        sym[0131] = (char) h.get("Psi").intValue();
        sym[0132] = (char) h.get("Zeta").intValue();
        sym[0133] = (char) h.get("bracketleft").intValue();
        sym[0134] = (char) h.get("therefore").intValue();
        sym[0135] = (char) h.get("bracketright").intValue();
        sym[0136] = (char) h.get("perpendicular").intValue();
        sym[0137] = (char) h.get("underscore").intValue();
        sym[0140] = (char) h.get("radicalex").intValue();
        sym[0141] = (char) h.get("alpha").intValue();
        sym[0142] = (char) h.get("beta").intValue();
        sym[0143] = (char) h.get("chi").intValue();
        sym[0144] = (char) h.get("delta").intValue();
        sym[0145] = (char) h.get("epsilon").intValue();
        sym[0146] = (char) h.get("phi").intValue();
        sym[0147] = (char) h.get("gamma").intValue();
        sym[0150] = (char) h.get("eta").intValue();
        sym[0151] = (char) h.get("iota").intValue();
        sym[0152] = (char) h.get("phi1").intValue();
        sym[0153] = (char) h.get("kappa").intValue();
        sym[0154] = (char) h.get("lambda").intValue();
        sym[0155] = (char) h.get("mu").intValue();
        sym[0156] = (char) h.get("nu").intValue();
        sym[0157] = (char) h.get("omicron").intValue();
        sym[0160] = (char) h.get("pi").intValue();
        sym[0161] = (char) h.get("theta").intValue();
        sym[0162] = (char) h.get("rho").intValue();
        sym[0163] = (char) h.get("sigma").intValue();
        sym[0164] = (char) h.get("tau").intValue();
        sym[0165] = (char) h.get("upsilon").intValue();
        sym[0166] = (char) h.get("omega1").intValue();
        sym[0167] = (char) h.get("omega").intValue();
        sym[0170] = (char) h.get("xi").intValue();
        sym[0171] = (char) h.get("psi").intValue();
        sym[0172] = (char) h.get("zeta").intValue();
        sym[0173] = (char) h.get("braceleft").intValue();
        sym[0174] = (char) h.get("bar").intValue();
        sym[0175] = (char) h.get("braceright").intValue();
        sym[0176] = (char) h.get("similar").intValue();
        sym[0240] = (char) h.get("Euro").intValue();
        sym[0241] = (char) h.get("Upsilon1").intValue();
        sym[0242] = (char) h.get("minute").intValue();
        sym[0243] = (char) h.get("lessequal").intValue();
        sym[0244] = (char) h.get("fraction").intValue();
        sym[0245] = (char) h.get("infinity").intValue();
        sym[0246] = (char) h.get("florin").intValue();
        sym[0247] = (char) h.get("club").intValue();
        sym[0250] = (char) h.get("diamond").intValue();
        sym[0251] = (char) h.get("heart").intValue();
        sym[0252] = (char) h.get("spade").intValue();
        sym[0253] = (char) h.get("arrowboth").intValue();
        sym[0254] = (char) h.get("arrowleft").intValue();
        sym[0255] = (char) h.get("arrowup").intValue();
        sym[0256] = (char) h.get("arrowright").intValue();
        sym[0257] = (char) h.get("arrowdown").intValue();
        sym[0260] = (char) h.get("degree").intValue();
        sym[0261] = (char) h.get("plusminus").intValue();
        sym[0262] = (char) h.get("second").intValue();
        sym[0263] = (char) h.get("greaterequal").intValue();
        sym[0264] = (char) h.get("multiply").intValue();
        sym[0265] = (char) h.get("proportional").intValue();
        sym[0266] = (char) h.get("partialdiff").intValue();
        sym[0267] = (char) h.get("bullet").intValue();
        sym[0270] = (char) h.get("divide").intValue();
        sym[0271] = (char) h.get("notequal").intValue();
        sym[0272] = (char) h.get("equivalence").intValue();
        sym[0273] = (char) h.get("approxequal").intValue();
        sym[0274] = (char) h.get("ellipsis").intValue();
        sym[0275] = (char) h.get("arrowvertex").intValue();
        sym[0276] = (char) h.get("arrowhorizex").intValue();
        sym[0277] = (char) h.get("carriagereturn").intValue();
        sym[0300] = (char) h.get("aleph").intValue();
        sym[0301] = (char) h.get("Ifraktur").intValue();
        sym[0302] = (char) h.get("Rfraktur").intValue();
        sym[0303] = (char) h.get("weierstrass").intValue();
        sym[0304] = (char) h.get("circlemultiply").intValue();
        sym[0305] = (char) h.get("circleplus").intValue();
        sym[0306] = (char) h.get("emptyset").intValue();
        sym[0307] = (char) h.get("intersection").intValue();
        sym[0310] = (char) h.get("union").intValue();
        sym[0311] = (char) h.get("propersuperset").intValue();
        sym[0312] = (char) h.get("reflexsuperset").intValue();
        sym[0313] = (char) h.get("notsubset").intValue();
        sym[0314] = (char) h.get("propersubset").intValue();
        sym[0315] = (char) h.get("reflexsubset").intValue();
        sym[0316] = (char) h.get("element").intValue();
        sym[0317] = (char) h.get("notelement").intValue();
        sym[0320] = (char) h.get("angle").intValue();
        sym[0321] = (char) h.get("gradient").intValue();
        sym[0322] = (char) h.get("registerserif").intValue();
        sym[0323] = (char) h.get("copyrightserif").intValue();
        sym[0324] = (char) h.get("trademarkserif").intValue();
        sym[0325] = (char) h.get("product").intValue();
        sym[0326] = (char) h.get("radical").intValue();
        sym[0327] = (char) h.get("dotmath").intValue();
        sym[0330] = (char) h.get("logicalnot").intValue();
        sym[0331] = (char) h.get("logicaland").intValue();
        sym[0332] = (char) h.get("logicalor").intValue();
        sym[0333] = (char) h.get("arrowdblboth").intValue();
        sym[0334] = (char) h.get("arrowdblleft").intValue();
        sym[0335] = (char) h.get("arrowdblup").intValue();
        sym[0336] = (char) h.get("arrowdblright").intValue();
        sym[0337] = (char) h.get("arrowdbldown").intValue();
        sym[0340] = (char) h.get("lozenge").intValue();
        sym[0341] = (char) h.get("angleleft").intValue();
        sym[0342] = (char) h.get("registersans").intValue();
        sym[0343] = (char) h.get("copyrightsans").intValue();
        sym[0344] = (char) h.get("trademarksans").intValue();
        sym[0345] = (char) h.get("summation").intValue();
        sym[0346] = (char) h.get("parenlefttp").intValue();
        sym[0347] = (char) h.get("parenleftex").intValue();
        sym[0350] = (char) h.get("parenleftbt").intValue();
        sym[0351] = (char) h.get("bracketlefttp").intValue();
        sym[0352] = (char) h.get("bracketleftex").intValue();
        sym[0353] = (char) h.get("bracketleftbt").intValue();
        sym[0354] = (char) h.get("bracelefttp").intValue();
        sym[0355] = (char) h.get("braceleftmid").intValue();
        sym[0356] = (char) h.get("braceleftbt").intValue();
        sym[0357] = (char) h.get("braceex").intValue();
        sym[0361] = (char) h.get("angleright").intValue();
        sym[0362] = (char) h.get("integral").intValue();
        sym[0363] = (char) h.get("integraltp").intValue();
        sym[0364] = (char) h.get("integralex").intValue();
        sym[0365] = (char) h.get("integralbt").intValue();
        sym[0366] = (char) h.get("parenrighttp").intValue();
        sym[0367] = (char) h.get("parenrightex").intValue();
        sym[0370] = (char) h.get("parenrightbt").intValue();
        sym[0371] = (char) h.get("bracketrighttp").intValue();
        sym[0372] = (char) h.get("bracketrightex").intValue();
        sym[0373] = (char) h.get("bracketrightbt").intValue();
        sym[0374] = (char) h.get("bracerighttp").intValue();
        sym[0375] = (char) h.get("bracerightmid").intValue();
        sym[0376] = (char) h.get("bracerightbt").intValue();
        zap[32] = (char) h.get("space").intValue();
        zap[33] = (char) h.get("a1").intValue();
        zap[34] = (char) h.get("a2").intValue();
        zap[35] = (char) h.get("a202").intValue();
        zap[36] = (char) h.get("a3").intValue();
        zap[37] = (char) h.get("a4").intValue();
        zap[38] = (char) h.get("a5").intValue();
        zap[39] = (char) h.get("a119").intValue();
        zap[40] = (char) h.get("a118").intValue();
        zap[41] = (char) h.get("a117").intValue();
        zap[42] = (char) h.get("a11").intValue();
        zap[43] = (char) h.get("a12").intValue();
        zap[44] = (char) h.get("a13").intValue();
        zap[45] = (char) h.get("a14").intValue();
        zap[46] = (char) h.get("a15").intValue();
        zap[47] = (char) h.get("a16").intValue();
        zap[48] = (char) h.get("a105").intValue();
        zap[49] = (char) h.get("a17").intValue();
        zap[50] = (char) h.get("a18").intValue();
        zap[51] = (char) h.get("a19").intValue();
        zap[52] = (char) h.get("a20").intValue();
        zap[53] = (char) h.get("a21").intValue();
        zap[54] = (char) h.get("a22").intValue();
        zap[55] = (char) h.get("a23").intValue();
        zap[56] = (char) h.get("a24").intValue();
        zap[57] = (char) h.get("a25").intValue();
        zap[58] = (char) h.get("a26").intValue();
        zap[59] = (char) h.get("a27").intValue();
        zap[60] = (char) h.get("a28").intValue();
        zap[61] = (char) h.get("a6").intValue();
        zap[62] = (char) h.get("a7").intValue();
        zap[63] = (char) h.get("a8").intValue();
        zap[64] = (char) h.get("a9").intValue();
        zap[65] = (char) h.get("a10").intValue();
        zap[66] = (char) h.get("a29").intValue();
        zap[67] = (char) h.get("a30").intValue();
        zap[68] = (char) h.get("a31").intValue();
        zap[69] = (char) h.get("a32").intValue();
        zap[70] = (char) h.get("a33").intValue();
        zap[71] = (char) h.get("a34").intValue();
        zap[72] = (char) h.get("a35").intValue();
        zap[73] = (char) h.get("a36").intValue();
        zap[74] = (char) h.get("a37").intValue();
        zap[75] = (char) h.get("a38").intValue();
        zap[76] = (char) h.get("a39").intValue();
        zap[77] = (char) h.get("a40").intValue();
        zap[78] = (char) h.get("a41").intValue();
        zap[79] = (char) h.get("a42").intValue();
        zap[80] = (char) h.get("a43").intValue();
        zap[81] = (char) h.get("a44").intValue();
        zap[82] = (char) h.get("a45").intValue();
        zap[83] = (char) h.get("a46").intValue();
        zap[84] = (char) h.get("a47").intValue();
        zap[85] = (char) h.get("a48").intValue();
        zap[86] = (char) h.get("a49").intValue();
        zap[87] = (char) h.get("a50").intValue();
        zap[88] = (char) h.get("a51").intValue();
        zap[89] = (char) h.get("a52").intValue();
        zap[90] = (char) h.get("a53").intValue();
        zap[91] = (char) h.get("a54").intValue();
        zap[92] = (char) h.get("a55").intValue();
        zap[93] = (char) h.get("a56").intValue();
        zap[94] = (char) h.get("a57").intValue();
        zap[95] = (char) h.get("a58").intValue();
        zap[96] = (char) h.get("a59").intValue();
        zap[97] = (char) h.get("a60").intValue();
        zap[98] = (char) h.get("a61").intValue();
        zap[99] = (char) h.get("a62").intValue();
        zap[100] = (char) h.get("a63").intValue();
        zap[101] = (char) h.get("a64").intValue();
        zap[102] = (char) h.get("a65").intValue();
        zap[103] = (char) h.get("a66").intValue();
        zap[104] = (char) h.get("a67").intValue();
        zap[105] = (char) h.get("a68").intValue();
        zap[106] = (char) h.get("a69").intValue();
        zap[107] = (char) h.get("a70").intValue();
        zap[108] = (char) h.get("a71").intValue();
        zap[109] = (char) h.get("a72").intValue();
        zap[110] = (char) h.get("a73").intValue();
        zap[111] = (char) h.get("a74").intValue();
        zap[112] = (char) h.get("a203").intValue();
        zap[113] = (char) h.get("a75").intValue();
        zap[114] = (char) h.get("a204").intValue();
        zap[115] = (char) h.get("a76").intValue();
        zap[116] = (char) h.get("a77").intValue();
        zap[117] = (char) h.get("a78").intValue();
        zap[118] = (char) h.get("a79").intValue();
        zap[119] = (char) h.get("a81").intValue();
        zap[120] = (char) h.get("a82").intValue();
        zap[121] = (char) h.get("a83").intValue();
        zap[122] = (char) h.get("a84").intValue();
        zap[123] = (char) h.get("a97").intValue();
        zap[124] = (char) h.get("a98").intValue();
        zap[125] = (char) h.get("a99").intValue();
        zap[126] = (char) h.get("a100").intValue();
        zap[128] = (char) h.get("a89").intValue();
        zap[129] = (char) h.get("a90").intValue();
        zap[130] = (char) h.get("a93").intValue();
        zap[131] = (char) h.get("a94").intValue();
        zap[132] = (char) h.get("a91").intValue();
        zap[133] = (char) h.get("a92").intValue();
        zap[134] = (char) h.get("a205").intValue();
        zap[135] = (char) h.get("a85").intValue();
        zap[136] = (char) h.get("a206").intValue();
        zap[137] = (char) h.get("a86").intValue();
        zap[138] = (char) h.get("a87").intValue();
        zap[139] = (char) h.get("a88").intValue();
        zap[140] = (char) h.get("a95").intValue();
        zap[141] = (char) h.get("a96").intValue();
        zap[161] = (char) h.get("a101").intValue();
        zap[162] = (char) h.get("a102").intValue();
        zap[163] = (char) h.get("a103").intValue();
        zap[164] = (char) h.get("a104").intValue();
        zap[165] = (char) h.get("a106").intValue();
        zap[166] = (char) h.get("a107").intValue();
        zap[167] = (char) h.get("a108").intValue();
        zap[168] = (char) h.get("a112").intValue();
        zap[169] = (char) h.get("a111").intValue();
        zap[170] = (char) h.get("a110").intValue();
        zap[171] = (char) h.get("a109").intValue();
        zap[172] = (char) h.get("a120").intValue();
        zap[173] = (char) h.get("a121").intValue();
        zap[174] = (char) h.get("a122").intValue();
        zap[175] = (char) h.get("a123").intValue();
        zap[176] = (char) h.get("a124").intValue();
        zap[177] = (char) h.get("a125").intValue();
        zap[178] = (char) h.get("a126").intValue();
        zap[179] = (char) h.get("a127").intValue();
        zap[180] = (char) h.get("a128").intValue();
        zap[181] = (char) h.get("a129").intValue();
        zap[182] = (char) h.get("a130").intValue();
        zap[183] = (char) h.get("a131").intValue();
        zap[184] = (char) h.get("a132").intValue();
        zap[185] = (char) h.get("a133").intValue();
        zap[186] = (char) h.get("a134").intValue();
        zap[187] = (char) h.get("a135").intValue();
        zap[188] = (char) h.get("a136").intValue();
        zap[189] = (char) h.get("a137").intValue();
        zap[190] = (char) h.get("a138").intValue();
        zap[191] = (char) h.get("a139").intValue();
        zap[192] = (char) h.get("a140").intValue();
        zap[193] = (char) h.get("a141").intValue();
        zap[194] = (char) h.get("a142").intValue();
        zap[195] = (char) h.get("a143").intValue();
        zap[196] = (char) h.get("a144").intValue();
        zap[197] = (char) h.get("a145").intValue();
        zap[198] = (char) h.get("a146").intValue();
        zap[199] = (char) h.get("a147").intValue();
        zap[200] = (char) h.get("a148").intValue();
        zap[201] = (char) h.get("a149").intValue();
        zap[202] = (char) h.get("a150").intValue();
        zap[203] = (char) h.get("a151").intValue();
        zap[204] = (char) h.get("a152").intValue();
        zap[205] = (char) h.get("a153").intValue();
        zap[206] = (char) h.get("a154").intValue();
        zap[207] = (char) h.get("a155").intValue();
        zap[208] = (char) h.get("a156").intValue();
        zap[209] = (char) h.get("a157").intValue();
        zap[210] = (char) h.get("a158").intValue();
        zap[211] = (char) h.get("a159").intValue();
        zap[212] = (char) h.get("a160").intValue();
        zap[213] = (char) h.get("a161").intValue();
        zap[214] = (char) h.get("a163").intValue();
        zap[215] = (char) h.get("a164").intValue();
        zap[216] = (char) h.get("a196").intValue();
        zap[217] = (char) h.get("a165").intValue();
        zap[218] = (char) h.get("a192").intValue();
        zap[219] = (char) h.get("a166").intValue();
        zap[220] = (char) h.get("a167").intValue();
        zap[221] = (char) h.get("a168").intValue();
        zap[222] = (char) h.get("a169").intValue();
        zap[223] = (char) h.get("a170").intValue();
        zap[224] = (char) h.get("a171").intValue();
        zap[225] = (char) h.get("a172").intValue();
        zap[226] = (char) h.get("a173").intValue();
        zap[227] = (char) h.get("a162").intValue();
        zap[228] = (char) h.get("a174").intValue();
        zap[229] = (char) h.get("a175").intValue();
        zap[230] = (char) h.get("a176").intValue();
        zap[231] = (char) h.get("a177").intValue();
        zap[232] = (char) h.get("a178").intValue();
        zap[233] = (char) h.get("a179").intValue();
        zap[234] = (char) h.get("a193").intValue();
        zap[235] = (char) h.get("a180").intValue();
        zap[236] = (char) h.get("a199").intValue();
        zap[237] = (char) h.get("a181").intValue();
        zap[238] = (char) h.get("a200").intValue();
        zap[239] = (char) h.get("a182").intValue();
        zap[241] = (char) h.get("a201").intValue();
        zap[242] = (char) h.get("a183").intValue();
        zap[243] = (char) h.get("a184").intValue();
        zap[244] = (char) h.get("a197").intValue();
        zap[245] = (char) h.get("a185").intValue();
        zap[246] = (char) h.get("a194").intValue();
        zap[247] = (char) h.get("a198").intValue();
        zap[248] = (char) h.get("a186").intValue();
        zap[249] = (char) h.get("a195").intValue();
        zap[250] = (char) h.get("a187").intValue();
        zap[251] = (char) h.get("a188").intValue();
        zap[252] = (char) h.get("a189").intValue();
        zap[253] = (char) h.get("a190").intValue();
        zap[254] = (char) h.get("a191").intValue();
    }
    /**
     * put your documentation comment here
     * @param s[]
     */
    /*    public static void main (String s[]) {
     System.out.println("zeta=" + getUV("zeta");
     System.out.println("yen=" + getUV("yen");
     System.out.println("A=" + getUV("A");
     System.out.println("Alpha=" + getUV("Alpha");
     }*/
}
